/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.actor.OneForOneStrategy;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.SupervisorStrategy$;
import org.apache.pekko.actor.TypedCreatorFunctionConsumer;
import org.apache.pekko.pattern.AutoReset;
import org.apache.pekko.pattern.BackoffOnFailureOptions;
import org.apache.pekko.pattern.BackoffOnStopOptions;
import org.apache.pekko.pattern.BackoffOptions;
import org.apache.pekko.pattern.BackoffSupervisor$GetCurrentChild$;
import org.apache.pekko.pattern.BackoffSupervisor$GetRestartCount$;
import org.apache.pekko.pattern.BackoffSupervisor$Reset$;
import org.apache.pekko.pattern.ForwardDeathLetters$;
import org.apache.pekko.pattern.internal.BackoffOnStopSupervisor;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.util.Try$;

public final class BackoffSupervisor$ {
    public static BackoffSupervisor$ MODULE$;

    static {
        new BackoffSupervisor$();
    }

    public Props props(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        return this.propsWithSupervisorStrategy(childProps, childName, minBackoff, maxBackoff, randomFactor, SupervisorStrategy$.MODULE$.defaultStrategy());
    }

    public Props props(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, int maxNrOfRetries) {
        SupervisorStrategy supervisorStrategy = SupervisorStrategy$.MODULE$.defaultStrategy();
        SupervisorStrategy supervisionStrategy = supervisorStrategy instanceof OneForOneStrategy ? ((OneForOneStrategy)supervisorStrategy).withMaxNrOfRetries(maxNrOfRetries) : supervisorStrategy;
        return this.propsWithSupervisorStrategy(childProps, childName, minBackoff, maxBackoff, randomFactor, supervisionStrategy);
    }

    /*
     * WARNING - void declaration
     */
    public Props props(Props childProps, String childName, java.time.Duration minBackoff, java.time.Duration maxBackoff, double randomFactor) {
        void asScala$extension_$this;
        void asScala$extension_$this2;
        java.time.Duration duration = JavaDurationConverters$.MODULE$.JavaDurationOps(minBackoff);
        if (JavaDurationConverters$JavaDurationOps$.MODULE$ == null) {
            throw null;
        }
        java.time.Duration duration2 = JavaDurationConverters$.MODULE$.JavaDurationOps(maxBackoff);
        if (JavaDurationConverters$JavaDurationOps$.MODULE$ == null) {
            throw null;
        }
        return this.props(childProps, childName, Duration$.MODULE$.fromNanos(asScala$extension_$this2.toNanos()), Duration$.MODULE$.fromNanos(asScala$extension_$this.toNanos()), randomFactor);
    }

    /*
     * WARNING - void declaration
     */
    public Props props(Props childProps, String childName, java.time.Duration minBackoff, java.time.Duration maxBackoff, double randomFactor, int maxNrOfRetries) {
        void asScala$extension_$this;
        void asScala$extension_$this2;
        java.time.Duration duration = JavaDurationConverters$.MODULE$.JavaDurationOps(minBackoff);
        if (JavaDurationConverters$JavaDurationOps$.MODULE$ == null) {
            throw null;
        }
        java.time.Duration duration2 = JavaDurationConverters$.MODULE$.JavaDurationOps(maxBackoff);
        if (JavaDurationConverters$JavaDurationOps$.MODULE$ == null) {
            throw null;
        }
        return this.props(childProps, childName, Duration$.MODULE$.fromNanos(asScala$extension_$this2.toNanos()), Duration$.MODULE$.fromNanos(asScala$extension_$this.toNanos()), randomFactor, maxNrOfRetries);
    }

    /*
     * WARNING - void declaration
     */
    public Props propsWithSupervisorStrategy(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, SupervisorStrategy strategy) {
        void apply_creator;
        void apply_evidence$2;
        Predef$.MODULE$.require(minBackoff.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable & scala.Serializable)() -> "minBackoff must be > 0");
        Predef$.MODULE$.require(maxBackoff.$greater$eq((Object)minBackoff), (Function0 & Serializable & scala.Serializable)() -> "maxBackoff must be >= minBackoff");
        Predef$.MODULE$.require(0.0 <= randomFactor && randomFactor <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "randomFactor must be between 0.0 and 1.0");
        Props$ props$ = Props$.MODULE$;
        ClassTag classTag = ClassTag$.MODULE$.apply(BackoffOnStopSupervisor.class);
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> new BackoffOnStopSupervisor(childProps, childName, minBackoff, maxBackoff, new AutoReset(minBackoff), randomFactor, strategy, ForwardDeathLetters$.MODULE$, (Option<Function1<Object, Object>>)None$.MODULE$);
        if (props$ == null) {
            throw null;
        }
        Props$ apply_this = props$;
        Class apply_mkProps_classOfActor = ((ClassTag)Predef$.MODULE$.implicitly((Object)apply_evidence$2)).runtimeClass();
        return apply_this.apply(TypedCreatorFunctionConsumer.class, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apply_mkProps_classOfActor, apply_creator}));
    }

    /*
     * WARNING - void declaration
     */
    public Props propsWithSupervisorStrategy(Props childProps, String childName, java.time.Duration minBackoff, java.time.Duration maxBackoff, double randomFactor, SupervisorStrategy strategy) {
        void asScala$extension_$this;
        void asScala$extension_$this2;
        java.time.Duration duration = JavaDurationConverters$.MODULE$.JavaDurationOps(minBackoff);
        if (JavaDurationConverters$JavaDurationOps$.MODULE$ == null) {
            throw null;
        }
        java.time.Duration duration2 = JavaDurationConverters$.MODULE$.JavaDurationOps(maxBackoff);
        if (JavaDurationConverters$JavaDurationOps$.MODULE$ == null) {
            throw null;
        }
        return this.propsWithSupervisorStrategy(childProps, childName, Duration$.MODULE$.fromNanos(asScala$extension_$this2.toNanos()), Duration$.MODULE$.fromNanos(asScala$extension_$this.toNanos()), randomFactor, strategy);
    }

    public Props props(BackoffOptions options) {
        return options.props();
    }

    public Props props(BackoffOnStopOptions options) {
        return options.props();
    }

    public Props props(BackoffOnFailureOptions options) {
        return options.props();
    }

    public BackoffSupervisor$GetCurrentChild$ getCurrentChild() {
        return BackoffSupervisor$GetCurrentChild$.MODULE$;
    }

    public BackoffSupervisor$Reset$ reset() {
        return BackoffSupervisor$Reset$.MODULE$;
    }

    public BackoffSupervisor$GetRestartCount$ getRestartCount() {
        return BackoffSupervisor$GetRestartCount$.MODULE$;
    }

    public FiniteDuration calculateDelay(int restartCount, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        double rnd = 1.0 + ThreadLocalRandom.current().nextDouble() * randomFactor;
        Duration calculatedDuration = (Duration)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> maxBackoff.min(minBackoff.$times(package$.MODULE$.pow(2.0, (double)restartCount))).$times(rnd)).getOrElse((Function0 & Serializable & scala.Serializable)() -> maxBackoff);
        if (calculatedDuration instanceof FiniteDuration) {
            return (FiniteDuration)calculatedDuration;
        }
        return maxBackoff;
    }

    private BackoffSupervisor$() {
        MODULE$ = this;
    }
}

