/*
 * Decompiled with CFR 0.152.
 */
package slick.jdbc;

import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;
import slick.jdbc.DriverDataSource;
import slick.jdbc.DriverDataSource$;

@ScalaSignature(bytes="\u0006\u0001I3A\u0001D\u0007\u0001%!)q\u0003\u0001C\u00011!9!\u0004\u0001b\u0001\n\u0013Y\u0002B\u0002\u0014\u0001A\u0003%A\u0004C\u0004(\u0001\t\u0007I\u0011B\u000e\t\r!\u0002\u0001\u0015!\u0003\u001d\u0011\u001dI\u0003A1A\u0005\nmAaA\u000b\u0001!\u0002\u0013a\u0002BB\u0016\u0001A\u0003&A\u0006C\u00035\u0001\u0011\u0005S\u0007\u0003\u0004:\u0001\u0001&IA\u000f\u0005\u0007!\u0002\u0001K\u0011B)\u0003+\u0011\u000bG/\u00192bg\u0016,&\u000f\u001c#bi\u0006\u001cv.\u001e:dK*\u0011abD\u0001\u0005U\u0012\u00147MC\u0001\u0011\u0003\u0015\u0019H.[2l\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q)R\"A\u0007\n\u0005Yi!\u0001\u0005#sSZ,'\u000fR1uCN{WO]2f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0015\u0001\u0005y\u0001k\\:uOJ,7OR;mYV\u0013H.F\u0001\u001d!\tiB%D\u0001\u001f\u0015\ty\u0002%\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\t\t#%\u0001\u0003vi&d'\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015r\"!\u0002*fO\u0016D\u0018\u0001\u0005)pgR<'/Z:Gk2dWK\u001d7!\u00031i\u0015p]9m\rVdG.\u0016:m\u00035i\u0015p]9m\rVdG.\u0016:mA\u0005)R*_:rY\u000e+8\u000f^8n!J|\u0007/\u001a:uS\u0016\u001c\u0018AF'zgFd7)^:u_6\u0004&o\u001c9feRLWm\u001d\u0011\u0002\u0017%t\u0017\u000e^5bY&TX\r\u001a\t\u0003[9j\u0011AI\u0005\u0003_\t\u0012qAQ8pY\u0016\fg\u000e\u000b\u0002\tcA\u0011QFM\u0005\u0003g\t\u0012\u0001B^8mCRLG.Z\u0001\u0005S:LG\u000fF\u00017!\tis'\u0003\u00029E\t!QK\\5u\u0003))\u0007\u0010\u001e:bGR,&\u000f\u001c\u000b\u0003w9\u0003B!\f\u001f?\u0019&\u0011QH\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00075z\u0014)\u0003\u0002AE\t1q\n\u001d;j_:\u0004\"AQ%\u000f\u0005\r;\u0005C\u0001##\u001b\u0005)%B\u0001$\u0012\u0003\u0019a$o\\8u}%\u0011\u0001JI\u0001\u0007!J,G-\u001a4\n\u0005)[%AB*ue&twM\u0003\u0002IEA\u0019QfP'\u0011\t5b\u0014)\u0011\u0005\u0006\u001f*\u0001\rAP\u0001\fI\u0006$\u0018MY1tKV\u0013H.\u0001\u0006eK\u001a\fW\u000f\u001c;Ve2$\u0012!\u0011")
public class DatabaseUrlDataSource
extends DriverDataSource {
    private final Regex PostgresFullUrl = new StringOps(Predef$.MODULE$.augmentString("^(?:postgres|postgresql)://([a-zA-Z0-9_]+)(?::([^@]+))?@([^/]+)/([^\\s]+)$")).r();
    private final Regex MysqlFullUrl = new StringOps(Predef$.MODULE$.augmentString("^mysql://([a-zA-Z0-9_]+)(?::([^@]+))?@([^/]+)/([^\\s]+)$")).r();
    private final Regex MysqlCustomProperties = new StringOps(Predef$.MODULE$.augmentString(".*\\?(.*)")).r();
    private volatile boolean initialized = false;

    private Regex PostgresFullUrl() {
        return this.PostgresFullUrl;
    }

    private Regex MysqlFullUrl() {
        return this.MysqlFullUrl;
    }

    private Regex MysqlCustomProperties() {
        return this.MysqlCustomProperties;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init() {
        if (!this.initialized) {
            void var3_3;
            void var2_2;
            Tuple2<Option<String>, Option<Tuple2<String, String>>> tuple2 = this.extractUrl((Option<String>)new Some((Object)(this.url() == null ? this.defaultUrl() : this.url())));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option jdbcUrl = (Option)tuple2._1();
            Option userAndPass = (Option)tuple2._2();
            void jdbcUrl2 = var2_2;
            void userAndPass2 = var3_3;
            this.url_$eq((String)jdbcUrl2.orNull(Predef$.MODULE$.$conforms()));
            this.user_$eq((String)userAndPass2.map((Function1 & java.io.Serializable & Serializable)x$2 -> (String)x$2._1()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> this.user()));
            this.password_$eq((String)userAndPass2.map((Function1 & java.io.Serializable & Serializable)x$3 -> (String)x$3._2()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> this.password()));
            this.initialized = true;
            super.init();
            return;
        }
    }

    private Tuple2<Option<String>, Option<Tuple2<String, String>>> extractUrl(Option<String> databaseUrl) {
        boolean bl = false;
        Some some = null;
        if (databaseUrl instanceof Some) {
            bl = true;
            some = (Some)databaseUrl;
            String string = (String)some.value();
            Option option = this.PostgresFullUrl().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
                String username = (String)((LinearSeqOptimized)option.get()).apply(0);
                String password = (String)((LinearSeqOptimized)option.get()).apply(1);
                String host = (String)((LinearSeqOptimized)option.get()).apply(2);
                String dbname = (String)((LinearSeqOptimized)option.get()).apply(3);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)new StringBuilder(19).append("jdbc:postgresql://").append(host).append("/").append(dbname).toString())), (Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)username), (Object)password)));
            }
        }
        if (bl) {
            String url = (String)some.value();
            Option option = this.MysqlFullUrl().unapplySeq((CharSequence)url);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
                String username = (String)((LinearSeqOptimized)option.get()).apply(0);
                String password = (String)((LinearSeqOptimized)option.get()).apply(1);
                String host = (String)((LinearSeqOptimized)option.get()).apply(2);
                String dbname = (String)((LinearSeqOptimized)option.get()).apply(3);
                String defaultProperties = "?useUnicode=yes&characterEncoding=UTF-8&connectionCollation=utf8_general_ci";
                String addDefaultPropertiesIfNeeded = (String)this.MysqlCustomProperties().findFirstMatchIn((CharSequence)url).map((Function1 & java.io.Serializable & Serializable)x$4 -> "").getOrElse((Function0 & java.io.Serializable & Serializable)() -> defaultProperties);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)new StringBuilder(14).append("jdbc:mysql://").append(host).append("/").append(dbname).append(addDefaultPropertiesIfNeeded).toString())), (Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)username), (Object)password)));
            }
        }
        if (bl) {
            String url = (String)some.value();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)url)), (Object)None$.MODULE$);
        }
        if (None$.MODULE$.equals(databaseUrl)) {
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)None$.MODULE$);
        }
        throw new MatchError(databaseUrl);
    }

    private String defaultUrl() {
        return System.getenv("DATABASE_URL");
    }

    public DatabaseUrlDataSource() {
        super(null, DriverDataSource$.MODULE$.$lessinit$greater$default$2(), DriverDataSource$.MODULE$.$lessinit$greater$default$3(), DriverDataSource$.MODULE$.$lessinit$greater$default$4(), DriverDataSource$.MODULE$.$lessinit$greater$default$5(), DriverDataSource$.MODULE$.$lessinit$greater$default$6(), DriverDataSource$.MODULE$.$lessinit$greater$default$7(), DriverDataSource$.MODULE$.$lessinit$greater$default$8());
    }
}

