/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.extend.filter.basic;

import com.github.xiaoymin.knife4j.extend.filter.basic.AbstractSecurityFilter;
import com.github.xiaoymin.knife4j.extend.util.FilterUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class JakartaServletSecurityBasicAuthFilter
extends AbstractSecurityFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
        this.initServletConfig(filterConfig.getInitParameterNames(), filterConfig.getInitParameter("enableBasicAuth"), filterConfig.getInitParameter("userName"), filterConfig.getInitParameter("password"));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String auth;
        Object sessionObject;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURI();
        if (this.tryCommonBasic(url, sessionObject = request.getSession().getAttribute("KNIFE4J_BASIC_AUTH_SESSION"), auth = request.getHeader("Authorization"))) {
            if (this.match(url) && sessionObject == null) {
                request.getSession().setAttribute("KNIFE4J_BASIC_AUTH_SESSION", (Object)this.getUserName());
            }
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            FilterUtils.writeJakartaForbiddenCode(response);
        }
    }

    public void destroy() {
        this.urlFilters = null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JakartaServletSecurityBasicAuthFilter)) {
            return false;
        }
        JakartaServletSecurityBasicAuthFilter other = (JakartaServletSecurityBasicAuthFilter)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JakartaServletSecurityBasicAuthFilter;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    public String toString() {
        return "JakartaServletSecurityBasicAuthFilter()";
    }
}

