/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange;
import org.apache.pekko.http.scaladsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.HttpCharsetRange;
import org.apache.pekko.http.scaladsl.model.HttpCharsetRange$;
import org.apache.pekko.http.scaladsl.model.HttpCharsetRange$$times$;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaRange$;
import org.apache.pekko.http.scaladsl.model.MediaRanges$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;

public final class ContentTypeRange$
implements Serializable {
    public static ContentTypeRange$ MODULE$;
    private final ContentTypeRange $times;

    static {
        new ContentTypeRange$();
    }

    public ContentTypeRange $times() {
        return this.$times;
    }

    public ContentTypeRange apply(MediaType mediaType) {
        return new ContentTypeRange(MediaRange$.MODULE$.apply(mediaType), HttpCharsetRange$$times$.MODULE$);
    }

    public ContentTypeRange apply(MediaRange mediaRange) {
        return new ContentTypeRange(mediaRange, HttpCharsetRange$$times$.MODULE$);
    }

    public ContentTypeRange apply(ContentType contentType) {
        if (contentType instanceof ContentType.Binary) {
            MediaType.Binary mt = ((ContentType.Binary)contentType).mediaType();
            return this.apply(mt);
        }
        if (contentType instanceof ContentType.WithFixedCharset) {
            MediaType.WithFixedCharset mt = ((ContentType.WithFixedCharset)contentType).mediaType();
            return this.apply(mt);
        }
        if (contentType instanceof ContentType.WithCharset) {
            ContentType.WithCharset withCharset = (ContentType.WithCharset)contentType;
            MediaType.WithOpenCharset mt = withCharset.mediaType();
            HttpCharset cs = withCharset.charset();
            return new ContentTypeRange(MediaRange$.MODULE$.apply(mt), HttpCharsetRange$.MODULE$.apply(cs));
        }
        if (contentType instanceof ContentType.WithMissingCharset) {
            MediaType.WithOpenCharset mt = ((ContentType.WithMissingCharset)contentType).mediaType();
            return this.apply(mt);
        }
        throw new MatchError((Object)contentType);
    }

    public ContentTypeRange apply(MediaRange mediaRange, HttpCharsetRange charsetRange) {
        return new ContentTypeRange(mediaRange, charsetRange);
    }

    public Option<Tuple2<MediaRange, HttpCharsetRange>> unapply(ContentTypeRange x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.mediaRange(), (Object)x$0.charsetRange()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ContentTypeRange$() {
        MODULE$ = this;
        this.$times = this.apply(MediaRanges$.MODULE$.$times$div$times());
    }
}

