/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.util.ByteArrayRendering$;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.http.impl.util.Renderer;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.parboiled2.CharPredicate;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!\u0002\u000b\u0016\u0001e\t\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011E\u0002!\u0011!Q\u0001\nIBQa\u0011\u0001\u0005\u0002\u0011CQa\u0011\u0001\u0005\u0002!CaA\u0013\u0001!B\u0013Y\u0005BB)\u0001A\u0003&a\u0006C\u0003S\u0001\u0011\u00051\u000bC\u0003U\u0001\u0011\u0005Q\u000bC\u0003U\u0001\u0011\u0005A\fC\u0003U\u0001\u0011\u0005q\fC\u0003g\u0001\u0011%q\rC\u0003k\u0001\u0011\u00051\u000eC\u0003m\u0001\u0011\u0005Q\u000eC\u0003o\u0001\u0011E3\u000eC\u0003p\u0001\u0011E\u0003o\u0002\u0005}+\u0005\u0005\t\u0012A\r~\r!!R#!A\t\u0002eq\b\"B\"\u0012\t\u0003y\b\"CA\u0001#E\u0005I\u0011AA\u0002\u0005I\u0011\u0015\u0010^3BeJ\f\u0017PU3oI\u0016\u0014\u0018N\\4\u000b\u0005Y9\u0012\u0001B;uS2T!\u0001G\r\u0002\t%l\u0007\u000f\u001c\u0006\u00035m\tA\u0001\u001b;ua*\u0011A$H\u0001\u0006a\u0016\\7n\u001c\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xmE\u0002\u0001E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007CA\u0015+\u001b\u0005)\u0012BA\u0016\u0016\u0005%\u0011VM\u001c3fe&tw-\u0001\u0005tSj,\u0007*\u001b8u\u0007\u0001\u0001\"aI\u0018\n\u0005A\"#aA%oi\u0006\u0011Bn\\4ESN\u001c\u0017M\u001d3fI\"+\u0017\rZ3s!\u0011\u00193'\u000e!\n\u0005Q\"#!\u0003$v]\u000e$\u0018n\u001c82!\t1TH\u0004\u00028wA\u0011\u0001\bJ\u0007\u0002s)\u0011!(L\u0001\u0007yI|w\u000e\u001e \n\u0005q\"\u0013A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001\u0010\u0013\u0011\u0005\r\n\u0015B\u0001\"%\u0005\u0011)f.\u001b;\u0002\rqJg.\u001b;?)\r)ei\u0012\t\u0003S\u0001AQ\u0001L\u0002A\u00029Bq!M\u0002\u0011\u0002\u0003\u0007!\u0007\u0006\u0002F\u0013\")A\u0006\u0002a\u0001]\u0005)\u0011M\u001d:bsB\u00191\u0005\u0014(\n\u00055##!B!se\u0006L\bCA\u0012P\u0013\t\u0001FE\u0001\u0003CsR,\u0017\u0001B:ju\u0016\f1aZ3u+\u0005Y\u0015\u0001\u0004\u0013uS2$W\r\n;jY\u0012,GC\u0001,X\u001b\u0005\u0001\u0001\"\u0002-\t\u0001\u0004I\u0016\u0001B2iCJ\u0004\"a\t.\n\u0005m##\u0001B\"iCJ$\"AV/\t\u000byK\u0001\u0019A&\u0002\u000b\tLH/Z:\u0015\u0005Y\u0003\u0007\"\u00020\u000b\u0001\u0004\t\u0007C\u00012e\u001b\u0005\u0019'B\u0001\f\u001c\u0013\t)7M\u0001\u0006CsR,7\u000b\u001e:j]\u001e\faa\u001a:po\nKHC\u0001\u0018i\u0011\u0015I7\u00021\u0001/\u0003\u0015!W\r\u001c;b\u0003E\u0011X-\\1j]&twmQ1qC\u000eLG/_\u000b\u0002]\u0005a\u0011m\u001d\"zi\u0016\u001cFO]5oOV\t\u0011-\u0001\u0003nCJ\\\u0017!B2iK\u000e\\GCA9u!\t\u0019#/\u0003\u0002tI\t9!i\\8mK\u0006t\u0007\"\u00028\u0010\u0001\u0004q\u0003F\u0001\u0001w!\t9(0D\u0001y\u0015\tI8$\u0001\u0006b]:|G/\u0019;j_:L!a\u001f=\u0003\u0017%sG/\u001a:oC2\f\u0005/[\u0001\u0013\u0005f$X-\u0011:sCf\u0014VM\u001c3fe&tw\r\u0005\u0002*#M\u0011\u0011C\t\u000b\u0002{\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!!\u0002+\u0007I\n9a\u000b\u0002\u0002\nA!\u00111BA\n\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011!C;oG\",7m[3e\u0015\tIH%\u0003\u0003\u0002\u0016\u00055!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
@InternalApi
public class ByteArrayRendering
implements Rendering {
    private final Function1<String, BoxedUnit> logDiscardedHeader;
    private byte[] array;
    private int size;

    public static Function1<String, BoxedUnit> $lessinit$greater$default$2() {
        return ByteArrayRendering$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public Rendering $tilde$tilde(float f) {
        return Rendering.$tilde$tilde$((Rendering)this, f);
    }

    @Override
    public Rendering $tilde$tilde(double d) {
        return Rendering.$tilde$tilde$((Rendering)this, d);
    }

    @Override
    public Rendering $tilde$tilde(int i) {
        return Rendering.$tilde$tilde$((Rendering)this, i);
    }

    @Override
    public Rendering $tilde$tilde(long l) {
        return Rendering.$tilde$tilde$((Rendering)this, l);
    }

    @Override
    public Rendering $tilde$tilde$percent(int i) {
        return Rendering.$tilde$tilde$percent$((Rendering)this, i);
    }

    @Override
    public Rendering $tilde$tilde$percent(long lng) {
        return Rendering.$tilde$tilde$percent$((Rendering)this, lng);
    }

    @Override
    public Rendering $tilde$tilde(String string) {
        return Rendering.$tilde$tilde$((Rendering)this, string);
    }

    @Override
    public Rendering $tilde$tilde(char[] chars) {
        return Rendering.$tilde$tilde$((Rendering)this, chars);
    }

    @Override
    public Rendering $tilde$tilde(HttpHeader header) {
        return Rendering.$tilde$tilde$((Rendering)this, header);
    }

    @Override
    public <T> Rendering $tilde$tilde(T value, Renderer<T> ev) {
        return Rendering.$tilde$tilde$(this, value, ev);
    }

    @Override
    public Rendering $tilde$tilde$hash(String s2) {
        return Rendering.$tilde$tilde$hash$(this, s2);
    }

    @Override
    public Rendering $tilde$tilde$hash$bang(String s2) {
        return Rendering.$tilde$tilde$hash$bang$(this, s2);
    }

    @Override
    public Rendering putEscaped(String s2, CharPredicate escape, char escChar) {
        return Rendering.putEscaped$(this, s2, escape, escChar);
    }

    @Override
    public CharPredicate putEscaped$default$2() {
        return Rendering.putEscaped$default$2$(this);
    }

    @Override
    public char putEscaped$default$3() {
        return Rendering.putEscaped$default$3$(this);
    }

    @Override
    public Rendering putReplaced(String s2, CharPredicate keep, char placeholder) {
        return Rendering.putReplaced$(this, s2, keep, placeholder);
    }

    public byte[] get() {
        if (this.size == this.array.length) {
            return this.array;
        }
        return Arrays.copyOfRange(this.array, 0, this.size);
    }

    @Override
    public ByteArrayRendering $tilde$tilde(char c) {
        int oldSize = this.growBy(1);
        this.array[oldSize] = (byte)c;
        return this;
    }

    @Override
    public ByteArrayRendering $tilde$tilde(byte[] bytes) {
        if (bytes.length > 0) {
            int oldSize = this.growBy(bytes.length);
            System.arraycopy(bytes, 0, this.array, oldSize, bytes.length);
        }
        return this;
    }

    @Override
    public ByteArrayRendering $tilde$tilde(ByteString bytes) {
        if (bytes.length() > 0) {
            int oldSize = this.growBy(bytes.length());
            bytes.copyToArray((Object)this.array, oldSize, bytes.length());
        }
        return this;
    }

    private int growBy(int delta) {
        int oldSize = this.size;
        long neededSize = (long)oldSize + (long)delta;
        if ((long)this.array.length < neededSize) {
            Predef$.MODULE$.require(neededSize < Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> "Cannot create byte array greater than 2GB in size");
            byte[] newArray = new byte[(int)package$.MODULE$.min(package$.MODULE$.max((long)this.array.length << 1, neededSize), Integer.MAX_VALUE)];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
        this.size = (int)neededSize;
        return oldSize;
    }

    public int remainingCapacity() {
        return this.array.length - this.size;
    }

    public ByteString asByteString() {
        return ByteString.ByteString1$.MODULE$.apply(this.array, 0, this.size);
    }

    @Override
    public int mark() {
        return this.size;
    }

    @Override
    public boolean check(int mark) {
        return this.rec$7(mark, mark);
    }

    private final boolean rec$7(int mark, int origMark$2) {
        while (mark < this.size) {
            if (this.array[mark] == 13 || this.array[mark] == 10) {
                this.logDiscardedHeader.apply((Object)new StringBuilder(39).append("Invalid outgoing header was discarded. ").append(LogByteStringTools$.MODULE$.printByteString(ByteString$.MODULE$.fromArray(this.array, origMark$2, this.size - origMark$2), LogByteStringTools$.MODULE$.printByteString$default$2(), LogByteStringTools$.MODULE$.printByteString$default$3(), LogByteStringTools$.MODULE$.printByteString$default$4())).toString());
                this.size = origMark$2;
                return false;
            }
            ++mark;
        }
        return true;
    }

    public ByteArrayRendering(int sizeHint, Function1<String, BoxedUnit> logDiscardedHeader) {
        this.logDiscardedHeader = logDiscardedHeader;
        Rendering.$init$(this);
        this.array = new byte[sizeHint];
        this.size = 0;
    }

    public ByteArrayRendering(int sizeHint) {
        this(sizeHint, (Function1<String, BoxedUnit>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$2) {
            }
        });
    }
}

