/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.rendering;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.util.ByteArrayRendering;
import org.apache.pekko.http.impl.util.ByteStringRendering;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.Renderer;
import org.apache.pekko.http.impl.util.Renderer$;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.Rendering$CrLf$;
import org.apache.pekko.http.impl.util.Rendering$Empty$;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$LastChunk$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.scaladsl.GraphDSL;
import org.apache.pekko.stream.scaladsl.GraphDSL$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.parboiled2.CharUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StringOps;

@InternalApi
public final class RenderSupport$ {
    public static RenderSupport$ MODULE$;
    private final byte[] DefaultStatusLineBytes;
    private final byte[] StatusLineStartBytes;
    private final byte[] ChunkedBytes;
    private final byte[] KeepAliveBytes;
    private final byte[] CloseBytes;
    private final byte[] CrLf;
    private final byte[] ContentLengthBytes;
    private final byte[] ApplicationJsonContentType;
    private final byte[] TextPlainContentType;
    private final byte[] TextXmlContentType;
    private final byte[] TextHtmlContentType;
    private final byte[] TextCsvContentType;
    private final Renderer<Iterable<HttpHeader>> trailerRenderer;
    private final ByteString defaultLastChunkBytes;

    static {
        new RenderSupport$();
    }

    public byte[] DefaultStatusLineBytes() {
        return this.DefaultStatusLineBytes;
    }

    public byte[] StatusLineStartBytes() {
        return this.StatusLineStartBytes;
    }

    public byte[] ChunkedBytes() {
        return this.ChunkedBytes;
    }

    public byte[] KeepAliveBytes() {
        return this.KeepAliveBytes;
    }

    public byte[] CloseBytes() {
        return this.CloseBytes;
    }

    public byte[] CrLf() {
        return this.CrLf;
    }

    public byte[] ContentLengthBytes() {
        return this.ContentLengthBytes;
    }

    private byte[] preRenderContentType(ContentType ct) {
        return ((ByteArrayRendering)new ByteArrayRendering(64).$tilde$tilde(Content$minusType$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(ct, Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(this.CrLf()).get();
    }

    private byte[] ApplicationJsonContentType() {
        return this.ApplicationJsonContentType;
    }

    private byte[] TextPlainContentType() {
        return this.TextPlainContentType;
    }

    private byte[] TextXmlContentType() {
        return this.TextXmlContentType;
    }

    private byte[] TextHtmlContentType() {
        return this.TextHtmlContentType;
    }

    private byte[] TextCsvContentType() {
        return this.TextCsvContentType;
    }

    public Renderer<Iterable<HttpHeader>> trailerRenderer() {
        return this.trailerRenderer;
    }

    public ByteString defaultLastChunkBytes() {
        return this.defaultLastChunkBytes;
    }

    public <T, Mat> Source<T, Mat> CancelSecond(Source<T, Mat> first, Source<T, Object> second) {
        return Source$.MODULE$.fromGraph(GraphDSL$.MODULE$.createGraph(first, (Function1 & Serializable & scala.Serializable)b -> (Function1 & Serializable & scala.Serializable)frst -> {
            new GraphDSL.Implicits$.SourceArrow(GraphDSL.Implicits$.MODULE$.SourceArrow((Graph)second)).$tilde$greater((Graph)Sink$.MODULE$.cancelled(), b);
            return new SourceShape(frst.out());
        }));
    }

    public Rendering renderEntityContentType(Rendering r, HttpEntity entity) {
        ContentType ct = entity.contentType();
        if (ct == ContentTypes$.MODULE$.NoContentType()) {
            return r;
        }
        if (ct == ContentTypes$.MODULE$.application$divjson()) {
            return r.$tilde$tilde(this.ApplicationJsonContentType());
        }
        if (ct == ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(this.TextPlainContentType());
        }
        if (ct == ContentTypes$.MODULE$.text$divxml$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(this.TextXmlContentType());
        }
        if (ct == ContentTypes$.MODULE$.text$divhtml$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(this.TextHtmlContentType());
        }
        if (ct == ContentTypes$.MODULE$.text$divcsv$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(this.TextCsvContentType());
        }
        return r.$tilde$tilde(Content$minusType$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(ct, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(this.CrLf());
    }

    public ByteString org$apache$pekko$http$impl$engine$rendering$RenderSupport$$renderChunk(HttpEntity.ChunkStreamPart chunk) {
        ByteStringRendering r;
        block7: {
            HttpEntity.LastChunk lastChunk;
            boolean bl;
            block8: {
                block6: {
                    int renderedSize = CharUtils$.MODULE$.numberOfHexDigits((long)chunk.data().length()) + (chunk.extension().isEmpty() ? 0 : chunk.extension().length() + 1) + chunk.data().length() + 2 + 2;
                    r = new ByteStringRendering(renderedSize);
                    r.$tilde$tilde$percent(chunk.data().length());
                    if (new StringOps(Predef$.MODULE$.augmentString(chunk.extension())).nonEmpty()) {
                        r.$tilde$tilde(';').$tilde$tilde(chunk.extension());
                    }
                    r.$tilde$tilde(this.CrLf());
                    bl = false;
                    lastChunk = null;
                    if (!(chunk instanceof HttpEntity.Chunk)) break block6;
                    ByteString data = ((HttpEntity.Chunk)chunk).data();
                    r.$tilde$tilde(data);
                    break block7;
                }
                if (!(chunk instanceof HttpEntity.LastChunk)) break block8;
                bl = true;
                lastChunk = (HttpEntity.LastChunk)chunk;
                Seq<HttpHeader> seq = lastChunk.trailer();
                if (Nil$.MODULE$.equals(seq)) break block7;
            }
            if (bl) {
                Seq<HttpHeader> trailer = lastChunk.trailer();
                ((ByteStringRendering)r.$tilde$tilde(trailer, this.trailerRenderer())).$tilde$tilde(this.CrLf());
            } else {
                throw new MatchError((Object)chunk);
            }
        }
        r.$tilde$tilde(this.CrLf());
        return r.get();
    }

    public void suppressionWarning(LoggingAdapter log, HttpHeader h, String msg) {
        log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)h, (Object)msg);
    }

    public String suppressionWarning$default$3() {
        return "the pekko-http-core layer sets this header automatically!";
    }

    private RenderSupport$() {
        MODULE$ = this;
        this.DefaultStatusLineBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("HTTP/1.1 200 OK\r\n"));
        this.StatusLineStartBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("HTTP/1.1 "));
        this.ChunkedBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("chunked"));
        this.KeepAliveBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("Keep-Alive"));
        this.CloseBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("close"));
        this.CrLf = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("\r\n"));
        this.ContentLengthBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("Content-Length: "));
        this.ApplicationJsonContentType = this.preRenderContentType(ContentTypes$.MODULE$.application$divjson());
        this.TextPlainContentType = this.preRenderContentType(ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029());
        this.TextXmlContentType = this.preRenderContentType(ContentTypes$.MODULE$.text$divxml$u0028UTF$minus8$u0029());
        this.TextHtmlContentType = this.preRenderContentType(ContentTypes$.MODULE$.text$divhtml$u0028UTF$minus8$u0029());
        this.TextCsvContentType = this.preRenderContentType(ContentTypes$.MODULE$.text$divcsv$u0028UTF$minus8$u0029());
        this.trailerRenderer = Renderer$.MODULE$.genericSeqRenderer(Rendering$CrLf$.MODULE$, Rendering$Empty$.MODULE$, Renderer$.MODULE$.renderableRenderer(), Renderer$.MODULE$.renderableRenderer());
        this.defaultLastChunkBytes = this.org$apache$pekko$http$impl$engine$rendering$RenderSupport$$renderChunk(HttpEntity$LastChunk$.MODULE$);
    }
}

