/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2.framing;

import java.nio.ByteOrder;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.http.impl.engine.http2.framing.FrameRenderer$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}uA\u0002\u0011\"\u0011\u0003\u0019\u0013G\u0002\u00044C!\u00051\u0005\u000e\u0005\u0006w\u0005!\t!\u0010\u0005\b}\u0005\u0011\r\u0011b\u0001@\u0011\u0019A\u0015\u0001)A\u0005\u0001\")\u0011*\u0001C\u0001\u0015\")q+\u0001C\u00011\u001e)\u00110\u0001E\u0005u\u001a)A0\u0001E\u0005{\")1\b\u0003C\u0001}\"1q\u0010\u0003C\u0001\u0003\u00031Q\u0001`\u0001\u0005\u0003\u000bA\u0011\"a\u0002\f\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011i[!\u0011!Q\u0001\nmC\u0001B\\\u0006\u0003\u0002\u0003\u0006Ia\u001c\u0005\tg.\u0011\t\u0011)A\u0005i\"11h\u0003C\u0001\u0003\u0013A\u0011\"a\u0005\f\u0005\u0004%I!!\u0006\t\u000f\u0005]1\u0002)A\u0005i\"I\u0011\u0011D\u0006C\u0002\u0013%\u00111\u0004\u0005\t\u0003SY\u0001\u0015!\u0003\u0002\u001e!I\u00111F\u0006A\u0002\u0013%\u0011Q\u0003\u0005\n\u0003[Y\u0001\u0019!C\u0005\u0003_Aq!a\u000f\fA\u0003&A\u000fC\u0004\u0002>-!\t!a\u0010\t\u000f\u0005u2\u0002\"\u0001\u0002T!9\u0011QL\u0006\u0005\u0002\u0005}\u0003bBA4\u0017\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003_ZA\u0011AA9\u0011\u001d\t)h\u0003C\u0001\u0003oBq!a\u001f\f\t\u0003\ti\bC\u0004\u0002\u0004.!\t!!\"\u0002\u001b\u0019\u0013\u0018-\\3SK:$WM]3s\u0015\t\u00113%A\u0004ge\u0006l\u0017N\\4\u000b\u0005\u0011*\u0013!\u00025uiB\u0014$B\u0001\u0014(\u0003\u0019)gnZ5oK*\u0011\u0001&K\u0001\u0005S6\u0004HN\u0003\u0002+W\u0005!\u0001\u000e\u001e;q\u0015\taS&A\u0003qK.\\wN\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<\u0007C\u0001\u001a\u0002\u001b\u0005\t#!\u0004$sC6,'+\u001a8eKJ,'o\u0005\u0002\u0002kA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002c\u0005I!-\u001f;f\u001fJ$WM]\u000b\u0002\u0001B\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0004]&|'\"A#\u0002\t)\fg/Y\u0005\u0003\u000f\n\u0013\u0011BQ=uK>\u0013H-\u001a:\u0002\u0015\tLH/Z(sI\u0016\u0014\b%\u0001\u0004sK:$WM\u001d\u000b\u0003\u0017F\u0003\"\u0001T(\u000e\u00035S!AT\u0016\u0002\tU$\u0018\u000e\\\u0005\u0003!6\u0013!BQ=uKN#(/\u001b8h\u0011\u0015\u0011V\u00011\u0001T\u0003\u00151'/Y7f!\t!V+D\u0001$\u0013\t16E\u0001\u0006Ge\u0006lW-\u0012<f]R\f1B]3oI\u0016\u0014hI]1nKR)1*W7so\")!L\u0002a\u00017\u0006\u0019A\u000f]3\u0011\u0005qSgBA/i\u001d\tqvM\u0004\u0002`M:\u0011\u0001-\u001a\b\u0003C\u0012t!AY2\u000e\u00035J!\u0001L\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\t1s%\u0003\u0002%K%\u0011\u0011nI\u0001\u000e\u0011R$\bO\r)s_R|7m\u001c7\n\u0005-d'!\u0003$sC6,G+\u001f9f\u0015\tI7\u0005C\u0003o\r\u0001\u0007q.A\u0003gY\u0006<7\u000f\u0005\u0002Ua&\u0011\u0011o\t\u0002\t\u0005f$XM\u00127bO\")1O\u0002a\u0001i\u0006A1\u000f\u001e:fC6LE\r\u0005\u00027k&\u0011ao\u000e\u0002\u0004\u0013:$\b\"\u0002=\u0007\u0001\u0004Y\u0015a\u00029bs2|\u0017\rZ\u0001\u0006\rJ\fW.\u001a\t\u0003w\"i\u0011!\u0001\u0002\u0006\rJ\fW.Z\n\u0003\u0011U\"\u0012A_\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0003\u0007\t9)!#\u0002\f\u00065\u0005CA>\f'\tYQ'A\u0006qCfdw.\u00193TSj,GCCA\u0002\u0003\u0017\ti!a\u0004\u0002\u0012!1\u0011q\u0001\tA\u0002QDQA\u0017\tA\u0002mCQA\u001c\tA\u0002=DQa\u001d\tA\u0002Q\f!\u0002^1sO\u0016$8+\u001b>f+\u0005!\u0018a\u0003;be\u001e,GoU5{K\u0002\naAY;gM\u0016\u0014XCAA\u000f!\u00151\u0014qDA\u0012\u0013\r\t\tc\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004m\u0005\u0015\u0012bAA\u0014o\t!!)\u001f;f\u0003\u001d\u0011WO\u001a4fe\u0002\n1\u0001]8t\u0003\u001d\u0001xn]0%KF$B!!\r\u00028A\u0019a'a\r\n\u0007\u0005UrG\u0001\u0003V]&$\b\u0002CA\u001d-\u0005\u0005\t\u0019\u0001;\u0002\u0007a$\u0013'\u0001\u0003q_N\u0004\u0013a\u00049viB\u0013\u0018n\u001c:jifLeNZ8\u0015\t\u0005\r\u0011\u0011\t\u0005\b\u0003\u0007B\u0002\u0019AA#\u00035\u0001(/[8sSRLhI]1nKB!\u0011qIA'\u001d\ri\u0016\u0011J\u0005\u0004\u0003\u0017\u001a\u0013A\u0003$sC6,WI^3oi&!\u0011qJA)\u00055\u0001&/[8sSRLhI]1nK*\u0019\u00111J\u0012\u0015\t\u0005\r\u0011Q\u000b\u0005\b\u0003\u0007J\u0002\u0019AA,!\u00151\u0014\u0011LA#\u0013\r\tYf\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u000fA,HOQ=uKR!\u0011\u0011MA2\u001b\u0005Y\u0001bBA35\u0001\u0007\u00111E\u0001\u0005Ef$X-\u0001\u0005qkRLe\u000e^\u001a3)\u0011\t\t'a\u001b\t\r\u000554\u00041\u0001u\u0003\u00151\u0018\r\\;f\u0003!\u0001X\u000f^%oiJ\"D\u0003BA1\u0003gBa!!\u001c\u001d\u0001\u0004!\u0018\u0001\u00039vi&sG/\r\u001c\u0015\t\u0005\u0005\u0014\u0011\u0010\u0005\u0007\u0003[j\u0002\u0019\u0001;\u0002\u0007A,H\u000f\u0006\u0003\u0002b\u0005}\u0004BBAA=\u0001\u00071*A\u0003csR,7/A\u0003ck&dG\rF\u0001L\u0011\u0019\t9A\u0003a\u0001i\")!L\u0003a\u00017\")aN\u0003a\u0001_\")1O\u0003a\u0001i\"\u001a\u0011!!%\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\u000b)JA\u0006J]R,'O\\1m\u0003BL\u0007f\u0001\u0001\u0002\u0012\u0002")
@InternalApi
public final class FrameRenderer {
    public static ByteString renderFrame(Http2Protocol.FrameType frameType, int n, int n2, ByteString byteString) {
        return FrameRenderer$.MODULE$.renderFrame(frameType, n, n2, byteString);
    }

    public static ByteString render(FrameEvent frameEvent) {
        return FrameRenderer$.MODULE$.render(frameEvent);
    }

    public static ByteOrder byteOrder() {
        return FrameRenderer$.MODULE$.byteOrder();
    }

    private static class Frame {
        private final int targetSize;
        private final byte[] buffer;
        private int pos;

        private int targetSize() {
            return this.targetSize;
        }

        private byte[] buffer() {
            return this.buffer;
        }

        private int pos() {
            return this.pos;
        }

        private void pos_$eq(int x$1) {
            this.pos = x$1;
        }

        public Frame putPriorityInfo(FrameEvent.PriorityFrame priorityFrame) {
            int exclusiveBit = priorityFrame.exclusiveFlag() ? Integer.MIN_VALUE : 0;
            this.putInt32(exclusiveBit | priorityFrame.streamDependency());
            return this.putByte((byte)priorityFrame.weight());
        }

        public Frame putPriorityInfo(Option<FrameEvent.PriorityFrame> priorityFrame) {
            if (priorityFrame instanceof Some) {
                FrameEvent.PriorityFrame p = (FrameEvent.PriorityFrame)((Some)priorityFrame).value();
                return this.putPriorityInfo(p);
            }
            if (None$.MODULE$.equals(priorityFrame)) {
                return this;
            }
            throw new MatchError(priorityFrame);
        }

        public Frame putByte(byte by) {
            this.buffer()[this.pos()] = by;
            this.pos_$eq(this.pos() + 1);
            return this;
        }

        public Frame putInt32(int value) {
            this.buffer()[this.pos() + 0] = (byte)(value >> 24);
            this.buffer()[this.pos() + 1] = (byte)(value >> 16);
            this.buffer()[this.pos() + 2] = (byte)(value >> 8);
            this.buffer()[this.pos() + 3] = (byte)(value >> 0);
            this.pos_$eq(this.pos() + 4);
            return this;
        }

        public Frame putInt24(int value) {
            this.buffer()[this.pos() + 0] = (byte)(value >> 16);
            this.buffer()[this.pos() + 1] = (byte)(value >> 8);
            this.buffer()[this.pos() + 2] = (byte)(value >> 0);
            this.pos_$eq(this.pos() + 3);
            return this;
        }

        public Frame putInt16(int value) {
            this.buffer()[this.pos() + 0] = (byte)(value >> 8);
            this.buffer()[this.pos() + 1] = (byte)(value >> 0);
            this.pos_$eq(this.pos() + 2);
            return this;
        }

        public Frame put(ByteString bytes) {
            if (bytes.isEmpty()) {
                return this;
            }
            bytes.copyToArray((Object)this.buffer(), this.pos());
            this.pos_$eq(this.pos() + bytes.length());
            return this;
        }

        public ByteString build() {
            if (this.pos() != this.targetSize()) {
                throw new IllegalStateException(new StringBuilder(33).append("Did not write exactly ").append(this.targetSize()).append(" bytes but ").append(this.pos()).toString());
            }
            return ByteString$.MODULE$.fromArrayUnsafe(this.buffer());
        }

        public Frame(int payloadSize, Http2Protocol.FrameType tpe, int flags, int streamId) {
            this.targetSize = 9 + payloadSize;
            this.buffer = new byte[this.targetSize()];
            this.pos = 0;
            this.putInt24(payloadSize);
            this.putByte((byte)tpe.id());
            this.putByte((byte)flags);
            this.putInt32(streamId);
        }
    }
}

