/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2.framing;

import java.nio.ByteOrder;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.ByteFlag$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$Flags$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$CONTINUATION$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$DATA$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$GOAWAY$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$HEADERS$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PING$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PRIORITY$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PUSH_PROMISE$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$RST_STREAM$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$SETTINGS$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$WINDOW_UPDATE$;
import org.apache.pekko.http.impl.engine.http2.framing.FrameRenderer;
import org.apache.pekko.http.impl.engine.http2.framing.FrameRenderer$Frame$;
import org.apache.pekko.util.ByteString;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.package$;

@InternalApi
public final class FrameRenderer$ {
    public static FrameRenderer$ MODULE$;
    private final ByteOrder byteOrder;

    static {
        new FrameRenderer$();
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public ByteString render(FrameEvent frame) {
        if (frame instanceof FrameEvent.GoAwayFrame) {
            FrameEvent.GoAwayFrame goAwayFrame = (FrameEvent.GoAwayFrame)frame;
            int lastStreamId = goAwayFrame.lastStreamId();
            Http2Protocol.ErrorCode errorCode = goAwayFrame.errorCode();
            ByteString debug = goAwayFrame.debug();
            return FrameRenderer$Frame$.MODULE$.apply(8 + debug.length(), Http2Protocol$FrameType$GOAWAY$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), 0).putInt32(lastStreamId).putInt32(errorCode.id()).put(debug).build();
        }
        if (frame instanceof FrameEvent.DataFrame) {
            FrameEvent.DataFrame dataFrame = (FrameEvent.DataFrame)frame;
            int streamId = dataFrame.streamId();
            boolean endStream = dataFrame.endStream();
            ByteString payload = dataFrame.payload();
            return FrameRenderer$Frame$.MODULE$.apply(payload.length(), Http2Protocol$FrameType$DATA$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), endStream), streamId).put(payload).build();
        }
        if (frame instanceof FrameEvent.HeadersFrame) {
            FrameEvent.HeadersFrame headersFrame = (FrameEvent.HeadersFrame)frame;
            int streamId = headersFrame.streamId();
            boolean endStream = headersFrame.endStream();
            boolean endHeaders = headersFrame.endHeaders();
            ByteString headerBlockFragment = headersFrame.headerBlockFragment();
            Option<FrameEvent.PriorityFrame> prioInfo = headersFrame.priorityInfo();
            return FrameRenderer$Frame$.MODULE$.apply((prioInfo.isDefined() ? 5 : 0) + headerBlockFragment.length(), Http2Protocol$FrameType$HEADERS$.MODULE$, ByteFlag$.MODULE$.$bar$extension(ByteFlag$.MODULE$.$bar$extension(ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), endStream), ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders)), ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.PRIORITY(), prioInfo.isDefined())), streamId).putPriorityInfo(prioInfo).put(headerBlockFragment).build();
        }
        if (frame instanceof FrameEvent.WindowUpdateFrame) {
            FrameEvent.WindowUpdateFrame windowUpdateFrame = (FrameEvent.WindowUpdateFrame)frame;
            int streamId = windowUpdateFrame.streamId();
            int windowSizeIncrement = windowUpdateFrame.windowSizeIncrement();
            return FrameRenderer$Frame$.MODULE$.apply(4, Http2Protocol$FrameType$WINDOW_UPDATE$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId).putInt32(windowSizeIncrement).build();
        }
        if (frame instanceof FrameEvent.ContinuationFrame) {
            FrameEvent.ContinuationFrame continuationFrame = (FrameEvent.ContinuationFrame)frame;
            int streamId = continuationFrame.streamId();
            boolean endHeaders = continuationFrame.endHeaders();
            ByteString payload = continuationFrame.payload();
            return FrameRenderer$Frame$.MODULE$.apply(payload.length(), Http2Protocol$FrameType$CONTINUATION$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders), streamId).put(payload).build();
        }
        if (frame instanceof FrameEvent.SettingsFrame) {
            scala.collection.immutable.Seq<FrameEvent.Setting> settings = ((FrameEvent.SettingsFrame)frame).settings();
            FrameRenderer.Frame b = FrameRenderer$Frame$.MODULE$.apply(settings.length() * 6, Http2Protocol$FrameType$SETTINGS$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), 0);
            this.renderNext$1((Seq)settings, b);
            return b.build();
        }
        if (frame instanceof FrameEvent.SettingsAckFrame) {
            return FrameRenderer$Frame$.MODULE$.apply(0, Http2Protocol$FrameType$SETTINGS$.MODULE$, Http2Protocol$Flags$.MODULE$.ACK(), 0).build();
        }
        if (frame instanceof FrameEvent.PingFrame) {
            FrameEvent.PingFrame pingFrame = (FrameEvent.PingFrame)frame;
            boolean ack = pingFrame.ack();
            ByteString data = pingFrame.data();
            return FrameRenderer$Frame$.MODULE$.apply(data.length(), Http2Protocol$FrameType$PING$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.ACK(), ack), 0).put(data).build();
        }
        if (frame instanceof FrameEvent.RstStreamFrame) {
            FrameEvent.RstStreamFrame rstStreamFrame = (FrameEvent.RstStreamFrame)frame;
            int streamId = rstStreamFrame.streamId();
            Http2Protocol.ErrorCode errorCode = rstStreamFrame.errorCode();
            return FrameRenderer$Frame$.MODULE$.apply(4, Http2Protocol$FrameType$RST_STREAM$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId).putInt32(errorCode.id()).build();
        }
        if (frame instanceof FrameEvent.PushPromiseFrame) {
            FrameEvent.PushPromiseFrame pushPromiseFrame = (FrameEvent.PushPromiseFrame)frame;
            int streamId = pushPromiseFrame.streamId();
            boolean endHeaders = pushPromiseFrame.endHeaders();
            int promisedStreamId = pushPromiseFrame.promisedStreamId();
            ByteString headerBlockFragment = pushPromiseFrame.headerBlockFragment();
            return FrameRenderer$Frame$.MODULE$.apply(4 + headerBlockFragment.length(), Http2Protocol$FrameType$PUSH_PROMISE$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders), streamId).putInt32(promisedStreamId).put(headerBlockFragment).build();
        }
        if (frame instanceof FrameEvent.PriorityFrame) {
            FrameEvent.PriorityFrame priorityFrame = (FrameEvent.PriorityFrame)frame;
            int streamId = priorityFrame.streamId();
            return FrameRenderer$Frame$.MODULE$.apply(5, Http2Protocol$FrameType$PRIORITY$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId).putPriorityInfo(priorityFrame).build();
        }
        throw new IllegalStateException(new StringBuilder(23).append("Unexpected frame type ").append(frame.frameTypeName()).append(".").toString());
    }

    public ByteString renderFrame(Http2Protocol.FrameType tpe, int flags, int streamId, ByteString payload) {
        return FrameRenderer$Frame$.MODULE$.apply(payload.length(), tpe, flags, streamId).put(payload).build();
    }

    private final void renderNext$1(Seq remaining, FrameRenderer.Frame b$1) {
        Option option;
        while (!(option = package$.MODULE$.$plus$colon().unapply((SeqLike)remaining)).isEmpty()) {
            FrameEvent.Setting setting = (FrameEvent.Setting)((Tuple2)option.get())._1();
            Seq remaining2 = (Seq)((Tuple2)option.get())._2();
            if (setting == null) break;
            Http2Protocol.SettingIdentifier id = setting.identifier();
            int value = setting.value();
            b$1.putInt16(id.id());
            b$1.putInt32(value);
            remaining = remaining2;
        }
        if (Nil$.MODULE$.equals(remaining)) {
            return;
        }
        throw new MatchError((Object)remaining);
    }

    private FrameRenderer$() {
        MODULE$ = this;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
    }
}

