/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import javax.net.ssl.SSLSession;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.Http2$;
import org.apache.pekko.http.impl.engine.http2.Http2Compliance;
import org.apache.pekko.http.impl.engine.http2.Http2SubStream;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$Authority$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$ContentLength$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$ContentType$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$Cookie$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$Method$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$OtherHeader$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$PathAndQuery$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$Scheme$;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.server.HttpAttributes;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.RemoteAddress;
import org.apache.pekko.http.scaladsl.model.RemoteAddress$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.SslSessionInfo$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.Uri$Authority$;
import org.apache.pekko.http.scaladsl.model.headers.Remote$minusAddress;
import org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@InternalApi
public final class RequestParsing$ {
    public static RequestParsing$ MODULE$;

    static {
        new RequestParsing$();
    }

    /*
     * WARNING - void declaration
     */
    public Function1<Http2SubStream, HttpRequest> parseRequest(HttpHeaderParser httpHeaderParser, ServerSettings serverSettings, Attributes streamAttributes) {
        void var8_8;
        Map map;
        Map map2;
        None$ remoteAddressHeader = serverSettings.remoteAddressHeader() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map((Function1 & Serializable & scala.Serializable)remote -> new Remote$minusAddress(RemoteAddress$.MODULE$.apply(remote.address()))) : None$.MODULE$;
        None$ remoteAddressAttribute = serverSettings.remoteAddressAttribute() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map((Function1 & Serializable & scala.Serializable)remote -> RemoteAddress$.MODULE$.apply(remote.address())) : None$.MODULE$;
        None$ tlsSessionInfoHeader = serverSettings.parserSettings().includeTlsSessionInfoHeader() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1 & Serializable & scala.Serializable)sslSessionInfo -> new Tls$minusSession$minusInfo(sslSessionInfo.session())) : None$.MODULE$;
        None$ sslSessionAttribute = serverSettings.parserSettings().includeSslSessionAttribute() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.session()) : None$.MODULE$;
        Map map3 = Predef$.MODULE$.Map().empty();
        if (sslSessionAttribute instanceof Some) {
            SSLSession sslSession = (SSLSession)((Some)sslSessionAttribute).value();
            map2 = map3.updated(AttributeKeys$.MODULE$.sslSession(), (Object)SslSessionInfo$.MODULE$.apply(sslSession));
        } else if (None$.MODULE$.equals(sslSessionAttribute)) {
            map2 = map3;
        } else {
            throw new MatchError((Object)sslSessionAttribute);
        }
        map3 = map2;
        if (remoteAddressAttribute instanceof Some) {
            RemoteAddress remoteAddress = (RemoteAddress)((Some)remoteAddressAttribute).value();
            map = map3.updated(AttributeKeys$.MODULE$.remoteAddress(), (Object)remoteAddress);
        } else if (None$.MODULE$.equals(remoteAddressAttribute)) {
            map = map3;
        } else {
            throw new MatchError((Object)remoteAddressAttribute);
        }
        map3 = map;
        return arg_0 -> RequestParsing$.$anonfun$parseRequest$5(this, httpHeaderParser, (Option)remoteAddressHeader, (Option)tlsSessionInfoHeader, (Map)var8_8, serverSettings, arg_0);
    }

    public HttpHeader parseHeaderPair(HttpHeaderParser httpHeaderParser, String name, String value) {
        String concHeaderLine = new java.lang.StringBuilder(5).append(name).append(": ").append(value).append("\r\nx").toString();
        ByteString x$1 = ByteString$.MODULE$.apply(concHeaderLine);
        int x$2 = httpHeaderParser.parseHeaderLine$default$2();
        int x$3 = httpHeaderParser.parseHeaderLine$default$3(x$1, x$2);
        int x$4 = httpHeaderParser.parseHeaderLine$default$4(x$1, x$2);
        httpHeaderParser.parseHeaderLine(x$1, x$2, x$3, x$4);
        return httpHeaderParser.resultHeader();
    }

    public void checkRequiredPseudoHeader(String name, Object value) {
        if (value == null) {
            throw this.malformedRequest(new java.lang.StringBuilder(34).append("Mandatory pseudo-header '").append(name).append("' missing").toString());
        }
    }

    public void checkUniquePseudoHeader(String name, Object value) {
        if (value != null) {
            throw this.malformedRequest(new java.lang.StringBuilder(46).append("Pseudo-header '").append(name).append("' must not occur more than once").toString());
        }
    }

    public void checkNoRegularHeadersBeforePseudoHeader(String name, boolean seenRegularHeader) {
        if (seenRegularHeader) {
            throw this.malformedRequest(new java.lang.StringBuilder(61).append("Pseudo-header field '").append(name).append("' must not appear after a regular header").toString());
        }
    }

    public Nothing$ malformedRequest(String msg) {
        throw new Http2Compliance.Http2ProtocolException(new java.lang.StringBuilder(19).append("Malformed request: ").append(msg).toString());
    }

    public void validateHeader(HttpHeader httpHeader) {
        String string = httpHeader.lowercaseName();
        if ("connection".equals(string)) {
            throw this.malformedRequest("Header 'Connection' must not be used with HTTP/2");
        }
        if ("transfer-encoding".equals(string)) {
            throw this.malformedRequest("Header 'Transfer-Encoding' must not be used with HTTP/2");
        }
        if ("te".equals(string)) {
            if (httpHeader.value().compareToIgnoreCase("trailers") != 0) {
                throw this.malformedRequest(new java.lang.StringBuilder(69).append("Header 'TE' must not contain value other than 'trailers', value was '").append(httpHeader.value()).toString());
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final HttpRequest createRequest$1(HttpMethod method, String scheme, Uri.Authority authority, Tuple2 pathAndRawQuery, ContentType contentType, long contentLength, StringBuilder cookies, VectorBuilder headers2, HttpHeaderParser httpHeaderParser$1, Option remoteAddressHeader$1, Option tlsSessionInfoHeader$1, Http2SubStream subStream$1, Map baseAttributes$1) {
        void var16_15;
        void var15_14;
        MODULE$.checkRequiredPseudoHeader(":scheme", scheme);
        MODULE$.checkRequiredPseudoHeader(":method", method);
        MODULE$.checkRequiredPseudoHeader(":path", pathAndRawQuery);
        if (cookies != null) {
            headers2.$plus$eq((Object)MODULE$.parseHeaderPair(httpHeaderParser$1, "cookie", cookies.toString()));
        }
        if (remoteAddressHeader$1.isDefined()) {
            headers2.$plus$eq(remoteAddressHeader$1.get());
        }
        if (tlsSessionInfoHeader$1.isDefined()) {
            headers2.$plus$eq(tlsSessionInfoHeader$1.get());
        }
        RequestEntity entity = subStream$1.createEntity(contentLength, contentType);
        if (pathAndRawQuery == null) {
            throw new MatchError(null);
        }
        Uri.Path path = (Uri.Path)pathAndRawQuery._1();
        Option rawQueryString = (Option)pathAndRawQuery._2();
        void path2 = var15_14;
        void rawQueryString2 = var16_15;
        Uri.Authority authorityOrDefault = authority == null ? Uri$Authority$.MODULE$.Empty() : authority;
        Uri uri = Uri$.MODULE$.apply(scheme, authorityOrDefault, (Uri.Path)path2, (Option<String>)rawQueryString2, Uri$.MODULE$.apply$default$5());
        Map attributes = baseAttributes$1.updated(Http2$.MODULE$.streamId(), (Object)BoxesRunTime.boxToInteger((int)subStream$1.streamId()));
        return new HttpRequest(method, uri, (Seq<HttpHeader>)headers2.result(), attributes, entity, HttpProtocols$.MODULE$.HTTP$div2$u002E0());
    }

    /*
     * WARNING - void declaration
     */
    private final HttpRequest rec$1(IndexedSeq incomingHeaders, int offset, HttpMethod method, String scheme, Uri.Authority authority, Tuple2 pathAndRawQuery, ContentType contentType, long contentLength, StringBuilder cookies, boolean seenRegularHeader, VectorBuilder headers2, HttpHeaderParser httpHeaderParser$1, Option remoteAddressHeader$1, Option tlsSessionInfoHeader$1, Http2SubStream subStream$1, Map baseAttributes$1) {
        while (offset != incomingHeaders.size()) {
            void var20_19;
            void var19_18;
            Tuple2 tuple2 = (Tuple2)incomingHeaders.apply(offset);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            String name = (String)tuple2._1();
            Object value = tuple2._2();
            void name2 = var19_18;
            if (":scheme".equals(name2)) {
                this.checkUniquePseudoHeader(":scheme", scheme);
                this.checkNoRegularHeadersBeforePseudoHeader(":scheme", seenRegularHeader);
                scheme = (String)Http2HeaderParsing$Scheme$.MODULE$.get(var20_19);
                ++offset;
                continue;
            }
            if (":method".equals(name2)) {
                this.checkUniquePseudoHeader(":method", method);
                this.checkNoRegularHeadersBeforePseudoHeader(":method", seenRegularHeader);
                method = (HttpMethod)Http2HeaderParsing$Method$.MODULE$.get(var20_19);
                ++offset;
                continue;
            }
            if (":path".equals(name2)) {
                this.checkUniquePseudoHeader(":path", pathAndRawQuery);
                this.checkNoRegularHeadersBeforePseudoHeader(":path", seenRegularHeader);
                pathAndRawQuery = (Tuple2)Http2HeaderParsing$PathAndQuery$.MODULE$.get(var20_19);
                ++offset;
                continue;
            }
            if (":authority".equals(name2)) {
                this.checkUniquePseudoHeader(":authority", authority);
                this.checkNoRegularHeadersBeforePseudoHeader(":authority", seenRegularHeader);
                authority = (Uri.Authority)Http2HeaderParsing$Authority$.MODULE$.get(var20_19);
                ++offset;
                continue;
            }
            if ("content-type".equals(name2)) {
                if (OptionVal$.MODULE$.isEmpty$extension((Object)contentType)) {
                    seenRegularHeader = true;
                    contentType = (ContentType)OptionVal.Some$.MODULE$.apply(Http2HeaderParsing$ContentType$.MODULE$.get(var20_19));
                    ++offset;
                    continue;
                }
                throw this.malformedRequest("HTTP message must not contain more than one content-type header");
            }
            if (":status".equals(name2)) {
                throw this.malformedRequest("Pseudo-header ':status' is for responses only; it cannot appear in a request");
            }
            if ("content-length".equals(name2)) {
                if (contentLength == -1L) {
                    long contentLengthValue = new StringOps(Predef$.MODULE$.augmentString((String)Http2HeaderParsing$ContentLength$.MODULE$.get(var20_19))).toLong();
                    if (contentLengthValue < 0L) {
                        throw this.malformedRequest("HTTP message must not contain a negative content-length header");
                    }
                    seenRegularHeader = true;
                    contentLength = contentLengthValue;
                    ++offset;
                    continue;
                }
                throw this.malformedRequest("HTTP message must not contain more than one content-length header");
            }
            if ("cookie".equals(name2)) {
                StringBuilder cookiesBuilder = cookies == null ? new StringBuilder() : cookies.append("; ");
                cookiesBuilder.append((String)Http2HeaderParsing$Cookie$.MODULE$.get(var20_19));
                seenRegularHeader = true;
                cookies = cookiesBuilder;
                ++offset;
                continue;
            }
            headers2 = headers2.$plus$eq(Http2HeaderParsing$OtherHeader$.MODULE$.get(var20_19));
            seenRegularHeader = true;
            ++offset;
        }
        return RequestParsing$.createRequest$1(method, scheme, authority, pathAndRawQuery, contentType, contentLength, cookies, headers2, httpHeaderParser$1, remoteAddressHeader$1, tlsSessionInfoHeader$1, subStream$1, baseAttributes$1);
    }

    private static final HttpMethod rec$default$3$1() {
        return null;
    }

    private static final String rec$default$4$1() {
        return null;
    }

    private static final Uri.Authority rec$default$5$1() {
        return null;
    }

    private static final Tuple2 rec$default$6$1() {
        return null;
    }

    private static final ContentType rec$default$7$1() {
        OptionVal$.MODULE$.None();
        return null;
    }

    private static final long rec$default$8$1() {
        return -1L;
    }

    private static final StringBuilder rec$default$9$1() {
        return null;
    }

    private static final boolean rec$default$10$1() {
        return false;
    }

    private static final VectorBuilder rec$default$11$1() {
        return new VectorBuilder();
    }

    public static final /* synthetic */ HttpRequest $anonfun$parseRequest$5(RequestParsing$ $this, HttpHeaderParser httpHeaderParser$1, Option remoteAddressHeader$1, Option tlsSessionInfoHeader$1, Map baseAttributes$1, ServerSettings serverSettings$1, Http2SubStream subStream) {
        scala.collection.immutable.IndexedSeq incomingHeaders = subStream.initialHeaders().keyValuePairs().toIndexedSeq();
        if (incomingHeaders.size() > serverSettings$1.parserSettings().maxHeaderCount()) {
            throw MODULE$.malformedRequest(new java.lang.StringBuilder(64).append("HTTP message contains more than the configured limit of ").append(serverSettings$1.parserSettings().maxHeaderCount()).append(" headers").toString());
        }
        return $this.rec$1((IndexedSeq)incomingHeaders, 0, RequestParsing$.rec$default$3$1(), RequestParsing$.rec$default$4$1(), RequestParsing$.rec$default$5$1(), RequestParsing$.rec$default$6$1(), RequestParsing$.rec$default$7$1(), RequestParsing$.rec$default$8$1(), RequestParsing$.rec$default$9$1(), RequestParsing$.rec$default$10$1(), RequestParsing$.rec$default$11$1(), httpHeaderParser$1, remoteAddressHeader$1, tlsSessionInfoHeader$1, subStream, baseAttributes$1);
    }

    private RequestParsing$() {
        MODULE$ = this;
    }
}

