/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.SimpleTypeRegistry;

public class MybatisParameterHandler
extends DefaultParameterHandler {
    @Deprecated
    public static final String[] COLLECTION_KEYS = new String[]{"collection", "coll", "list", "array"};
    private final Object parameterObject;
    private final Configuration configuration;
    private final SqlCommandType sqlCommandType;
    private final MappedStatement mappedStatement;

    public MybatisParameterHandler(MappedStatement mappedStatement, Object parameter, BoundSql boundSql) {
        super(mappedStatement, parameter, boundSql);
        this.mappedStatement = mappedStatement;
        this.configuration = mappedStatement.getConfiguration();
        this.sqlCommandType = mappedStatement.getSqlCommandType();
        this.parameterObject = this.processParameter(parameter);
    }

    public Object processParameter(Object parameter) {
        if (parameter != null && (SqlCommandType.INSERT == this.sqlCommandType || SqlCommandType.UPDATE == this.sqlCommandType)) {
            if (SimpleTypeRegistry.isSimpleType(parameter.getClass())) {
                return parameter;
            }
            this.extractParameters(parameter).forEach(this::process);
        }
        return parameter;
    }

    public Object getParameterObject() {
        return this.parameterObject;
    }

    private void process(Object parameter) {
        if (parameter != null) {
            TableInfo tableInfo = null;
            Object entity = parameter;
            if (parameter instanceof Map) {
                Object et;
                Map map = (Map)parameter;
                if (map.containsKey("et") && (et = map.get("et")) != null) {
                    entity = et;
                    tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
                }
            } else {
                tableInfo = TableInfoHelper.getTableInfo(parameter.getClass());
            }
            if (tableInfo != null) {
                MetaObject metaObject = this.configuration.newMetaObject(entity);
                if (SqlCommandType.INSERT == this.sqlCommandType) {
                    this.populateKeys(tableInfo, metaObject, entity);
                    this.insertFill(metaObject, tableInfo);
                } else {
                    this.updateFill(metaObject, tableInfo);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void populateKeys(TableInfo tableInfo, MetaObject metaObject, Object entity) {
        Object idValue;
        IdentifierGenerator identifierGenerator;
        IdType idType = tableInfo.getIdType();
        String keyProperty = tableInfo.getKeyProperty();
        if (!StringUtils.isNotBlank(keyProperty) || null == idType || idType.getKey() < 3 || !(identifierGenerator = GlobalConfigUtils.getGlobalConfig(this.configuration).getIdentifierGenerator()).assignId(idValue = metaObject.getValue(keyProperty))) return;
        if (idType.getKey() == IdType.ASSIGN_ID.getKey()) {
            Class<?> keyType = tableInfo.getKeyType();
            if (Number.class.isAssignableFrom(keyType)) {
                Number id = identifierGenerator.nextId(entity);
                if (keyType == id.getClass()) {
                    metaObject.setValue(keyProperty, (Object)id);
                    return;
                } else if (Integer.class == keyType) {
                    metaObject.setValue(keyProperty, (Object)id.intValue());
                    return;
                } else if (Long.class == keyType) {
                    metaObject.setValue(keyProperty, (Object)id.longValue());
                    return;
                } else if (BigDecimal.class.isAssignableFrom(keyType)) {
                    metaObject.setValue(keyProperty, (Object)new BigDecimal(id.longValue()));
                    return;
                } else {
                    if (!BigInteger.class.isAssignableFrom(keyType)) throw new MybatisPlusException("Key type '" + keyType + "' not supported");
                    metaObject.setValue(keyProperty, (Object)new BigInteger(id.toString()));
                }
                return;
            } else if (String.class.isAssignableFrom(keyType)) {
                metaObject.setValue(keyProperty, (Object)identifierGenerator.nextId(entity).toString());
                return;
            } else {
                metaObject.setValue(keyProperty, (Object)identifierGenerator.nextId(entity));
            }
            return;
        } else {
            if (idType.getKey() != IdType.ASSIGN_UUID.getKey()) return;
            metaObject.setValue(keyProperty, (Object)identifierGenerator.nextUUID(entity));
        }
    }

    protected void insertFill(MetaObject metaObject, TableInfo tableInfo) {
        GlobalConfigUtils.getMetaObjectHandler(this.configuration).ifPresent(metaObjectHandler -> {
            if (metaObjectHandler.openInsertFill() && metaObjectHandler.openInsertFill(this.mappedStatement) && tableInfo.isWithInsertFill()) {
                metaObjectHandler.insertFill(metaObject);
            }
        });
    }

    protected void updateFill(MetaObject metaObject, TableInfo tableInfo) {
        GlobalConfigUtils.getMetaObjectHandler(this.configuration).ifPresent(metaObjectHandler -> {
            if (metaObjectHandler.openUpdateFill() && metaObjectHandler.openUpdateFill(this.mappedStatement) && tableInfo.isWithUpdateFill()) {
                metaObjectHandler.updateFill(metaObject);
            }
        });
    }

    @Deprecated
    protected Collection<Object> getParameters(Object parameterObject) {
        Collection<Object> parameters = null;
        if (parameterObject instanceof Collection) {
            parameters = (Collection<Object>)parameterObject;
        } else if (ArrayUtils.isArray(parameterObject)) {
            parameters = this.toCollection(parameterObject);
        } else if (parameterObject instanceof Map) {
            Map parameterMap = (Map)parameterObject;
            if (parameterMap.containsKey("collection")) {
                return this.toCollection(parameterMap.get("collection"));
            }
            if (parameterMap.containsKey("coll")) {
                parameters = this.toCollection(parameterMap.get("coll"));
            } else if (parameterMap.containsKey("list")) {
                parameters = this.toCollection(parameterMap.get("list"));
            } else if (parameterMap.containsKey("array")) {
                parameters = this.toCollection(parameterMap.get("array"));
            }
        }
        return parameters;
    }

    private Collection<Object> extractParameters(Object parameterObject) {
        if (parameterObject instanceof Collection) {
            return (Collection)parameterObject;
        }
        if (ArrayUtils.isArray(parameterObject)) {
            return this.toCollection(parameterObject);
        }
        if (parameterObject instanceof Map) {
            ArrayList<Object> parameters = new ArrayList<Object>();
            Map parameterMap = (Map)parameterObject;
            HashSet objectSet = new HashSet();
            parameterMap.forEach((k, v) -> {
                if (objectSet.add(v)) {
                    Collection<Object> collection = this.toCollection(v);
                    parameters.addAll(collection);
                }
            });
            return parameters;
        }
        return Collections.singleton(parameterObject);
    }

    protected Collection<Object> toCollection(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (ArrayUtils.isArray(value) && !value.getClass().getComponentType().isPrimitive()) {
            return Arrays.asList((Object[])value);
        }
        if (Collection.class.isAssignableFrom(value.getClass())) {
            return (Collection)value;
        }
        return Collections.singletonList(value);
    }
}

