/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.service.impl;

import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.common.util.UUIDUtil;
import cn.sliew.carp.framework.mybatis.entity.BaseDO;
import cn.sliew.carp.module.kubernetes.repository.entity.K8sCluster;
import cn.sliew.carp.module.kubernetes.repository.mapper.K8sClusterMapper;
import cn.sliew.carp.module.kubernetes.service.K8sClusterService;
import cn.sliew.carp.module.kubernetes.service.convert.K8sClusterConvert;
import cn.sliew.carp.module.kubernetes.service.entity.Cluster;
import cn.sliew.carp.module.kubernetes.service.param.K8sClusterAddParam;
import cn.sliew.carp.module.kubernetes.service.param.K8sClusterPageParam;
import cn.sliew.milky.common.util.JacksonUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class K8sClusterServiceImpl
extends ServiceImpl<K8sClusterMapper, K8sCluster>
implements K8sClusterService {
    @Override
    public PageResult<Cluster> list(K8sClusterPageParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(K8sCluster.class).like(StringUtils.hasText((String)param.getName()), K8sCluster::getName, (Object)param.getName())).orderByAsc(BaseDO::getId);
        Page secRolePage = (Page)this.page((IPage)page, (Wrapper)queryChainWrapper);
        PageResult pageResult = new PageResult(Long.valueOf(secRolePage.getCurrent()), Long.valueOf(secRolePage.getSize()), Long.valueOf(secRolePage.getTotal()));
        pageResult.setRecords(K8sClusterConvert.INSTANCE.toDto(secRolePage.getRecords()));
        return pageResult;
    }

    @Override
    public List<Cluster> listAll() {
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(K8sCluster.class).orderByAsc(BaseDO::getId);
        List list = this.list((Wrapper)queryChainWrapper);
        return K8sClusterConvert.INSTANCE.toDto(list);
    }

    @Override
    public Cluster get(Long id) {
        K8sCluster entity = (K8sCluster)((Object)this.getOptById(id).orElseThrow(() -> new IllegalArgumentException("k8s cluster not exists for id: " + id)));
        return K8sClusterConvert.INSTANCE.toDto(entity);
    }

    @Override
    public boolean add(K8sClusterAddParam param) {
        K8sCluster entity = new K8sCluster();
        entity.setUuid(UUIDUtil.randomUUId());
        entity.setName(param.getName());
        entity.setSpec(JacksonUtil.toJsonString((Object)param.getSpec()));
        entity.setRemark(param.getRemark());
        return this.save((Object)entity);
    }

    @Override
    public boolean delete(Long id) {
        return this.removeById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="carpTransactionManager")
    public boolean deleteBatch(Collection<Long> ids) {
        return this.removeByIds(ids);
    }
}

