/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.controller;

import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.web.response.ApiResponseWrapper;
import cn.sliew.carp.module.kubernetes.service.K8sClusterService;
import cn.sliew.carp.module.kubernetes.service.entity.Cluster;
import cn.sliew.carp.module.kubernetes.service.param.K8sClusterAddParam;
import cn.sliew.carp.module.kubernetes.service.param.K8sClusterPageParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResponseWrapper
@RequestMapping(value={"/api/carp/kubernetes/cluster"})
@Tag(name="Kubernetes\u6a21\u5757-\u96c6\u7fa4\u7ba1\u7406")
public class K8sClusterController {
    @Autowired
    private K8sClusterService k8sClusterService;

    @GetMapping(value={"page"})
    @Operation(summary="\u5206\u9875\u67e5\u8be2", description="\u5206\u9875\u67e5\u8be2")
    public PageResult<Cluster> list(@Valid K8sClusterPageParam param) {
        return this.k8sClusterService.list(param);
    }

    @GetMapping
    @Operation(summary="\u67e5\u8be2\u6240\u6709", description="\u67e5\u8be2\u6240\u6709")
    public List<Cluster> listAll() {
        return this.k8sClusterService.listAll();
    }

    @GetMapping(value={"{id}"})
    @Operation(summary="\u67e5\u8be2\u8be6\u60c5", description="\u67e5\u8be2\u8be6\u60c5")
    public Cluster get(@PathVariable(value="id") Long id) {
        return this.k8sClusterService.get(id);
    }

    @PutMapping
    @Operation(summary="\u65b0\u589e", description="\u65b0\u589e")
    public Boolean add(@Valid @RequestBody K8sClusterAddParam param) {
        return this.k8sClusterService.add(param);
    }

    @DeleteMapping(value={"{id}"})
    @Operation(summary="\u5220\u9664", description="\u5220\u9664")
    public Boolean delete(@PathVariable(value="id") Long id) {
        return this.k8sClusterService.delete(id);
    }

    @DeleteMapping(value={"batch"})
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    public Boolean deleteBatch(@RequestBody List<Long> ids) {
        return this.k8sClusterService.deleteBatch(ids);
    }
}

