/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.MethodMetadata;
import feign.Target;
import feign.micrometer.MetricTagResolver;
import feign.utils.ExceptionUtils;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FeignMetricTagResolver
implements MetricTagResolver {
    @Override
    public Tags tag(MethodMetadata methodMetadata, Target<?> target, Tag ... tags) {
        return this.tag(methodMetadata, target, (Throwable)null, tags);
    }

    @Override
    public Tags tag(MethodMetadata methodMetadata, Target<?> target, Throwable e, Tag ... tags) {
        return this.tag(methodMetadata.targetType(), methodMetadata.method(), target.url(), e, tags);
    }

    @Override
    public Tags tag(Class<?> targetType, Method method, String url, Tag ... extraTags) {
        return this.tag(targetType, method, url, (Throwable)null, extraTags);
    }

    @Override
    public Tags tag(Class<?> targetType, Method method, String url, Throwable e, Tag ... extraTags) {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.defaultTags());
        tags.add(Tag.of((String)"client", (String)targetType.getName()));
        tags.add(Tag.of((String)"method", (String)method.getName()));
        tags.add(Tag.of((String)"host", (String)this.extractHost(url)));
        if (e != null) {
            tags.add(Tag.of((String)"exception_name", (String)e.getClass().getSimpleName()));
            tags.add(Tag.of((String)"root_cause_name", (String)ExceptionUtils.getRootCause((Throwable)e).getClass().getSimpleName()));
        }
        tags.addAll(Arrays.asList(extraTags));
        return Tags.of(tags);
    }

    protected List<Tag> defaultTags() {
        return Collections.emptyList();
    }

    private String extractHost(String targetUrl) {
        try {
            String host = new URI(targetUrl).getHost();
            if (host != null) {
                return host;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return targetUrl.length() <= 20 ? targetUrl : targetUrl.substring(0, 20);
    }
}

