/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.LocalRef;
import org.apache.pekko.actor.PossiblyHarmful;
import org.apache.pekko.actor.RepointableRef;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.InboundMessageDispatcher;
import org.apache.pekko.remote.MessageSerializer$;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteRef;
import org.apache.pekko.remote.WireFormats;
import org.apache.pekko.util.OptionVal$;
import scala.reflect.ScalaSignature;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0001%4Qa\u0003\u0007\u0001\u0019QA\u0001b\b\u0001\u0003\u0006\u0004%I!\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005E!A\u0011\u0006\u0001BC\u0002\u0013%!\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003,\u0011!y\u0003A!b\u0001\n\u0013\u0001\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000ba\u0002A\u0011A\u001d\t\u000fy\u0002!\u0019!C\u0005\u007f!11\t\u0001Q\u0001\n\u0001CQ\u0001\u0012\u0001\u0005B\u0015\u0013\u0001\u0004R3gCVdG/T3tg\u0006<W\rR5ta\u0006$8\r[3s\u0015\tia\"\u0001\u0004sK6|G/\u001a\u0006\u0003\u001fA\tQ\u0001]3lW>T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sON\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\taR$D\u0001\r\u0013\tqBB\u0001\rJ]\n|WO\u001c3NKN\u001c\u0018mZ3ESN\u0004\u0018\r^2iKJ\faa]=ti\u0016l7\u0001A\u000b\u0002EA\u00111EJ\u0007\u0002I)\u0011QED\u0001\u0006C\u000e$xN]\u0005\u0003O\u0011\u00121#\u0012=uK:$W\rZ!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007%\u0001\u0005qe>4\u0018\u000eZ3s+\u0005Y\u0003C\u0001\u000f-\u0013\tiCB\u0001\fSK6|G/Z!di>\u0014(+\u001a4Qe>4\u0018\u000eZ3s\u0003%\u0001(o\u001c<jI\u0016\u0014\b%A\u0002m_\u001e,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003i9\tQ!\u001a<f]RL!AN\u001a\u0003)5\u000b'o[3s\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\u0011awn\u001a\u0011\u0002\rqJg.\u001b;?)\u0011Q4\bP\u001f\u0011\u0005q\u0001\u0001\"B\u0010\b\u0001\u0004\u0011\u0003\"B\u0015\b\u0001\u0004Y\u0003\"B\u0018\b\u0001\u0004\t\u0014\u0001\u0004:f[>$X\rR1f[>tW#\u0001!\u0011\u0005\r\n\u0015B\u0001\"%\u0005AIe\u000e^3s]\u0006d\u0017i\u0019;peJ+g-A\u0007sK6|G/\u001a#bK6|g\u000eI\u0001\tI&\u001c\b/\u0019;dQR)a)S&Q=B\u0011acR\u0005\u0003\u0011^\u0011A!\u00168ji\")!J\u0003a\u0001\u0001\u0006I!/Z2ja&,g\u000e\u001e\u0005\u0006\u0019*\u0001\r!T\u0001\u0011e\u0016\u001c\u0017\u000e]5f]R\fE\r\u001a:fgN\u0004\"a\t(\n\u0005=##aB!eIJ,7o\u001d\u0005\u0006#*\u0001\rAU\u0001\u0012g\u0016\u0014\u0018.\u00197ju\u0016$W*Z:tC\u001e,\u0007CA*\\\u001d\t!\u0016L\u0004\u0002V1:\u0011akV\u0007\u0002!%\u0011q\u0002E\u0005\u0003\u001b9I!A\u0017\u0007\u0002\u0017]K'/\u001a$pe6\fGo]\u0005\u00039v\u0013\u0011cU3sS\u0006d\u0017N_3e\u001b\u0016\u001c8/Y4f\u0015\tQF\u0002C\u0003`\u0015\u0001\u0007\u0001-\u0001\u0007tK:$WM](qi&|g\u000eE\u0002bI\u001al\u0011A\u0019\u0006\u0003G:\tA!\u001e;jY&\u0011QM\u0019\u0002\n\u001fB$\u0018n\u001c8WC2\u0004\"aI4\n\u0005!$#\u0001C!di>\u0014(+\u001a4")
public class DefaultMessageDispatcher
implements InboundMessageDispatcher {
    private final ExtendedActorSystem system;
    private final RemoteActorRefProvider provider;
    private final MarkerLoggingAdapter log;
    private final InternalActorRef remoteDaemon;

    private ExtendedActorSystem system() {
        return this.system;
    }

    private RemoteActorRefProvider provider() {
        return this.provider;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    private InternalActorRef remoteDaemon() {
        return this.remoteDaemon;
    }

    @Override
    public void dispatch(InternalActorRef recipient, Address recipientAddress, WireFormats.SerializedMessage serializedMessage, ActorRef senderOption) {
        LazyRef payload$lzy = new LazyRef();
        ActorRef sender = (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, (Object)this.system().deadLetters());
        ActorPath originalReceiver = recipient.path();
        InternalActorRef internalActorRef = this.remoteDaemon();
        if (internalActorRef != null && internalActorRef.equals(recipient)) {
            if (this.provider().remoteSettings().UntrustedMode()) {
                this.log().debug(LogMarker$.MODULE$.Security(), "dropping daemon message in untrusted mode");
                return;
            }
            this.logMessageReceived$1("daemon message", recipient, originalReceiver, sender, payload$lzy, serializedMessage);
            Object x$1 = this.payload$1(payload$lzy, serializedMessage);
            ActorRef x$2 = this.remoteDaemon().$bang$default$2(x$1);
            this.remoteDaemon().$bang(x$1, x$2);
            return;
        }
        if ((recipient instanceof LocalRef ? true : recipient instanceof RepointableRef) && recipient.isLocal()) {
            this.logMessageReceived$1("local message", recipient, originalReceiver, sender, payload$lzy, serializedMessage);
            Object object = this.payload$1(payload$lzy, serializedMessage);
            if (object instanceof ActorSelectionMessage) {
                ActorSelectionMessage actorSelectionMessage = (ActorSelectionMessage)object;
                if (this.provider().remoteSettings().UntrustedMode() && (!this.provider().remoteSettings().TrustedSelectionPaths().contains((Object)actorSelectionMessage.elements().mkString("/", "/", "")) || actorSelectionMessage.msg() instanceof PossiblyHarmful || !recipient.equals(this.provider().rootGuardian()))) {
                    this.log().debug(LogMarker$.MODULE$.Security(), "operating in UntrustedMode, dropping inbound actor selection to [{}], allow it by adding the path to 'pekko.remote.trusted-selection-paths' configuration", (Object)actorSelectionMessage.elements().mkString("/", "/", ""));
                    return;
                }
                ActorSelection$.MODULE$.deliverSelection(recipient, sender, actorSelectionMessage);
                return;
            }
            if (object instanceof PossiblyHarmful) {
                PossiblyHarmful possiblyHarmful = (PossiblyHarmful)object;
                if (this.provider().remoteSettings().UntrustedMode()) {
                    this.log().debug(LogMarker$.MODULE$.Security(), "operating in UntrustedMode, dropping inbound PossiblyHarmful message of type [{}]", (Object)possiblyHarmful.getClass().getName());
                    return;
                }
            }
            if (object instanceof SystemMessage) {
                SystemMessage systemMessage = (SystemMessage)object;
                recipient.sendSystemMessage(systemMessage);
                return;
            }
            recipient.$bang(object, sender);
            return;
        }
        if ((recipient instanceof RemoteRef ? true : recipient instanceof RepointableRef) && !recipient.isLocal() && !this.provider().remoteSettings().UntrustedMode()) {
            this.logMessageReceived$1("remote-destined message", recipient, originalReceiver, sender, payload$lzy, serializedMessage);
            if (this.provider().transport().addresses().apply((Object)recipientAddress)) {
                recipient.$bang(this.payload$1(payload$lzy, serializedMessage), sender);
                return;
            }
            this.log().error("dropping message [{}] for non-local recipient [{}] arriving at [{}] inbound addresses are [{}]", (Object)this.payloadClass$1(payload$lzy, serializedMessage), (Object)recipient, (Object)recipientAddress, (Object)this.provider().transport().addresses().mkString(", "));
            return;
        }
        this.log().error("dropping message [{}] for unknown recipient [{}] arriving at [{}] inbound addresses are [{}]", (Object)this.payloadClass$1(payload$lzy, serializedMessage), (Object)recipient, (Object)recipientAddress, (Object)this.provider().transport().addresses().mkString(", "));
    }

    private final /* synthetic */ Object payload$lzycompute$1(LazyRef payload$lzy$1, WireFormats.SerializedMessage serializedMessage$1) {
        synchronized (payload$lzy$1) {
            Object object = payload$lzy$1.initialized() ? payload$lzy$1.value() : payload$lzy$1.initialize(MessageSerializer$.MODULE$.deserialize(this.system(), serializedMessage$1));
            return object;
        }
    }

    private final Object payload$1(LazyRef payload$lzy$1, WireFormats.SerializedMessage serializedMessage$1) {
        if (payload$lzy$1.initialized()) {
            return payload$lzy$1.value();
        }
        return this.payload$lzycompute$1(payload$lzy$1, serializedMessage$1);
    }

    private final Class payloadClass$1(LazyRef payload$lzy$1, WireFormats.SerializedMessage serializedMessage$1) {
        if (this.payload$1(payload$lzy$1, serializedMessage$1) == null) {
            return null;
        }
        return this.payload$1(payload$lzy$1, serializedMessage$1).getClass();
    }

    private final void logMessageReceived$1(String messageType, InternalActorRef recipient$1, ActorPath originalReceiver$1, ActorRef sender$1, LazyRef payload$lzy$1, WireFormats.SerializedMessage serializedMessage$1) {
        if (this.provider().remoteSettings().LogReceive() && this.log().isDebugEnabled()) {
            this.log().debug(new StringBuilder(53).append("received ").append(messageType).append(" RemoteMessage: [{}] to [{}]<+[{}] from [{}]").toString(), this.payload$1(payload$lzy$1, serializedMessage$1), (Object)recipient$1, (Object)originalReceiver$1, (Object)sender$1);
            return;
        }
    }

    public DefaultMessageDispatcher(ExtendedActorSystem system, RemoteActorRefProvider provider, MarkerLoggingAdapter log) {
        this.system = system;
        this.provider = provider;
        this.log = log;
        this.remoteDaemon = provider.remoteDaemon();
    }
}

