/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import org.lmdbjava.LmdbException;

public class LmdbNativeException
extends LmdbException {
    private static final long serialVersionUID = 1L;
    private final int rc;

    LmdbNativeException(int rc, String msg) {
        super(String.format(msg + " (%d)", rc));
        this.rc = rc;
    }

    public final int getResultCode() {
        return this.rc;
    }

    public static final class TlsFullException
    extends LmdbNativeException {
        static final int MDB_TLS_FULL = -30789;
        private static final long serialVersionUID = 1L;

        TlsFullException() {
            super(-30789, "Too many TLS keys in use - Windows only");
        }
    }

    public static final class PanicException
    extends LmdbNativeException {
        static final int MDB_PANIC = -30795;
        private static final long serialVersionUID = 1L;

        PanicException() {
            super(-30795, "Update of meta page failed or environment had fatal error");
        }
    }

    public static final class PageNotFoundException
    extends LmdbNativeException {
        static final int MDB_PAGE_NOTFOUND = -30797;
        private static final long serialVersionUID = 1L;

        PageNotFoundException() {
            super(-30797, "Requested page not found - this usually indicates corruption");
        }
    }

    public static final class PageFullException
    extends LmdbNativeException {
        static final int MDB_PAGE_FULL = -30786;
        private static final long serialVersionUID = 1L;

        PageFullException() {
            super(-30786, "Page has not enough space - internal error");
        }
    }

    public static final class PageCorruptedException
    extends LmdbNativeException {
        static final int MDB_CORRUPTED = -30796;
        private static final long serialVersionUID = 1L;

        PageCorruptedException() {
            super(-30796, "located page was wrong type");
        }
    }

    public static final class ConstantDerivedException
    extends LmdbNativeException {
        private static final long serialVersionUID = 1L;

        ConstantDerivedException(int rc, String message) {
            super(rc, "Platform constant error code: " + message);
        }
    }
}

