/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import jnr.ffi.Memory;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.byref.IntByReference;
import jnr.ffi.byref.PointerByReference;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.Cursor;
import org.lmdbjava.CursorIterable;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.Env;
import org.lmdbjava.KeyRange;
import org.lmdbjava.Library;
import org.lmdbjava.LmdbNativeException;
import org.lmdbjava.MaskedFlag;
import org.lmdbjava.PutFlags;
import org.lmdbjava.ReferenceUtil;
import org.lmdbjava.ResultCodeMapper;
import org.lmdbjava.Stat;
import org.lmdbjava.Txn;

public final class Dbi<T> {
    private final Library.ComparatorCallback ccb;
    private boolean cleaned;
    private final Comparator<T> comparator;
    private final Env<T> env;
    private final byte[] name;
    private final Pointer ptr;

    Dbi(Env<T> env, Txn<T> txn, byte[] name, Comparator<T> comparator, boolean nativeCb, BufferProxy<T> proxy, DbiFlags ... flags) {
        this.env = env;
        this.name = name == null ? null : Arrays.copyOf(name, name.length);
        this.comparator = comparator;
        int flagsMask = MaskedFlag.mask(flags);
        Pointer dbiPtr = Memory.allocateDirect((Runtime)Library.RUNTIME, (NativeType)NativeType.ADDRESS);
        ResultCodeMapper.checkRc(Library.LIB.mdb_dbi_open(txn.pointer(), name, flagsMask, dbiPtr));
        this.ptr = dbiPtr.getPointer(0L);
        if (nativeCb) {
            this.ccb = (keyA, keyB) -> {
                Object compKeyA = proxy.allocate();
                Object compKeyB = proxy.allocate();
                proxy.out(compKeyA, keyA, keyA.address());
                proxy.out(compKeyB, keyB, keyB.address());
                int result = this.comparator.compare(compKeyA, compKeyB);
                proxy.deallocate(compKeyA);
                proxy.deallocate(compKeyB);
                return result;
            };
            Library.LIB.mdb_set_compare(txn.pointer(), this.ptr, this.ccb);
        } else {
            this.ccb = null;
        }
    }

    public void close() {
        this.clean();
        if (Env.SHOULD_CHECK) {
            this.env.checkNotClosed();
        }
        Library.LIB.mdb_dbi_close(this.env.pointer(), this.ptr);
    }

    public boolean delete(T key) {
        try (Txn<T> txn = this.env.txnWrite();){
            boolean ret = this.delete(txn, key);
            txn.commit();
            boolean bl = ret;
            return bl;
        }
    }

    public boolean delete(Txn<T> txn, T key) {
        return this.delete(txn, key, null);
    }

    public boolean delete(Txn<T> txn, T key, T val) {
        int rc;
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(txn);
            Objects.requireNonNull(key);
            txn.checkReady();
            txn.checkWritesAllowed();
        }
        txn.kv().keyIn(key);
        Pointer data = null;
        if (val != null) {
            txn.kv().valIn(val);
            data = txn.kv().pointerVal();
        }
        if ((rc = Library.LIB.mdb_del(txn.pointer(), this.ptr, txn.kv().pointerKey(), data)) == -30798) {
            return false;
        }
        ResultCodeMapper.checkRc(rc);
        ReferenceUtil.reachabilityFence0(key);
        ReferenceUtil.reachabilityFence0(val);
        return true;
    }

    public void drop(Txn<T> txn) {
        this.drop(txn, false);
    }

    public void drop(Txn<T> txn, boolean delete) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(txn);
            this.env.checkNotClosed();
            txn.checkReady();
            txn.checkWritesAllowed();
        }
        if (delete) {
            this.clean();
        }
        int del = delete ? 1 : 0;
        ResultCodeMapper.checkRc(Library.LIB.mdb_drop(txn.pointer(), this.ptr, del));
    }

    public T get(Txn<T> txn, T key) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(txn);
            Objects.requireNonNull(key);
            this.env.checkNotClosed();
            txn.checkReady();
        }
        txn.kv().keyIn(key);
        int rc = Library.LIB.mdb_get(txn.pointer(), this.ptr, txn.kv().pointerKey(), txn.kv().pointerVal());
        if (rc == -30798) {
            return null;
        }
        ResultCodeMapper.checkRc(rc);
        ReferenceUtil.reachabilityFence0(key);
        return txn.kv().valOut();
    }

    public byte[] getName() {
        return this.name == null ? null : Arrays.copyOf(this.name, this.name.length);
    }

    public CursorIterable<T> iterate(Txn<T> txn) {
        return this.iterate(txn, KeyRange.all());
    }

    public CursorIterable<T> iterate(Txn<T> txn, KeyRange<T> range) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(txn);
            Objects.requireNonNull(range);
            this.env.checkNotClosed();
            txn.checkReady();
        }
        return new CursorIterable<T>(txn, this, range, this.comparator);
    }

    public List<DbiFlags> listFlags(Txn<T> txn) {
        if (Env.SHOULD_CHECK) {
            this.env.checkNotClosed();
        }
        IntByReference resultPtr = new IntByReference();
        ResultCodeMapper.checkRc(Library.LIB.mdb_dbi_flags(txn.pointer(), this.ptr, resultPtr));
        int flags = resultPtr.intValue();
        ArrayList<DbiFlags> result = new ArrayList<DbiFlags>();
        for (DbiFlags flag : DbiFlags.values()) {
            if (!MaskedFlag.isSet(flags, flag)) continue;
            result.add(flag);
        }
        return result;
    }

    public Cursor<T> openCursor(Txn<T> txn) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(txn);
            this.env.checkNotClosed();
            txn.checkReady();
        }
        PointerByReference cursorPtr = new PointerByReference();
        ResultCodeMapper.checkRc(Library.LIB.mdb_cursor_open(txn.pointer(), this.ptr, cursorPtr));
        return new Cursor<T>((Pointer)cursorPtr.getValue(), txn, this.env);
    }

    public void put(T key, T val) {
        try (Txn<T> txn = this.env.txnWrite();){
            this.put(txn, key, val, new PutFlags[0]);
            txn.commit();
        }
    }

    public boolean put(Txn<T> txn, T key, T val, PutFlags ... flags) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(txn);
            Objects.requireNonNull(key);
            Objects.requireNonNull(val);
            this.env.checkNotClosed();
            txn.checkReady();
            txn.checkWritesAllowed();
        }
        txn.kv().keyIn(key);
        txn.kv().valIn(val);
        int mask = MaskedFlag.mask(flags);
        int rc = Library.LIB.mdb_put(txn.pointer(), this.ptr, txn.kv().pointerKey(), txn.kv().pointerVal(), mask);
        if (rc == -30799) {
            if (MaskedFlag.isSet(mask, PutFlags.MDB_NOOVERWRITE)) {
                txn.kv().valOut();
            } else if (!MaskedFlag.isSet(mask, PutFlags.MDB_NODUPDATA)) {
                ResultCodeMapper.checkRc(rc);
            }
            return false;
        }
        ResultCodeMapper.checkRc(rc);
        ReferenceUtil.reachabilityFence0(key);
        ReferenceUtil.reachabilityFence0(val);
        return true;
    }

    public T reserve(Txn<T> txn, T key, int size, PutFlags ... op) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(txn);
            Objects.requireNonNull(key);
            this.env.checkNotClosed();
            txn.checkReady();
            txn.checkWritesAllowed();
        }
        txn.kv().keyIn(key);
        txn.kv().valIn(size);
        int flags = MaskedFlag.mask(op) | PutFlags.MDB_RESERVE.getMask();
        ResultCodeMapper.checkRc(Library.LIB.mdb_put(txn.pointer(), this.ptr, txn.kv().pointerKey(), txn.kv().pointerVal(), flags));
        txn.kv().valOut();
        ReferenceUtil.reachabilityFence0(key);
        return txn.val();
    }

    public Stat stat(Txn<T> txn) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(txn);
            this.env.checkNotClosed();
            txn.checkReady();
        }
        Library.MDB_stat stat = new Library.MDB_stat(Library.RUNTIME);
        ResultCodeMapper.checkRc(Library.LIB.mdb_stat(txn.pointer(), this.ptr, stat));
        return new Stat(stat.f0_ms_psize.intValue(), stat.f1_ms_depth.intValue(), stat.f2_ms_branch_pages.longValue(), stat.f3_ms_leaf_pages.longValue(), stat.f4_ms_overflow_pages.longValue(), stat.f5_ms_entries.longValue());
    }

    private void clean() {
        if (this.cleaned) {
            return;
        }
        this.cleaned = true;
    }

    public static final class MapResizedException
    extends LmdbNativeException {
        static final int MDB_MAP_RESIZED = -30785;
        private static final long serialVersionUID = 1L;

        MapResizedException() {
            super(-30785, "Database contents grew beyond environment mapsize");
        }
    }

    public static final class KeyNotFoundException
    extends LmdbNativeException {
        static final int MDB_NOTFOUND = -30798;
        private static final long serialVersionUID = 1L;

        KeyNotFoundException() {
            super(-30798, "key/data pair not found (EOF)");
        }
    }

    public static final class KeyExistsException
    extends LmdbNativeException {
        static final int MDB_KEYEXIST = -30799;
        private static final long serialVersionUID = 1L;

        KeyExistsException() {
            super(-30799, "key/data pair already exists");
        }
    }

    public static final class IncompatibleException
    extends LmdbNativeException {
        static final int MDB_INCOMPATIBLE = -30784;
        private static final long serialVersionUID = 1L;

        IncompatibleException() {
            super(-30784, "Operation and DB incompatible, or DB type changed");
        }
    }

    public static final class DbFullException
    extends LmdbNativeException {
        static final int MDB_DBS_FULL = -30791;
        private static final long serialVersionUID = 1L;

        DbFullException() {
            super(-30791, "Environment maxdbs reached");
        }
    }

    public static final class BadValueSizeException
    extends LmdbNativeException {
        static final int MDB_BAD_VALSIZE = -30781;
        private static final long serialVersionUID = 1L;

        BadValueSizeException() {
            super(-30781, "Unsupported size of key/DB name/data, or wrong DUPFIXED size");
        }
    }

    public static final class BadDbiException
    extends LmdbNativeException {
        static final int MDB_BAD_DBI = -30780;
        private static final long serialVersionUID = 1L;

        BadDbiException() {
            super(-30780, "The specified DBI was changed unexpectedly");
        }
    }
}

