/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.api.executor;

import cn.sliew.carp.module.scheduler.api.executor.JobContext;
import cn.sliew.carp.module.scheduler.api.executor.JobHandler;
import cn.sliew.carp.module.scheduler.api.executor.entity.job.JobExecutionResult;
import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.concurrent.CallableWrapper;
import cn.sliew.milky.common.exception.Rethrower;
import java.util.Objects;

public class JobThread
implements CallableWrapper<JobExecutionResult> {
    private final JobHandler jobHandler;
    private final JobContext context;
    private JobExecutionResult result;

    public JobThread(JobHandler jobHandler, JobContext context) {
        this.jobHandler = (JobHandler)Ensures.checkNotNull((Object)jobHandler);
        this.context = (JobContext)Ensures.checkNotNull((Object)context);
    }

    public String getJobId() {
        return this.context.getJobId();
    }

    public String getJobInstanceId() {
        return this.context.getJobInstanceId();
    }

    public void onBefore() throws Exception {
        this.result = this.jobHandler.init(this.context);
    }

    public JobExecutionResult doCall() throws Exception {
        if (Objects.nonNull(this.result)) {
            return this.result;
        }
        return this.jobHandler.execute(this.context);
    }

    public void onFailure(Exception e) {
        Rethrower.throwAs((Throwable)e);
    }

    public void onFinal() {
        this.jobHandler.destroy(this.context);
    }
}

