/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.api.executor;

import cn.sliew.carp.framework.common.dict.schedule.CarpScheduleJobType;
import cn.sliew.carp.module.scheduler.api.dict.CarpScheduleExecuteType;
import cn.sliew.carp.module.scheduler.api.executor.JobExecutor;
import cn.sliew.carp.module.scheduler.api.executor.JobExecutorManager;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class DefaultJobexecutorManager
implements JobExecutorManager {
    private List<JobExecutor> executors;

    public DefaultJobexecutorManager(List<JobExecutor> executors) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(executors), (Object)"executors not allowed empty");
        this.executors = executors;
    }

    @Override
    public List<CarpScheduleJobType> listTypes() {
        return this.executors.stream().map(JobExecutor::getType).collect(Collectors.toList());
    }

    @Override
    public List<CarpScheduleExecuteType> listExecutorTypes(CarpScheduleJobType jobType) {
        return Optional.of(this.getExecutor(jobType)).map(JobExecutor::getSupportExecuteTypes).orElseThrow();
    }

    @Override
    public JobExecutor getExecutor(CarpScheduleJobType jobType) {
        return this.executors.stream().filter(executor -> Objects.equals(executor.getType(), jobType)).findFirst().orElseThrow();
    }
}

