/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.api.configuration;

import cn.sliew.carp.module.scheduler.api.annotation.CarpJob;
import cn.sliew.carp.module.scheduler.api.executor.JobHandler;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathCarpJobScanner
extends ClassPathBeanDefinitionScanner {
    public ClassPathCarpJobScanner(BeanDefinitionRegistry registry) {
        super(registry);
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)String.format("No @CarpJob definition was found. Please check your configuration.", new Object[0]));
        }
        return beanDefinitions;
    }

    public void registerFilters() {
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(CarpJob.class, true, true));
        this.addIncludeFilter((TypeFilter)new AssignableTypeFilter(JobHandler.class));
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
            String className = metadataReader.getClassMetadata().getClassName();
            return className.endsWith("package-info");
        });
    }
}

