/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.typed.state.internal;

import org.apache.pekko.actor.Dropped$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.StashBuffer;
import org.apache.pekko.actor.typed.scaladsl.StashOverflowException;
import org.apache.pekko.actor.typed.scaladsl.adapter.package;
import org.apache.pekko.actor.typed.scaladsl.package;
import org.apache.pekko.actor.typed.scaladsl.package$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.typed.state.internal.BehaviorSetup;
import org.apache.pekko.persistence.typed.state.internal.InternalProtocol;
import org.apache.pekko.persistence.typed.state.internal.StashOverflowStrategy;
import org.apache.pekko.persistence.typed.state.internal.StashOverflowStrategy$Drop$;
import org.apache.pekko.persistence.typed.state.internal.StashOverflowStrategy$Fail$;
import org.apache.pekko.persistence.typed.state.internal.StashState;
import org.apache.pekko.util.ConstantFun$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001C\b\u0011!\u0003\r\t\u0001\u0007\u0010\t\u000b\u0019\u0002A\u0011\u0001\u0015\t\u000b1\u0002a\u0011A\u0017\t\u000b\u0001\u0003A\u0011B!\t\u000b9\u0003A\u0011B(\t\u000bM\u0003A\u0011\u0003+\t\u000ba\u0003A\u0011C-\t\u000b\u0001\u0004A\u0011C1\t\u000b\r\u0004A\u0011\u00023\t\u000b-\u0004A\u0011\u00037\t\u000b=\u0004A\u0011\u0003\u0015\t\u000bA\u0004A\u0011\u0003+\t\u000bE\u0004A\u0011\u0002:\t\u000bU\u0004A\u0011\u0002<\t\u000ba\u0004A\u0011\u0002\u0015\u0003\u001fM#\u0018m\u001d5NC:\fw-Z7f]RT!!\u0005\n\u0002\u0011%tG/\u001a:oC2T!a\u0005\u000b\u0002\u000bM$\u0018\r^3\u000b\u0005U1\u0012!\u0002;za\u0016$'BA\f\u0019\u0003-\u0001XM]:jgR,gnY3\u000b\u0005eQ\u0012!\u00029fW.|'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e,2a\b\u001b?'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0004\u0001Q\t\u0011\u0006\u0005\u0002\"U%\u00111F\t\u0002\u0005+:LG/A\u0003tKR,\b/F\u0001/!\u0011y\u0003GM\u001f\u000e\u0003AI!!\r\t\u0003\u001b\t+\u0007.\u0019<j_J\u001cV\r^;q!\t\u0019D\u0007\u0004\u0001\u0005\u000bU\u0002!\u0019\u0001\u001c\u0003\u0003\r\u000b\"a\u000e\u001e\u0011\u0005\u0005B\u0014BA\u001d#\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!I\u001e\n\u0005q\u0012#aA!osB\u00111G\u0010\u0003\u0006\u007f\u0001\u0011\rA\u000e\u0002\u0002'\u000691m\u001c8uKb$X#\u0001\"\u0011\u0007\rK5*D\u0001E\u0015\t)e)\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t)rI\u0003\u0002I1\u0005)\u0011m\u0019;pe&\u0011!\n\u0012\u0002\r\u0003\u000e$xN]\"p]R,\u0007\u0010\u001e\t\u0003_1K!!\u0014\t\u0003!%sG/\u001a:oC2\u0004&o\u001c;pG>d\u0017AC:uCND7\u000b^1uKV\t\u0001\u000b\u0005\u00020#&\u0011!\u000b\u0005\u0002\u000b'R\f7\u000f[*uCR,\u0017\u0001F5t\u0013:$XM\u001d8bYN#\u0018m\u001d5F[B$\u00180F\u0001V!\t\tc+\u0003\u0002XE\t9!i\\8mK\u0006t\u0017!D:uCND\u0017J\u001c;fe:\fG\u000e\u0006\u0002[=B\u00191\fX&\u000e\u0003\u0019K!!\u0018$\u0003\u0011\t+\u0007.\u0019<j_JDQa\u0018\u0004A\u0002-\u000b1!\\:h\u0003%\u0019H/Y:i+N,'\u000f\u0006\u0002*E\")ql\u0002a\u0001\u0017\u0006)1\u000f^1tQR\u0019\u0011&\u001a4\t\u000b}C\u0001\u0019A&\t\u000b\u001dD\u0001\u0019\u00015\u0002\r\t,hMZ3s!\r\u0019\u0015nS\u0005\u0003U\u0012\u00131b\u0015;bg\"\u0014UO\u001a4fe\u0006iAO]=V]N$\u0018m\u001d5P]\u0016$\"AW7\t\u000b9L\u0001\u0019\u0001.\u0002\u0011\t,\u0007.\u0019<j_J\f!\"\u001e8ti\u0006\u001c\b.\u00117m\u0003YI7/\u00168ti\u0006\u001c\b.\u00117m\u0013:\u0004&o\\4sKN\u001c\u0018a\u00047pON#\u0018m\u001d5NKN\u001c\u0018mZ3\u0015\u0007%\u001aH\u000fC\u0003`\u0019\u0001\u00071\nC\u0003h\u0019\u0001\u0007\u0001.A\tm_\u001e,fn\u001d;bg\"lUm]:bO\u0016$\"!K<\t\u000b\u001dl\u0001\u0019\u00015\u0002\u001b1|w-\u00168ti\u0006\u001c\b.\u00117mQ\t\u0001!\u0010\u0005\u0002|}6\tAP\u0003\u0002~1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005}d(aC%oi\u0016\u0014h.\u00197Ba&\u0004")
@InternalApi
public interface StashManagement<C, S> {
    public BehaviorSetup<C, S> setup();

    private ActorContext<InternalProtocol> context() {
        return this.setup().context();
    }

    private StashState stashState() {
        return this.setup().stashState();
    }

    public static /* synthetic */ boolean isInternalStashEmpty$(StashManagement $this) {
        return $this.isInternalStashEmpty();
    }

    default public boolean isInternalStashEmpty() {
        return this.stashState().internalStashBuffer().isEmpty();
    }

    public static /* synthetic */ Behavior stashInternal$(StashManagement $this, InternalProtocol msg) {
        return $this.stashInternal(msg);
    }

    default public Behavior<InternalProtocol> stashInternal(InternalProtocol msg) {
        this.stash(msg, this.stashState().internalStashBuffer());
        return Behaviors$.MODULE$.same();
    }

    public static /* synthetic */ void stashUser$(StashManagement $this, InternalProtocol msg) {
        $this.stashUser(msg);
    }

    default public void stashUser(InternalProtocol msg) {
        this.stash(msg, this.stashState().userStashBuffer());
    }

    private void stash(InternalProtocol msg, StashBuffer<InternalProtocol> buffer) {
        this.logStashMessage(msg, buffer);
        try {
            buffer.stash((Object)msg);
            return;
        }
        catch (StashOverflowException e) {
            StashOverflowStrategy stashOverflowStrategy = this.setup().settings().stashOverflowStrategy();
            if (StashOverflowStrategy$Drop$.MODULE$.equals(stashOverflowStrategy)) {
                String dropName = msg instanceof InternalProtocol.IncomingCommand ? ((InternalProtocol.IncomingCommand)msg).c().getClass().getName() : msg.getClass().getName();
                this.context().log().warn("Stash buffer is full, dropping message [{}]", new Object[]{dropName});
                package.TypedActorSystemOps$.MODULE$.toClassic$extension(org.apache.pekko.actor.typed.scaladsl.adapter.package$.MODULE$.TypedActorSystemOps(this.context().system())).eventStream().publish((Object)Dropped$.MODULE$.apply((Object)msg, "Stash buffer is full", package.TypedActorRefOps$.MODULE$.toClassic$extension(org.apache.pekko.actor.typed.scaladsl.adapter.package$.MODULE$.TypedActorRefOps(this.context().self()))));
                return;
            }
            if (StashOverflowStrategy$Fail$.MODULE$.equals(stashOverflowStrategy)) {
                throw e;
            }
            throw new MatchError((Object)stashOverflowStrategy);
        }
    }

    public static /* synthetic */ Behavior tryUnstashOne$(StashManagement $this, Behavior behavior) {
        return $this.tryUnstashOne((Behavior<InternalProtocol>)behavior);
    }

    default public Behavior<InternalProtocol> tryUnstashOne(Behavior<InternalProtocol> behavior) {
        StashBuffer<InternalProtocol> buffer;
        StashBuffer<InternalProtocol> stashBuffer = buffer = this.stashState().isUnstashAllInProgress() ? this.stashState().userStashBuffer() : this.stashState().internalStashBuffer();
        if (buffer.nonEmpty()) {
            this.logUnstashMessage(buffer);
            this.stashState().decrementUnstashAllProgress();
            return buffer.unstash(behavior, 1, ConstantFun$.MODULE$.scalaIdentityFunction());
        }
        return behavior;
    }

    public static /* synthetic */ void unstashAll$(StashManagement $this) {
        $this.unstashAll();
    }

    default public void unstashAll() {
        if (this.stashState().userStashBuffer().nonEmpty()) {
            this.logUnstashAll();
            this.stashState().startUnstashAll();
            return;
        }
    }

    public static /* synthetic */ boolean isUnstashAllInProgress$(StashManagement $this) {
        return $this.isUnstashAllInProgress();
    }

    default public boolean isUnstashAllInProgress() {
        return this.stashState().isUnstashAllInProgress();
    }

    private void logStashMessage(InternalProtocol msg, StashBuffer<InternalProtocol> buffer) {
        if (this.setup().settings().logOnStashing()) {
            package.LoggerOps$.MODULE$.debugN$extension0(package$.MODULE$.LoggerOps(this.setup().internalLogger()), "Stashing message to {} stash: [{}] ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer == this.stashState().internalStashBuffer() ? "internal" : "user", msg}));
            return;
        }
    }

    private void logUnstashMessage(StashBuffer<InternalProtocol> buffer) {
        if (this.setup().settings().logOnStashing()) {
            package.LoggerOps$.MODULE$.debugN$extension0(package$.MODULE$.LoggerOps(this.setup().internalLogger()), "Unstashing message from {} stash: [{}]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer == this.stashState().internalStashBuffer() ? "internal" : "user", buffer.head()}));
            return;
        }
    }

    private void logUnstashAll() {
        if (this.setup().settings().logOnStashing()) {
            package.LoggerOps$.MODULE$.debug2$extension0(package$.MODULE$.LoggerOps(this.setup().internalLogger()), "Unstashing all [{}] messages from user stash, first is: [{}]", (Object)BoxesRunTime.boxToInteger((int)this.stashState().userStashBuffer().size()), this.stashState().userStashBuffer().head());
            return;
        }
    }

    public static void $init$(StashManagement $this) {
    }
}

