/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import org.lmdbjava.Dbi;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.Env;
import org.lmdbjava.LmdbException;
import org.lmdbjava.PutFlags;
import org.lmdbjava.Txn;

public final class Verifier
implements Callable<Long> {
    public static final int DBI_COUNT = 5;
    private static final int BATCH_SIZE = 64;
    private static final int BUFFER_LEN = 65536;
    private static final int CRC_LENGTH = 8;
    private static final int KEY_LENGTH = 8;
    private final byte[] ba = new byte[65536];
    private final CRC32 crc = new CRC32();
    private final List<Dbi<ByteBuffer>> dbis = new ArrayList<Dbi<ByteBuffer>>(5);
    private final Env<ByteBuffer> env;
    private long id;
    private final ByteBuffer key = ByteBuffer.allocateDirect(8);
    private final AtomicBoolean proceed = new AtomicBoolean(true);
    private final Random rnd = new Random();
    private Txn<ByteBuffer> txn;
    private final ByteBuffer val = ByteBuffer.allocateDirect(65536);

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public Verifier(Env<ByteBuffer> env) {
        Objects.requireNonNull(env);
        this.env = env;
        this.key.order(ByteOrder.BIG_ENDIAN);
        this.deleteDbis();
        this.createDbis();
    }

    @Override
    public Long call() {
        try {
            while (this.proceed.get()) {
                this.transactionControl();
                this.write(this.id);
                if (this.id > 0L) {
                    this.fetchAndDelete(this.id - 1L);
                }
                ++this.id;
            }
        }
        finally {
            if (this.txn != null) {
                this.txn.close();
            }
        }
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runFor(long duration, TimeUnit unit) {
        long result;
        long deadline = System.currentTimeMillis() + unit.toMillis(duration);
        ExecutorService es = Executors.newSingleThreadExecutor();
        Future<Long> future = es.submit(this);
        try {
            while (System.currentTimeMillis() < deadline && !future.isDone()) {
                Thread.sleep(unit.toMillis(1L));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.stop();
        }
        try {
            result = future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            es.shutdown();
        }
        return result;
    }

    private void createDbis() {
        for (int i = 0; i < 5; ++i) {
            this.dbis.add(this.env.openDbi(Verifier.class.getSimpleName() + i, DbiFlags.MDB_CREATE));
        }
    }

    private void deleteDbis() {
        for (byte[] existingDbiName : this.env.getDbiNames()) {
            Dbi<ByteBuffer> existingDbi = this.env.openDbi(existingDbiName, new DbiFlags[0]);
            Txn<ByteBuffer> txn = this.env.txnWrite();
            Throwable throwable = null;
            try {
                existingDbi.drop(txn, true);
                txn.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txn == null) continue;
                if (throwable != null) {
                    try {
                        txn.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                txn.close();
            }
        }
    }

    private void fetchAndDelete(long forId) {
        ByteBuffer fetchedValue;
        Dbi<ByteBuffer> dbi = this.getDbi(forId);
        this.updateKey(forId);
        try {
            fetchedValue = dbi.get(this.txn, this.key);
        }
        catch (LmdbException ex) {
            throw new IllegalStateException("DB get id=" + forId, ex);
        }
        if (fetchedValue == null) {
            throw new IllegalStateException("DB not found id=" + forId);
        }
        this.verifyValue(forId, fetchedValue);
        try {
            dbi.delete(this.txn, this.key);
        }
        catch (LmdbException ex) {
            throw new IllegalStateException("DB del id=" + forId, ex);
        }
    }

    private Dbi<ByteBuffer> getDbi(long forId) {
        return this.dbis.get((int)(forId % (long)this.dbis.size()));
    }

    private void stop() {
        this.proceed.set(false);
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
    private void transactionControl() {
        if (this.id % 64L == 0L) {
            if (this.txn != null) {
                this.txn.commit();
                this.txn.close();
            }
            this.rnd.nextBytes(this.ba);
            this.txn = this.env.txnWrite();
        }
    }

    private void updateKey(long forId) {
        this.key.clear();
        this.key.putLong(forId);
        this.key.flip();
    }

    private void updateValue(long forId) {
        int rndSize = this.valueSize(forId);
        this.crc.reset();
        this.crc.update((int)forId);
        this.crc.update(this.ba, 8, rndSize);
        long crcVal = this.crc.getValue();
        this.val.clear();
        this.val.putLong(crcVal);
        this.val.put(this.ba, 8, rndSize);
        this.val.flip();
    }

    private int valueSize(long forId) {
        int mod = (int)(forId % 64L);
        int base = 1024 * mod;
        int value = base == 0 ? 512 : base;
        return value - 8 - 8;
    }

    private void verifyValue(long forId, ByteBuffer bb) {
        int rndSize = this.valueSize(forId);
        int expected = rndSize + 8;
        if (bb.limit() != expected) {
            throw new IllegalStateException("Limit error id=" + forId + " exp=" + expected + " limit=" + bb.limit());
        }
        long crcRead = bb.getLong();
        this.crc.reset();
        this.crc.update((int)forId);
        this.crc.update(bb);
        long crcVal = this.crc.getValue();
        if (crcRead != crcVal) {
            throw new IllegalStateException("CRC error id=" + forId);
        }
    }

    private void write(long forId) {
        Dbi<ByteBuffer> dbi = this.getDbi(forId);
        this.updateKey(forId);
        this.updateValue(forId);
        try {
            dbi.put(this.txn, this.key, this.val, new PutFlags[0]);
        }
        catch (LmdbException ex) {
            throw new IllegalStateException("DB put id=" + forId, ex);
        }
    }
}

