/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.redisson.RedissonQueue;
import org.redisson.api.Entry;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonBlockingQueue<V>
extends RedissonQueue<V>
implements RBlockingQueue<V> {
    public RedissonBlockingQueue(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
    }

    public RedissonBlockingQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    public RedissonBlockingQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name, null);
        this.name = name;
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        return this.addAsync(e, RedisCommands.RPUSH_VOID);
    }

    @Override
    public void put(V e) throws InterruptedException {
        this.get(this.putAsync(e));
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public RFuture<V> takeAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BLPOP_VALUE, this.getRawName(), 0);
    }

    @Override
    public V take() throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeAsync());
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            return new CompletableFutureWrapper<Object>(null);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BLPOP_VALUE, this.getRawName(), this.toSeconds(timeout, unit));
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollAsync(timeout, unit));
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public Entry<String, V> pollFromAnyWithName(Duration timeout, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollFromAnyWithNameAsync(timeout, queueNames));
    }

    @Override
    public RFuture<Entry<String, V>> pollFromAnyWithNameAsync(Duration timeout, String ... queueNames) {
        if (timeout.toMillis() < 0L) {
            return new CompletableFutureWrapper<Entry<String, V>>((Entry)null);
        }
        return this.commandExecutor.pollFromAnyAsync(this.getRawName(), this.codec, RedisCommands.BLPOP_NAME, this.toSeconds(timeout.toMillis(), TimeUnit.MILLISECONDS), queueNames);
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        if (timeout < 0L) {
            return new CompletableFutureWrapper<Object>(null);
        }
        return this.commandExecutor.pollFromAnyAsync(this.getRawName(), this.codec, RedisCommands.BLPOP_VALUE, this.toSeconds(timeout, unit), queueNames);
    }

    @Override
    public Map<String, List<V>> pollFirstFromAny(Duration duration, int count, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollFirstFromAnyAsync(duration, count, queueNames));
    }

    @Override
    public RFuture<Map<String, List<V>>> pollFirstFromAnyAsync(Duration duration, int count, String ... queueNames) {
        List mappedNames = Arrays.stream(queueNames).map(m -> this.getServiceManager().getConfig().getNameMapper().map((String)m)).collect(Collectors.toList());
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.toSeconds(duration.getSeconds(), TimeUnit.SECONDS));
        params.add(queueNames.length + 1);
        params.add(this.getRawName());
        params.addAll(mappedNames);
        params.add("LEFT");
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BLMPOP, params.toArray());
    }

    @Override
    public Map<String, List<V>> pollLastFromAny(Duration duration, int count, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollLastFromAnyAsync(duration, count, queueNames));
    }

    @Override
    public RFuture<Map<String, List<V>>> pollLastFromAnyAsync(Duration duration, int count, String ... queueNames) {
        List mappedNames = Arrays.stream(queueNames).map(m -> this.getServiceManager().getConfig().getNameMapper().map((String)m)).collect(Collectors.toList());
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.toSeconds(duration.getSeconds(), TimeUnit.SECONDS));
        params.add(queueNames.length + 1);
        params.add(this.getRawName());
        params.addAll(mappedNames);
        params.add("RIGHT");
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BLMPOP, params.toArray());
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            return new CompletableFutureWrapper<Object>(null);
        }
        String mappedName = this.getServiceManager().getConfig().getNameMapper().map(queueName);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BRPOPLPUSH, this.getRawName(), mappedName, this.toSeconds(timeout, unit));
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollLastAndOfferFirstToAsync(queueName, timeout, unit));
    }

    @Override
    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        return this.pollLastAndOfferFirstToAsync(queueName, 0L, TimeUnit.SECONDS);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.get(this.drainToAsync(c));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('del', KEYS[1]); return vals", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        return this.get(this.drainToAsync(c, maxElements));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); return vals", Collections.singletonList(this.getRawName()), maxElements);
    }

    @Override
    public int subscribeOnElements(Consumer<V> consumer) {
        return this.getServiceManager().getElementsSubscribeService().subscribeOnElements(this::takeAsync, consumer);
    }

    @Override
    public void unsubscribe(int listenerId) {
        this.getServiceManager().getElementsSubscribeService().unsubscribe(listenerId);
    }
}

