/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.spring.authentication;

import cn.sliew.carp.framework.web.util.I18nUtil;
import cn.sliew.carp.module.security.core.service.SecAuthenticationService;
import cn.sliew.carp.module.security.core.service.SecUserService;
import cn.sliew.carp.module.security.core.service.dto.OnlineUserVO;
import cn.sliew.carp.module.security.core.service.dto.SecResourceWebDTO;
import cn.sliew.carp.module.security.core.service.dto.SecRoleDTO;
import cn.sliew.carp.module.security.core.service.dto.SecUserDTO;
import cn.sliew.carp.module.security.spring.authentication.CarpUserDetail;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CarpUserDetailsServiceImpl
implements UserDetailsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CarpUserDetailsServiceImpl.class);
    @Autowired
    private SecUserService secUserService;
    @Autowired
    private SecAuthenticationService secAuthenticationService;

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        try {
            Optional optional = this.secUserService.getByUserName(userName);
            SecUserDTO secUserDTO = (SecUserDTO)optional.orElseThrow(() -> new BadCredentialsException(I18nUtil.get((String)"response.error.login.password")));
            return this.fillUserDetails(secUserDTO);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38! userName: {}", (Object)userName, (Object)e);
            throw new UsernameNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public CarpUserDetail fillUserDetails(SecUserDTO secUserDTO) {
        CarpUserDetail user = new CarpUserDetail();
        user.setUser(secUserDTO);
        OnlineUserVO onlineUser = this.secAuthenticationService.getOnlineUser(secUserDTO);
        user.setRoles(onlineUser.getRoles());
        user.setResourceWebs(onlineUser.getResourceWebs());
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.addAll(this.roles2GrantedAuthority(user.getRoles()));
        authorities.addAll(this.resourceWebs2GrantedAuthority(user.getResourceWebs()));
        user.setAuthorities(authorities);
        return user;
    }

    private List<GrantedAuthority> roles2GrantedAuthority(Set<SecRoleDTO> roles) {
        if (CollectionUtils.isEmpty(roles)) {
            return Collections.emptyList();
        }
        String[] roleAuthrities = (String[])roles.stream().map(role -> "ROLE_" + role.getCode().toUpperCase()).toArray(String[]::new);
        return AuthorityUtils.createAuthorityList((String[])roleAuthrities);
    }

    private List<GrantedAuthority> resourceWebs2GrantedAuthority(Set<SecResourceWebDTO> resourceWebList) {
        if (CollectionUtils.isEmpty(resourceWebList)) {
            return Collections.emptyList();
        }
        String[] resourceWebAuthrities = (String[])resourceWebList.stream().map(resource -> "ROLE_" + resource.getValue()).toArray(String[]::new);
        return AuthorityUtils.createAuthorityList((String[])resourceWebAuthrities);
    }
}

