/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.dataservice.domain.dao;

import cn.sliew.carp.framework.common.dict.datasource.CarpDataSourceType;
import cn.sliew.carp.module.dataservice.domain.dao.DaoExecutor;
import cn.sliew.carp.module.dataservice.domain.dao.mybatis.MybatisDaoExecutor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DaoExecutorRegistry
implements InitializingBean {
    private ConcurrentMap<CarpDataSourceType, DaoExecutor> registry = new ConcurrentHashMap<CarpDataSourceType, DaoExecutor>();
    @Autowired
    private MybatisDaoExecutor mybatisDataServiceExecutor;

    public void afterPropertiesSet() throws Exception {
        this.register(CarpDataSourceType.MYSQL, this.mybatisDataServiceExecutor);
    }

    public DaoExecutor get(CarpDataSourceType dataSourceType) {
        return (DaoExecutor)this.registry.get(dataSourceType);
    }

    public void register(CarpDataSourceType dataSourceType, DaoExecutor daoExecutor) {
        this.registry.put(dataSourceType, daoExecutor);
    }

    public void unregister(CarpDataSourceType dataSourceType) {
        this.registry.remove(dataSourceType);
    }
}

