/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.dataservice.domain.controller.spring;

import cn.hutool.extra.spring.SpringUtil;
import cn.sliew.carp.module.dataservice.domain.controller.ControllerExecutor;
import cn.sliew.carp.module.dataservice.domain.controller.spring.SpringDynamicRouteController;
import cn.sliew.carp.module.dataservice.service.param.ExecuteParam;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class SpringControllerExecutor
implements ControllerExecutor {
    private ConcurrentMap<String, RequestMappingInfo> registry = new ConcurrentHashMap<String, RequestMappingInfo>();

    @Override
    public void register(String id, String path) {
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)SpringUtil.getBean((String)"requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        SpringDynamicRouteController dynamicRouteController = (SpringDynamicRouteController)SpringUtil.getBean(SpringDynamicRouteController.class);
        RequestMappingInfo mappingInfo = RequestMappingInfo.paths((String[])new String[]{"/api/carp/data-service/route/" + path}).methods(new RequestMethod[]{RequestMethod.POST}).build();
        this.registry.put(id, mappingInfo);
        Method method = MethodUtils.getAccessibleMethod(SpringDynamicRouteController.class, (String)"execute", (Class[])new Class[]{HttpServletRequest.class, ExecuteParam.class});
        requestMappingHandlerMapping.registerMapping(mappingInfo, (Object)dynamicRouteController, method);
    }

    @Override
    public void unregister(String id) {
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)SpringUtil.getBean((String)"requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        requestMappingHandlerMapping.unregisterMapping((Object)((RequestMappingInfo)this.registry.remove(id)));
    }
}

