/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model.processor;

import cn.sliew.carp.module.http.sync.framework.model.processor.AbstractRootTask;
import cn.sliew.carp.module.http.sync.framework.model.processor.DefaultJobContext;
import cn.sliew.carp.module.http.sync.framework.model.processor.FetchResult;
import cn.sliew.carp.module.http.sync.framework.model.processor.ProcessResult;
import cn.sliew.carp.module.http.sync.framework.model.processor.Result;
import cn.sliew.carp.module.http.sync.framework.model.processor.SubTask;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.japi.function.Procedure;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.javadsl.Sink;
import org.apache.pekko.stream.javadsl.Source;
import scala.concurrent.ExecutionContext;

public abstract class AbstractSubTask<Root extends AbstractRootTask, Request, Response>
implements SubTask<DefaultJobContext, Root> {
    private final Long subTaskId;
    private final Root rootTask;
    private final String startSyncOffset;
    private final String endSyncOffset;

    public AbstractSubTask(Long subTaskId, Root rootTask, String startSyncOffset, String endSyncOffset) {
        this.subTaskId = subTaskId;
        this.rootTask = rootTask;
        this.startSyncOffset = startSyncOffset;
        this.endSyncOffset = endSyncOffset;
    }

    @Override
    public Long getIdentifier() {
        return this.subTaskId;
    }

    @Override
    public Root getRootTask() {
        return this.rootTask;
    }

    @Override
    public String getStartSyncOffset() {
        return this.startSyncOffset;
    }

    @Override
    public String getEndSyncOffset() {
        return this.endSyncOffset;
    }

    @Override
    public CompletableFuture<Result> execute(DefaultJobContext context) {
        ActorSystem actorSystem = context.getActorSystem();
        Sink sink = Sink.foreachParallel((int)10, (Procedure & Serializable)data -> this.persistData(context, data.getRequest(), data.getResponse()), (ExecutionContext)actorSystem.executionContext());
        Source<FetchResult<Request, Response>, ?> source = this.fetch(context);
        CompletionStage completionStage = (CompletionStage)source.withAttributes(ActorAttributes.dispatcher((String)context.dispatcher())).runWith((Graph)sink, (ClassicActorSystemProvider)actorSystem);
        return completionStage.thenApply(done -> ProcessResult.success(this)).toCompletableFuture();
    }

    protected abstract Source<FetchResult<Request, Response>, ?> fetch(DefaultJobContext var1);

    protected abstract Request buildFirstRequest(DefaultJobContext var1);

    protected abstract Response requestRemote(DefaultJobContext var1, Request var2);

    protected abstract void persistData(DefaultJobContext var1, Request var2, Response var3);
}

