/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model.manager;

import cn.sliew.carp.module.http.sync.framework.model.JobSetting;
import cn.sliew.carp.module.http.sync.framework.model.job.JobInfo;
import cn.sliew.carp.module.http.sync.framework.model.manager.SyncOffsetManager;
import cn.sliew.carp.module.http.sync.framework.model.processor.DefaultJobContext;
import cn.sliew.carp.module.http.sync.framework.repository.entity.JobSyncOffset;
import cn.sliew.carp.module.http.sync.framework.repository.mapper.JobSyncOffsetMapper;
import cn.sliew.milky.common.check.Ensures;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Objects;

public class DefaultSyncOffsetManager
implements SyncOffsetManager<DefaultJobContext> {
    private JobSetting setting;
    private JobSyncOffsetMapper jobSyncOffsetMapper;

    public DefaultSyncOffsetManager(JobSetting setting, JobSyncOffsetMapper jobSyncOffsetMapper) {
        this.setting = (JobSetting)Ensures.checkNotNull((Object)setting);
        this.jobSyncOffsetMapper = jobSyncOffsetMapper;
    }

    @Override
    public String initSyncOffset() {
        return this.setting.getInitSyncOffset();
    }

    @Override
    public String finalSyncOffset() {
        return this.setting.getFinalSyncOffset();
    }

    @Override
    public JobSyncOffset getSyncOffset(DefaultJobContext context) {
        LambdaQueryWrapper<JobSyncOffset> queryWrapper = this.buildQueryWrapper(this.setting.getJobInfo());
        JobSyncOffset syncOffset = (JobSyncOffset)((Object)this.jobSyncOffsetMapper.selectOne((Wrapper)queryWrapper));
        if (Objects.nonNull((Object)syncOffset)) {
            if (this.needResetSyncOffset(syncOffset)) {
                this.resetSyncOffset(context);
                return this.getSyncOffset(context);
            }
            return syncOffset;
        }
        this.initSyncOffset(context);
        return this.getSyncOffset(context);
    }

    @Override
    public void initSyncOffset(DefaultJobContext context) {
        JobInfo jobInfo = this.setting.getJobInfo();
        JobSyncOffset record = new JobSyncOffset();
        record.setGroup(jobInfo.getGroup());
        record.setJob(jobInfo.getJob());
        jobInfo.getSubJob().ifPresent(subJob -> record.setSubJob((String)subJob));
        jobInfo.getAccount().ifPresent(account -> record.setAccount((String)account));
        jobInfo.getSubAccount().ifPresent(subAccount -> record.setSubAccount((String)subAccount));
        record.setSyncOffset(this.initSyncOffset());
        record.setCreator("sync-offset-manager");
        record.setEditor("sync-offset-manager");
        this.jobSyncOffsetMapper.insert((Object)record);
    }

    @Override
    public void updateSyncOffset(DefaultJobContext context, String syncOffset) {
        JobSyncOffset jobSyncOffset = this.getSyncOffset(context);
        LambdaQueryWrapper<JobSyncOffset> queryWrapper = this.buildQueryWrapper(this.setting.getJobInfo());
        JobInfo jobInfo = this.setting.getJobInfo();
        JobSyncOffset record = new JobSyncOffset();
        record.setGroup(jobInfo.getGroup());
        record.setJob(jobInfo.getJob());
        jobInfo.getSubJob().ifPresent(subJob -> record.setSubJob((String)subJob));
        jobInfo.getAccount().ifPresent(account -> record.setAccount((String)account));
        jobInfo.getSubAccount().ifPresent(subAccount -> record.setSubAccount((String)subAccount));
        record.setLastSyncOffset(jobSyncOffset.getSyncOffset());
        record.setSyncOffset(syncOffset);
        record.setEditor("sync-offset-manager");
        this.jobSyncOffsetMapper.update((Object)record, (Wrapper)queryWrapper);
    }

    @Override
    public boolean needResetSyncOffset(JobSyncOffset syncOffset) {
        return this.initSyncOffset().compareTo(syncOffset.getSyncOffset()) > 0;
    }

    @Override
    public void resetSyncOffset(DefaultJobContext context) {
        LambdaQueryWrapper<JobSyncOffset> queryWrapper = this.buildQueryWrapper(this.setting.getJobInfo());
        this.jobSyncOffsetMapper.delete((Wrapper)queryWrapper);
        this.initSyncOffset(context);
    }

    protected LambdaQueryWrapper<JobSyncOffset> buildQueryWrapper(JobInfo jobInfo) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(JobSyncOffset.class).eq(JobSyncOffset::getGroup, (Object)jobInfo.getGroup())).eq(JobSyncOffset::getJob, (Object)jobInfo.getJob());
        if (jobInfo.getSubJob().isPresent()) {
            queryWrapper.eq(JobSyncOffset::getSubJob, (Object)jobInfo.getSubJob().get());
        }
        if (jobInfo.getAccount().isPresent()) {
            queryWrapper.eq(JobSyncOffset::getAccount, (Object)jobInfo.getAccount().get());
        }
        if (jobInfo.getSubAccount().isPresent()) {
            queryWrapper.eq(JobSyncOffset::getSubAccount, (Object)jobInfo.getSubAccount().get());
        }
        return queryWrapper;
    }
}

