/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model.manager;

import cn.hutool.core.date.DateUtil;
import cn.sliew.carp.module.http.sync.framework.model.JobSetting;
import cn.sliew.carp.module.http.sync.framework.model.manager.SplitManager;
import cn.sliew.carp.module.http.sync.framework.util.SyncOffsetHelper;
import cn.sliew.milky.common.check.Ensures;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pekko.japi.Pair;

public class DefaultSplitManager
implements SplitManager {
    private final JobSetting setting;

    public DefaultSplitManager(JobSetting setting) {
        this.setting = (JobSetting)Ensures.checkNotNull((Object)setting);
    }

    @Override
    public Duration getMinGradient() {
        return this.setting.getMinGradient();
    }

    @Override
    public boolean forceMinGradient() {
        return this.setting.getForceMinGradient();
    }

    @Override
    public Integer getMaxSplitSize() {
        return this.setting.getBatchSize();
    }

    @Override
    public List<Duration> getGradients() {
        return this.setting.getGradients();
    }

    @Override
    public boolean supportSplit(String startSyncOffset, String endSyncOffset, Duration gradient) {
        LocalDateTime startTime = LocalDateTime.parse(startSyncOffset, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime endTime = LocalDateTime.parse(endSyncOffset, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return SyncOffsetHelper.supportSplit(startTime, endTime, gradient);
    }

    @Override
    public List<Pair<String, String>> split(String startSyncOffset, String endSyncOffset, Duration gradient) {
        LocalDateTime startTime = LocalDateTime.parse(startSyncOffset, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime endTime = LocalDateTime.parse(endSyncOffset, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return SyncOffsetHelper.split(startTime, endTime, gradient, this.getMaxSplitSize()).stream().map(pair -> Pair.create((Object)DateUtil.format((LocalDateTime)((LocalDateTime)pair.first()), (String)"yyyy-MM-dd HH:mm:ss"), (Object)DateUtil.format((LocalDateTime)((LocalDateTime)pair.first()), (String)"yyyy-MM-dd HH:mm:ss"))).collect(Collectors.toUnmodifiableList());
    }
}

