/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.plugin.service.convert;

import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.carp.module.plugin.plugin.update.PluginRelease;
import cn.sliew.carp.module.plugin.plugin.update.RemotePluginInfo;
import cn.sliew.carp.module.plugin.repository.entity.CarpPluginInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

@Mapper
public interface CarpPluginRepositoryInfoConvert
extends BaseConvert<CarpPluginInfo, RemotePluginInfo> {
    public static final CarpPluginRepositoryInfoConvert INSTANCE = (CarpPluginRepositoryInfoConvert)Mappers.getMapper(CarpPluginRepositoryInfoConvert.class);

    default public RemotePluginInfo toDto(CarpPluginInfo carpPluginInfo) {
        RemotePluginInfo remotePluginInfo = new RemotePluginInfo();
        remotePluginInfo.setId(carpPluginInfo.getName());
        remotePluginInfo.setName(carpPluginInfo.getName());
        remotePluginInfo.setProvider(carpPluginInfo.getProvider());
        remotePluginInfo.setRemark(carpPluginInfo.getRemark());
        if (CollectionUtils.isNotEmpty(carpPluginInfo.getReleases())) {
            List<PluginRelease> releases = carpPluginInfo.getReleases().stream().map(carpPluginRelease -> {
                PluginRelease release = new PluginRelease();
                release.setVersion(carpPluginRelease.getVersion());
                release.setUrl(carpPluginRelease.getUrl());
                release.setDate(carpPluginRelease.getCreateTime());
                return release;
            }).collect(Collectors.toList());
            remotePluginInfo.setReleases(releases);
        }
        return remotePluginInfo;
    }
}

