/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.util.reflection.autobox;

import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import cn.sliew.carp.framework.common.util.reflection.autobox.TypeAutoboxer;
import cn.sliew.milky.common.exception.Rethrower;
import java.sql.Clob;
import java.sql.SQLException;

public class StringTypeAutoboxer
implements TypeAutoboxer<String> {
    @Override
    public boolean supports(Class<?> type) {
        return String.class.equals(type);
    }

    @Override
    public String autobox(Object value, Class<String> type) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Clob) {
            try {
                Clob clob = (Clob)value;
                return (String)ReflectionUtils.cast(clob.getSubString(1L, (int)clob.length()));
            }
            catch (SQLException e) {
                Rethrower.throwAs((Throwable)e);
                return null;
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), String.class.getName()));
    }
}

