/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.reflection;

import cn.sliew.carp.framework.common.reflection.JobDetails;
import cn.sliew.carp.framework.common.reflection.JobDetailsAsmGenerator;
import cn.sliew.carp.framework.common.reflection.JobDetailsGenerator;
import cn.sliew.carp.framework.common.reflection.JobParameter;
import cn.sliew.carp.framework.common.reflection.lambdas.IocJobLambda;
import cn.sliew.carp.framework.common.reflection.lambdas.JobLambda;
import cn.sliew.carp.framework.common.reflection.lambdas.JobRunrJob;
import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import cn.sliew.milky.common.exception.Rethrower;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CachingJobDetailsGenerator
implements JobDetailsGenerator {
    private final JobDetailsGenerator delegate;
    private final Map<Class<?>, CacheableJobDetails> cache;

    public CachingJobDetailsGenerator() {
        this(new JobDetailsAsmGenerator());
    }

    public CachingJobDetailsGenerator(JobDetailsGenerator delegate) {
        this.delegate = delegate;
        this.cache = new ConcurrentHashMap();
    }

    @Override
    public JobDetails toJobDetails(JobLambda lambda) {
        return this.cache.computeIfAbsent(lambda.getClass(), clazz -> new CacheableJobDetails(this.delegate)).getJobDetails(lambda);
    }

    @Override
    public JobDetails toJobDetails(IocJobLambda<?> lambda) {
        return this.cache.computeIfAbsent(lambda.getClass(), clazz -> new CacheableJobDetails(this.delegate)).getJobDetails(lambda);
    }

    private static class CacheableJobDetails {
        private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
        private final JobDetailsGenerator jobDetailsGeneratorDelegate;
        private volatile JobDetails jobDetails;
        private List<JobParameterRetriever> jobParameterRetrievers;

        private CacheableJobDetails(JobDetailsGenerator jobDetailsGeneratorDelegate) {
            this.jobDetailsGeneratorDelegate = jobDetailsGeneratorDelegate;
        }

        public JobDetails getJobDetails(JobLambda lambda) {
            return this.initOrGetJobDetails(() -> this.jobDetailsGeneratorDelegate.toJobDetails(lambda), () -> CacheableJobDetails.initJobParameterRetrievers(this.jobDetails, lambda, Optional.empty()), () -> this.getCachedJobDetails(lambda, Optional.empty()));
        }

        public JobDetails getJobDetails(IocJobLambda<?> lambda) {
            return this.initOrGetJobDetails(() -> this.jobDetailsGeneratorDelegate.toJobDetails(lambda), () -> CacheableJobDetails.initJobParameterRetrievers(this.jobDetails, lambda, Optional.empty()), () -> this.getCachedJobDetails(lambda, Optional.empty()));
        }

        private JobDetails initOrGetJobDetails(Supplier<JobDetails> jobDetailsSupplier, Supplier<List<JobParameterRetriever>> jobParameterRetrieverSupplier, Supplier<JobDetails> getJobDetailsUsingCache) {
            JobDetails jobDetails;
            if (this.jobDetails == null && (jobDetails = this.initJobDetails(jobDetailsSupplier, jobParameterRetrieverSupplier)) != null) {
                return jobDetails;
            }
            if (Boolean.TRUE.equals(this.jobDetails.getCacheable())) {
                return getJobDetailsUsingCache.get();
            }
            return jobDetailsSupplier.get();
        }

        private synchronized JobDetails initJobDetails(Supplier<JobDetails> jobDetailsSupplier, Supplier<List<JobParameterRetriever>> jobParameterRetrieverSupplier) {
            if (this.jobDetails == null) {
                this.jobDetails = jobDetailsSupplier.get();
                this.jobParameterRetrievers = jobParameterRetrieverSupplier.get();
                return this.jobDetails;
            }
            return null;
        }

        private static <T> List<JobParameterRetriever> initJobParameterRetrievers(JobDetails jobDetails, JobRunrJob jobRunrJob, Optional<T> itemFromStream) {
            try {
                ArrayList<JobParameterRetriever> parameterRetrievers = new ArrayList<JobParameterRetriever>();
                ArrayList<Field> declaredFields = new ArrayList<Field>(Arrays.asList(jobRunrJob.getClass().getDeclaredFields()));
                List<JobParameter> jobParameters = jobDetails.getJobParameters();
                if (CacheableJobDetails.isParentClassPassedAsFieldToPassJobDetailsClass(declaredFields, jobDetails) || CacheableJobDetails.isClassPassedAsFieldToPassJobDetailsClass(declaredFields, jobDetails)) {
                    declaredFields.remove(0);
                }
                for (JobParameter jp : jobParameters) {
                    parameterRetrievers.add(CacheableJobDetails.createJobParameterRetriever(jp, jobRunrJob, itemFromStream, declaredFields));
                }
                jobDetails.setCacheable(declaredFields.isEmpty() && jobParameters.size() == parameterRetrievers.size() && (!itemFromStream.isPresent() || parameterRetrievers.stream().anyMatch(r -> r instanceof ItemFromStreamJobParameterRetriever)));
                return parameterRetrievers;
            }
            catch (Exception e) {
                jobDetails.setCacheable(false);
                return Collections.emptyList();
            }
        }

        private static boolean isParentClassPassedAsFieldToPassJobDetailsClass(List<Field> declaredFields, JobDetails jobDetails) {
            if (declaredFields.isEmpty()) {
                return false;
            }
            Class jobDetailsClass = ReflectionUtils.toClass(jobDetails.getClassName());
            return Arrays.stream(declaredFields.get(0).getType().getDeclaredFields()).map(Field::getType).anyMatch(x -> x.isAssignableFrom(jobDetailsClass));
        }

        private static boolean isClassPassedAsFieldToPassJobDetailsClass(List<Field> declaredFields, JobDetails jobDetails) {
            if (declaredFields.isEmpty()) {
                return false;
            }
            return declaredFields.get(0).getType().getName().equals(jobDetails.getClassName());
        }

        private static <T> JobParameterRetriever createJobParameterRetriever(JobParameter jp, JobRunrJob jobRunrJob, Optional<T> itemFromStream, List<Field> declaredFields) throws IllegalAccessException {
            JobParameterRetriever jobParameterRetriever = new FixedJobParameterRetriever(jp);
            if (itemFromStream.isPresent() && jp.getObject().equals(itemFromStream.get())) {
                jobParameterRetriever = new ItemFromStreamJobParameterRetriever(jp);
            } else {
                ListIterator<Field> fieldIterator = declaredFields.listIterator();
                while (fieldIterator.hasNext()) {
                    Field f = fieldIterator.next();
                    Object valueFromField = ReflectionUtils.getValueFromField(f, jobRunrJob);
                    if (!jp.getObject().equals(valueFromField)) continue;
                    MethodHandle e = lookup.unreflectGetter(f);
                    jobParameterRetriever = new MethodHandleJobParameterRetriever(jp, e.asType(e.type().generic()));
                    fieldIterator.remove();
                    break;
                }
            }
            return jobParameterRetriever;
        }

        private <T> JobDetails getCachedJobDetails(JobRunrJob job, Optional<T> itemFromStream) {
            JobDetails cachedJobDetails = new JobDetails(this.jobDetails.getClassName(), this.jobDetails.getStaticFieldName(), this.jobDetails.getMethodName(), this.jobParameterRetrievers.stream().map(jobParameterRetriever -> jobParameterRetriever.getJobParameter(job, itemFromStream)).collect(Collectors.toList()));
            cachedJobDetails.setCacheable(true);
            return cachedJobDetails;
        }
    }

    private static class ItemFromStreamJobParameterRetriever
    implements JobParameterRetriever {
        private final String jobParameterClassName;

        public ItemFromStreamJobParameterRetriever(JobParameter jobParameter) {
            this.jobParameterClassName = jobParameter.getClassName();
        }

        @Override
        public <T> JobParameter getJobParameter(JobRunrJob job, Optional<T> itemFromStream) {
            return new JobParameter(this.jobParameterClassName, itemFromStream.orElseThrow(() -> new IllegalStateException("Can not find itemFromStream")));
        }
    }

    private static class MethodHandleJobParameterRetriever
    implements JobParameterRetriever {
        private final String jobParameterClassName;
        private final MethodHandle methodHandle;

        public MethodHandleJobParameterRetriever(JobParameter jobParameter, MethodHandle methodHandle) {
            this.jobParameterClassName = jobParameter.getClassName();
            this.methodHandle = methodHandle;
        }

        @Override
        public <T> JobParameter getJobParameter(JobRunrJob job, Optional<T> itemFromStream) {
            try {
                Object o = this.methodHandle.invokeExact(job);
                return new JobParameter(this.jobParameterClassName, o);
            }
            catch (Throwable throwable) {
                Rethrower.throwAs((Throwable)throwable);
                return null;
            }
        }
    }

    private static class FixedJobParameterRetriever
    implements JobParameterRetriever {
        private final JobParameter jobParameter;

        public FixedJobParameterRetriever(JobParameter jobParameter) {
            this.jobParameter = jobParameter;
        }

        @Override
        public <T> JobParameter getJobParameter(JobRunrJob job, Optional<T> itemFromStream) {
            return this.jobParameter;
        }
    }

    private static interface JobParameterRetriever {
        public <T> JobParameter getJobParameter(JobRunrJob var1, Optional<T> var2);
    }
}

