/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.jackson.sensitive;

import java.util.Arrays;
import java.util.function.Function;
import lombok.Generated;

public enum DesensitizationType {
    USERNAME("Username", s -> s.replaceAll("(\\S)\\S(\\S*)", "$1*$2")),
    ID_CARD("IdCard", s -> s.replaceAll("(\\d{4})\\d{10}(\\w{4})", "$1****$2")),
    PHONE("Phone", s -> s.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2")),
    ADDRESS("Address", s -> s.replaceAll("(\\S{3})\\S{2}(\\S*)\\S{2}", "$1****$2****"));

    private final String name;
    private final Function<String, String> desensitizer;

    public static DesensitizationType of(String name) {
        return Arrays.stream(DesensitizationType.values()).filter(instance -> instance.getName().equals(name)).findAny().orElseThrow(() -> new EnumConstantNotPresentException(DesensitizationType.class, name));
    }

    private DesensitizationType(String name, Function<String, String> desensitizer) {
        this.name = name;
        this.desensitizer = desensitizer;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Function<String, String> getDesensitizer() {
        return this.desensitizer;
    }
}

