/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.jackson.polymorphic;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

public abstract class PolymorphicResolver<T>
extends TypeIdResolverBase {
    protected final BiMap<T, Class<?>> subTypes = HashBiMap.create();
    protected JavaType superType;
    protected Class<?> defaultClass;

    protected void bind(T type, Class<?> subClass) {
        this.subTypes.put(type, subClass);
    }

    protected void bindDefault(Class<?> defaultClass) {
        this.defaultClass = defaultClass;
    }

    public void init(JavaType baseType) {
        this.superType = baseType;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public String idFromValue(Object obj) {
        return this.typeFromSubtype(obj);
    }

    public String idFromValueAndType(Object obj, Class<?> subType) {
        return this.typeFromSubtype(obj);
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        Class<?> subType = this.subTypeFromType(id);
        return context.constructSpecializedType(this.superType, subType);
    }

    protected abstract String typeFromSubtype(Object var1);

    protected abstract Class<?> subTypeFromType(String var1);
}

