/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.jackson.polymorphic;

import cn.sliew.carp.framework.common.jackson.polymorphic.ExtensionRegistry;
import cn.sliew.milky.common.util.JacksonUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultExtensionRegistry
implements ExtensionRegistry {
    public static final ExtensionRegistry INSTANCE = new DefaultExtensionRegistry(Collections.singletonList(JacksonUtil.getMapper()));
    private List<ObjectMapper> mappers = new ArrayList<ObjectMapper>();
    private Table<Class, String, Class> table = HashBasedTable.create();

    public DefaultExtensionRegistry(List<ObjectMapper> mappers) {
        this.mappers = mappers;
    }

    @Override
    public <Base> void register(Class<Base> baseType, Class<? extends Base> extensionType, String discriminator) {
        Map map = this.table.row(baseType);
        map.put(discriminator, extensionType);
        for (ObjectMapper mapper : this.mappers) {
            mapper.registerSubtypes(new NamedType[]{new NamedType(extensionType, discriminator)});
        }
    }

    @Override
    public Map<String, Class> extensionsOf(Class baseType) {
        return this.table.row((Object)baseType);
    }

    @Override
    public Collection<Class> baseTypes() {
        return this.table.rowKeySet();
    }
}

