/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.enums;

import cn.hutool.core.util.StrUtil;
import lombok.Generated;

public enum ContentTypeEnum {
    DEFAULT("default", "application/octet-stream"),
    JPG("jpg", "image/jpeg"),
    TIFF("tiff", "image/tiff"),
    GIF("gif", "image/gif"),
    JFIF("jfif", "image/jpeg"),
    PNG("png", "image/png"),
    TIF("tif", "image/tiff"),
    ICO("ico", "image/x-icon"),
    JPEG("jpeg", "image/jpeg"),
    WBMP("wbmp", "image/vnd.wap.wbmp"),
    FAX("fax", "image/fax"),
    NET("net", "image/pnetvue"),
    JPE("jpe", "image/jpeg"),
    RP("rp", "image/vnd.rn-realpix");

    private String prefix;
    private String type;

    private ContentTypeEnum(String prefix, String type) {
        this.prefix = prefix;
        this.type = type;
    }

    public static String getContentType(String prefix) {
        if (StrUtil.isEmpty((CharSequence)prefix)) {
            return DEFAULT.getType();
        }
        prefix = prefix.substring(prefix.lastIndexOf(".") + 1);
        for (ContentTypeEnum value : ContentTypeEnum.values()) {
            if (!prefix.equalsIgnoreCase(value.getPrefix())) continue;
            return value.getType();
        }
        return DEFAULT.getType();
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public String getType() {
        return this.type;
    }
}

