/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.aot;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.cloud.openfeign.FeignClientFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.aot.ApplicationContextAotGenerator;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.javapoet.ClassName;
import org.springframework.util.Assert;

public class FeignChildContextInitializer
implements BeanRegistrationAotProcessor {
    private final ApplicationContext applicationContext;
    private final FeignClientFactory feignClientFactory;

    public FeignChildContextInitializer(ApplicationContext applicationContext, FeignClientFactory feignClientFactory) {
        this.applicationContext = applicationContext;
        this.feignClientFactory = feignClientFactory;
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)this.applicationContext);
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)this.applicationContext;
        ConfigurableListableBeanFactory applicationBeanFactory = context.getBeanFactory();
        if (!registeredBean.getBeanClass().equals(FeignClientFactory.class) || !registeredBean.getBeanFactory().equals(applicationBeanFactory)) {
            return null;
        }
        HashSet<String> contextIds = new HashSet<String>(this.getContextIdsFromConfig());
        Map<String, GenericApplicationContext> childContextAotContributions = contextIds.stream().map(contextId -> Map.entry(contextId, this.buildChildContext((String)contextId))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new AotContribution(childContextAotContributions);
    }

    private GenericApplicationContext buildChildContext(String contextId) {
        GenericApplicationContext childContext = this.feignClientFactory.buildContext(contextId);
        this.feignClientFactory.registerBeans(contextId, childContext);
        return childContext;
    }

    private Collection<String> getContextIdsFromConfig() {
        Map configurations = this.feignClientFactory.getConfigurations();
        return configurations.keySet().stream().filter(key -> !key.startsWith("default.")).collect(Collectors.toSet());
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private final Map<String, GenericApplicationContext> childContexts;

        AotContribution(Map<String, GenericApplicationContext> childContexts) {
            this.childContexts = childContexts.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> Map.entry((String)entry.getKey(), (GenericApplicationContext)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            Map<String, ClassName> generatedInitializerClassNames = this.childContexts.entrySet().stream().map(entry -> {
                String name = ((GenericApplicationContext)entry.getValue()).getDisplayName();
                name = name.replaceAll("[-]", "_");
                GenerationContext childGenerationContext = generationContext.withName(name);
                ClassName initializerClassName = new ApplicationContextAotGenerator().processAheadOfTime((GenericApplicationContext)entry.getValue(), childGenerationContext);
                return Map.entry((String)entry.getKey(), initializerClassName);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            GeneratedMethod postProcessorMethod = beanRegistrationCode.getMethods().add("addFeignChildContextInitializer", method -> {
                method.addJavadoc("Use AOT child context management initialization", new Object[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(RegisteredBean.class, "registeredBean", new Modifier[0]).addParameter(FeignClientFactory.class, "instance", new Modifier[0]).returns(FeignClientFactory.class).addStatement("$T<String, Object> initializers = new $T<>()", new Object[]{Map.class, HashMap.class});
                generatedInitializerClassNames.keySet().forEach(contextId -> method.addStatement("initializers.put($S, new $L())", new Object[]{contextId, generatedInitializerClassNames.get(contextId)}));
                method.addStatement("return instance.withApplicationContextInitializers(initializers)", new Object[0]);
            });
            beanRegistrationCode.addInstancePostProcessor(postProcessorMethod.toMethodReference());
        }
    }
}

