/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import java.io.Serializable;
import java.time.Duration;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.NotInfluenceReceiveTimeout;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.ActorContextImpl;
import org.apache.pekko.actor.typed.internal.BehaviorImpl;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$DeferredBehavior$;
import org.apache.pekko.actor.typed.internal.TimerSchedulerCrossDslSupport;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$SingleMode$;
import org.apache.pekko.actor.typed.javadsl.TimerScheduler;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.package$LoggerOps$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.util.LineNumbers$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011\rt\u0001C?\u007f\u0011\u0003\tI!!\u0006\u0007\u0013\u0005ea\u0010#\u0001\u0002\n\u0005m\u0001bBA\u0015\u0003\u0011\u0005\u0011Q\u0006\u0004\u0007\u0003_\t!)!\r\t\u0015\u0005\u00053A!f\u0001\n\u0003\t\u0019\u0005\u0003\u0006\u0002L\r\u0011\t\u0012)A\u0005\u0003\u000bB!\"!\u0014\u0004\u0005+\u0007I\u0011AA(\u0011)\t\tg\u0001B\tB\u0003%\u0011\u0011\u000b\u0005\u000b\u0003G\u001a!Q3A\u0005\u0002\u0005\u0015\u0004BCA7\u0007\tE\t\u0015!\u0003\u0002h!Q\u0011qN\u0002\u0003\u0016\u0004%\t!!\u001d\t\u0015\u0005e4A!E!\u0002\u0013\t\u0019\b\u0003\u0006\u0002|\r\u0011)\u001a!C\u0001\u0003{B!\"a\"\u0004\u0005#\u0005\u000b\u0011BA@\u0011\u001d\tIc\u0001C\u0001\u0003\u0013C\u0011\"!'\u0004\u0003\u0003%\t!a'\t\u0013\u0005=6!%A\u0005\u0002\u0005E\u0006\"CAf\u0007E\u0005I\u0011AAg\u0011%\t)nAI\u0001\n\u0003\t9\u000eC\u0005\u0002`\u000e\t\n\u0011\"\u0001\u0002b\"I\u0011\u0011^\u0002\u0012\u0002\u0013\u0005\u00111\u001e\u0005\n\u0003g\u001c\u0011\u0011!C!\u0003kD\u0011Ba\u0002\u0004\u0003\u0003%\t!!\u001d\t\u0013\t%1!!A\u0005\u0002\t-\u0001\"\u0003B\t\u0007\u0005\u0005I\u0011\tB\n\u0011%\u0011\tcAA\u0001\n\u0003\u0011\u0019\u0003C\u0005\u0003(\r\t\t\u0011\"\u0011\u0003*!I!1F\u0002\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005_\u0019\u0011\u0011!C!\u0005c9\u0011B!\u000e\u0002\u0003\u0003E\tAa\u000e\u0007\u0013\u0005=\u0012!!A\t\u0002\te\u0002bBA\u0015=\u0011\u0005!1\b\u0005\n\u0005Wq\u0012\u0011!C#\u0005[A\u0011B!\u0010\u001f\u0003\u0003%\tIa\u0010\t\u0013\tMc$!A\u0005\u0002\nU\u0003\"\u0003B8=\u0005\u0005I\u0011\u0002B9\r\u0019\u0011I(\u0001\t\u0003|!Q\u0011\u0011\t\u0013\u0003\u0006\u0004%\t!a\u0011\t\u0015\u0005-CE!A!\u0002\u0013\t)\u0005\u0003\u0006\u0002p\u0011\u0012)\u0019!C\u0001\u0003cB!\"!\u001f%\u0005\u0003\u0005\u000b\u0011BA:\u0011)\u0011i\b\nBC\u0002\u0013\u0005!q\u0010\u0005\u000b\u0005\u0003##\u0011!Q\u0001\n\u0005u\u0001bBA\u0015I\u0011\u0005!1\u0011\u0005\b\u0005W!C\u0011\tBG\u0011\u001d\u0011Y+\u0001C\u0001\u0005[CqA!4\u0002\t\u0003\u0011yMB\u0005\u0003r\u0006\u0001\n1%\u000b\u0003t\"9\u00111M\u0018\u0007\u0002\u0005\u0015dABB\u0017\u0003\u0011\u001by\u0003\u0003\u0006\u0003~F\u0012)\u001a!C\u0001\u0005\u007fD!b!\u00052\u0005#\u0005\u000b\u0011BB\u0001\u0011\u001d\tI#\rC\u0001\u0007cAq!a\u00192\t\u0003\n)\u0007C\u0005\u0002\u001aF\n\t\u0011\"\u0001\u00048!I\u0011qV\u0019\u0012\u0002\u0013\u00051Q\u0004\u0005\n\u0003g\f\u0014\u0011!C!\u0003kD\u0011Ba\u00022\u0003\u0003%\t!!\u001d\t\u0013\t%\u0011'!A\u0005\u0002\rm\u0002\"\u0003B\tc\u0005\u0005I\u0011\tB\n\u0011%\u0011\t#MA\u0001\n\u0003\u0019y\u0004C\u0005\u0003(E\n\t\u0011\"\u0011\u0003*!I!1F\u0019\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005_\t\u0014\u0011!C!\u0007\u0007:\u0011ba\u0016\u0002\u0003\u0003EIa!\u0017\u0007\u0013\r5\u0012!!A\t\n\rm\u0003bBA\u0015\u0003\u0012\u00051\u0011\u000e\u0005\n\u0005W\t\u0015\u0011!C#\u0005[A\u0011B!\u0010B\u0003\u0003%\tia\u001b\t\u0013\tM\u0013)!A\u0005\u0002\u000e=\u0004\"\u0003B8\u0003\u0006\u0005I\u0011\u0002B9\r\u0019\u001190\u0001#\u0003z\"Q!Q`$\u0003\u0016\u0004%\tAa@\t\u0015\rEqI!E!\u0002\u0013\u0019\t\u0001C\u0004\u0002*\u001d#\taa\u0005\t\u000f\u0005\rt\t\"\u0011\u0002f!I\u0011\u0011T$\u0002\u0002\u0013\u00051\u0011\u0004\u0005\n\u0003_;\u0015\u0013!C\u0001\u0007;A\u0011\"a=H\u0003\u0003%\t%!>\t\u0013\t\u001dq)!A\u0005\u0002\u0005E\u0004\"\u0003B\u0005\u000f\u0006\u0005I\u0011AB\u0011\u0011%\u0011\tbRA\u0001\n\u0003\u0012\u0019\u0002C\u0005\u0003\"\u001d\u000b\t\u0011\"\u0001\u0004&!I!qE$\u0002\u0002\u0013\u0005#\u0011\u0006\u0005\n\u0005W9\u0015\u0011!C!\u0005[A\u0011Ba\fH\u0003\u0003%\te!\u000b\b\u0013\rU\u0014!!A\t\n\r]d!\u0003B|\u0003\u0005\u0005\t\u0012BB=\u0011\u001d\tIc\u0016C\u0001\u0007{B\u0011Ba\u000bX\u0003\u0003%)E!\f\t\u0013\tur+!A\u0005\u0002\u000e}\u0004\"\u0003B*/\u0006\u0005I\u0011QBB\u0011%\u0011ygVA\u0001\n\u0013\u0011\thB\u0004\u0004\b\u0006AIi!\u0014\u0007\u000f\r\u001d\u0013\u0001##\u0004J!9\u0011\u0011\u00060\u0005\u0002\r-\u0003bBA2=\u0012\u0005\u0013Q\r\u0005\n\u0003gt\u0016\u0011!C!\u0003kD\u0011Ba\u0002_\u0003\u0003%\t!!\u001d\t\u0013\t%a,!A\u0005\u0002\r=\u0003\"\u0003B\t=\u0006\u0005I\u0011\tB\n\u0011%\u0011\tCXA\u0001\n\u0003\u0019\u0019\u0006C\u0005\u0003(y\u000b\t\u0011\"\u0011\u0003*!I!1\u00060\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005_r\u0016\u0011!C\u0005\u0005c2\u0001\"!\u0007\u007f\u0001\u0005%1q\u0013\u0005\u000b\u0005;L'\u0011!Q\u0001\n\r\u001d\u0006bBA\u0015S\u0012\u00051\u0011\u0016\u0005\n\u0007_K\u0007\u0019!C\u0005\u0007cC\u0011b!0j\u0001\u0004%Iaa0\t\u0011\r%\u0017\u000e)Q\u0005\u0007gC\u0011ba3j\u0005\u0004%Ia!4\t\u0011\rE\u0017\u000e)A\u0005\u0007\u001fDqaa5j\t\u0003\u001a)\u000eC\u0004\u0004T&$\tea8\t\u000f\r%\u0018\u000e\"\u0011\u0004l\"91\u0011^5\u0005B\rU\bbBB\u0000S\u0012\u0005C\u0011\u0001\u0005\b\t\u0013IG\u0011\tC\u0006\u0011\u001d!\u0019\"\u001bC\u0005\t+Aq\u0001b\tj\t\u0003\")\u0003C\u0004\u0005*%$\t\u0005b\u000b\t\u000f\u0011=\u0012\u000e\"\u0003\u00052!9AqG5\u0005B\u0011e\u0002b\u0002C\u001eS\u0012\u0005AQH\u0001\u0013)&lWM]*dQ\u0016$W\u000f\\3s\u00136\u0004HNC\u0002\u0000\u0003\u0003\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0005\u0003\u0007\t)!A\u0003usB,GM\u0003\u0003\u0002\b\u0005%\u0011!B1di>\u0014(\u0002BA\u0006\u0003\u001b\tQ\u0001]3lW>TA!a\u0004\u0002\u0012\u00051\u0011\r]1dQ\u0016T!!a\u0005\u0002\u0007=\u0014x\rE\u0002\u0002\u0018\u0005i\u0011A \u0002\u0013)&lWM]*dQ\u0016$W\u000f\\3s\u00136\u0004HnE\u0002\u0002\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0003\u0003G\tQa]2bY\u0006LA!a\n\u0002\"\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0003\u0003+\u0011Q\u0001V5nKJ,B!a\r\u0002VM91!!\b\u00026\u0005m\u0002\u0003BA\u0010\u0003oIA!!\u000f\u0002\"\t9\u0001K]8ek\u000e$\b\u0003BA\u0010\u0003{IA!a\u0010\u0002\"\ta1+\u001a:jC2L'0\u00192mK\u0006\u00191.Z=\u0016\u0005\u0005\u0015\u0003\u0003BA\u0010\u0003\u000fJA!!\u0013\u0002\"\t\u0019\u0011I\\=\u0002\t-,\u0017\u0010I\u0001\u0004[N<WCAA)!\u0011\t\u0019&!\u0016\r\u0001\u00119\u0011qK\u0002C\u0002\u0005e#!\u0001+\u0012\t\u0005m\u0013Q\t\t\u0005\u0003?\ti&\u0003\u0003\u0002`\u0005\u0005\"a\u0002(pi\"LgnZ\u0001\u0005[N<\u0007%\u0001\u0004sKB,\u0017\r^\u000b\u0003\u0003O\u0002B!a\b\u0002j%!\u00111NA\u0011\u0005\u001d\u0011un\u001c7fC:\fqA]3qK\u0006$\b%\u0001\u0006hK:,'/\u0019;j_:,\"!a\u001d\u0011\t\u0005}\u0011QO\u0005\u0005\u0003o\n\tCA\u0002J]R\f1bZ3oKJ\fG/[8oA\u0005!A/Y:l+\t\ty\b\u0005\u0003\u0002\u0002\u0006\rUBAA\u0003\u0013\u0011\t))!\u0002\u0003\u0017\r\u000bgnY3mY\u0006\u0014G.Z\u0001\u0006i\u0006\u001c8\u000e\t\u000b\r\u0003\u0017\u000by)!%\u0002\u0014\u0006U\u0015q\u0013\t\u0006\u0003\u001b\u001b\u0011\u0011K\u0007\u0002\u0003!9\u0011\u0011\t\bA\u0002\u0005\u0015\u0003bBA'\u001d\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003Gr\u0001\u0019AA4\u0011\u001d\tyG\u0004a\u0001\u0003gBq!a\u001f\u000f\u0001\u0004\ty(\u0001\u0003d_BLX\u0003BAO\u0003G#B\"a(\u0002&\u0006\u001d\u0016\u0011VAV\u0003[\u0003R!!$\u0004\u0003C\u0003B!a\u0015\u0002$\u00129\u0011qK\bC\u0002\u0005e\u0003\"CA!\u001fA\u0005\t\u0019AA#\u0011%\tie\u0004I\u0001\u0002\u0004\t\t\u000bC\u0005\u0002d=\u0001\n\u00111\u0001\u0002h!I\u0011qN\b\u0011\u0002\u0003\u0007\u00111\u000f\u0005\n\u0003wz\u0001\u0013!a\u0001\u0003\u007f\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u00024\u0006%WCAA[U\u0011\t)%a.,\u0005\u0005e\u0006\u0003BA^\u0003\u000bl!!!0\u000b\t\u0005}\u0016\u0011Y\u0001\nk:\u001c\u0007.Z2lK\u0012TA!a1\u0002\"\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0017Q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GaBA,!\t\u0007\u0011\u0011L\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\ty-a5\u0016\u0005\u0005E'\u0006BA)\u0003o#q!a\u0016\u0012\u0005\u0004\tI&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005e\u0017Q\\\u000b\u0003\u00037TC!a\u001a\u00028\u00129\u0011q\u000b\nC\u0002\u0005e\u0013AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0005\u0003G\f9/\u0006\u0002\u0002f*\"\u00111OA\\\t\u001d\t9f\u0005b\u0001\u00033\nabY8qs\u0012\"WMZ1vYR$S'\u0006\u0003\u0002n\u0006EXCAAxU\u0011\ty(a.\u0005\u000f\u0005]CC1\u0001\u0002Z\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a>\u0011\t\u0005e(1A\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006!A.\u00198h\u0015\t\u0011\t!\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0003\u0003w\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000b\u0012i\u0001C\u0005\u0003\u0010]\t\t\u00111\u0001\u0002t\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0006\u0011\r\t]!QDA#\u001b\t\u0011IB\u0003\u0003\u0003\u001c\u0005\u0005\u0012AC2pY2,7\r^5p]&!!q\u0004B\r\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001d$Q\u0005\u0005\n\u0005\u001fI\u0012\u0011!a\u0001\u0003\u000b\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003g\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003o\fa!Z9vC2\u001cH\u0003BA4\u0005gA\u0011Ba\u0004\u001d\u0003\u0003\u0005\r!!\u0012\u0002\u000bQKW.\u001a:\u0011\u0007\u00055edE\u0003\u001f\u0003;\tY\u0004\u0006\u0002\u00038\u0005)\u0011\r\u001d9msV!!\u0011\tB$)1\u0011\u0019E!\u0013\u0003L\t5#q\nB)!\u0015\tii\u0001B#!\u0011\t\u0019Fa\u0012\u0005\u000f\u0005]\u0013E1\u0001\u0002Z!9\u0011\u0011I\u0011A\u0002\u0005\u0015\u0003bBA'C\u0001\u0007!Q\t\u0005\b\u0003G\n\u0003\u0019AA4\u0011\u001d\ty'\ta\u0001\u0003gBq!a\u001f\"\u0001\u0004\ty(A\u0004v]\u0006\u0004\b\u000f\\=\u0016\t\t]#q\r\u000b\u0005\u00053\u0012I\u0007\u0005\u0004\u0002 \tm#qL\u0005\u0005\u0005;\n\tC\u0001\u0004PaRLwN\u001c\t\u000f\u0003?\u0011\t'!\u0012\u0003f\u0005\u001d\u00141OA@\u0013\u0011\u0011\u0019'!\t\u0003\rQ+\b\u000f\\36!\u0011\t\u0019Fa\u001a\u0005\u000f\u0005]#E1\u0001\u0002Z!I!1\u000e\u0012\u0002\u0002\u0003\u0007!QN\u0001\u0004q\u0012\u0002\u0004#BAG\u0007\t\u0015\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u001d\u0011\t\u0005e(QO\u0005\u0005\u0005o\nYP\u0001\u0004PE*,7\r\u001e\u0002\t)&lWM]'tON\u0019A%!\b\u0002\u000b=<h.\u001a:\u0016\u0005\u0005u\u0011AB8x]\u0016\u0014\b\u0005\u0006\u0005\u0003\u0006\n\u001d%\u0011\u0012BF!\r\ti\t\n\u0005\b\u0003\u0003Z\u0003\u0019AA#\u0011\u001d\tyg\u000ba\u0001\u0003gBqA! ,\u0001\u0004\ti\u0002\u0006\u0002\u0003\u0010B!!\u0011\u0013BP\u001d\u0011\u0011\u0019Ja'\u0011\t\tU\u0015\u0011E\u0007\u0003\u0005/SAA!'\u0002,\u00051AH]8pizJAA!(\u0002\"\u00051\u0001K]3eK\u001aLAA!\u0002\u0003\"*!!QTA\u0011S\r!#Q\u0015\u0004\u0007\u0005O#\u0003A!+\u0003\u001bqbwnY1mA\rD\u0017\u000e\u001c3?'\u0011\u0011)K!\"\u0002\u0015]LG\u000f\u001b+j[\u0016\u00148/\u0006\u0003\u00030\nmF\u0003\u0002BY\u0005{\u0003bAa-\u00036\neVBAA\u0001\u0013\u0011\u00119,!\u0001\u0003\u0011\t+\u0007.\u0019<j_J\u0004B!a\u0015\u0003<\u00129\u0011qK\u0017C\u0002\u0005e\u0003b\u0002B`[\u0001\u0007!\u0011Y\u0001\bM\u0006\u001cGo\u001c:z!!\tyBa1\u0003H\nE\u0016\u0002\u0002Bc\u0003C\u0011\u0011BR;oGRLwN\\\u0019\u0011\r\u0005]!\u0011\u001aB]\u0013\r\u0011YM \u0002\u001e)&lWM]*dQ\u0016$W\u000f\\3s\u0007J|7o\u001d#tYN+\b\u000f]8si\u0006qqO]1q/&$\b\u000eV5nKJ\u001cX\u0003\u0002Bi\u00053$BAa5\u0003lR!!Q\u001bBn!\u0019\u0011\u0019L!.\u0003XB!\u00111\u000bBm\t\u001d\t9F\fb\u0001\u00033BqA!8/\u0001\u0004\u0011y.A\u0002dib\u0004bA!9\u0003h\n]WB\u0001Br\u0015\u0011\u0011)/!\u0001\u0002\u0011M\u001c\u0017\r\\1eg2LAA!;\u0003d\na\u0011i\u0019;pe\u000e{g\u000e^3yi\"9!q\u0018\u0018A\u0002\t5\b\u0003CA\u0010\u0005\u0007\u0014yO!6\u0011\r\u0005]!\u0011\u001aBl\u0005%!\u0016.\\3s\u001b>$WmE\u00020\u0003;ICaL$2=\nqa)\u001b=fI\u0012+G.Y=N_\u0012,7#C$\u0002\u001e\tm\u0018QGA\u001e!\r\tiiL\u0001\rS:LG/[1m\t\u0016d\u0017-_\u000b\u0003\u0007\u0003\u0001Baa\u0001\u0004\u000e5\u00111Q\u0001\u0006\u0005\u0007\u000f\u0019I!\u0001\u0005ekJ\fG/[8o\u0015\u0011\u0019Y!!\t\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0004\u0010\r\u0015!A\u0004$j]&$X\rR;sCRLwN\\\u0001\u000eS:LG/[1m\t\u0016d\u0017-\u001f\u0011\u0015\t\rU1q\u0003\t\u0004\u0003\u001b;\u0005b\u0002B\u007f\u0015\u0002\u00071\u0011\u0001\u000b\u0005\u0007+\u0019Y\u0002C\u0005\u0003~2\u0003\n\u00111\u0001\u0004\u0002U\u00111q\u0004\u0016\u0005\u0007\u0003\t9\f\u0006\u0003\u0002F\r\r\u0002\"\u0003B\b!\u0006\u0005\t\u0019AA:)\u0011\t9ga\n\t\u0013\t=!+!AA\u0002\u0005\u0015C\u0003BA4\u0007WA\u0011Ba\u0004V\u0003\u0003\u0005\r!!\u0012\u0003\u001b\u0019K\u00070\u001a3SCR,Wj\u001c3f'%\t\u0014Q\u0004B~\u0003k\tY\u0004\u0006\u0003\u00044\rU\u0002cAAGc!9!Q \u001bA\u0002\r\u0005A\u0003BB\u001a\u0007sA\u0011B!@7!\u0003\u0005\ra!\u0001\u0015\t\u0005\u00153Q\b\u0005\n\u0005\u001fQ\u0014\u0011!a\u0001\u0003g\"B!a\u001a\u0004B!I!q\u0002\u001f\u0002\u0002\u0003\u0007\u0011Q\t\u000b\u0005\u0003O\u001a)\u0005C\u0005\u0003\u0010}\n\t\u00111\u0001\u0002F\tQ1+\u001b8hY\u0016lu\u000eZ3\u0014\u0013y\u000biBa?\u00026\u0005mBCAB'!\r\tiI\u0018\u000b\u0005\u0003\u000b\u001a\t\u0006C\u0005\u0003\u0010\r\f\t\u00111\u0001\u0002tQ!\u0011qMB+\u0011%\u0011y!ZA\u0001\u0002\u0004\t)%A\u0007GSb,GMU1uK6{G-\u001a\t\u0004\u0003\u001b\u000b5#B!\u0004^\u0005m\u0002\u0003CB0\u0007K\u001a\taa\r\u000e\u0005\r\u0005$\u0002BB2\u0003C\tqA];oi&lW-\u0003\u0003\u0004h\r\u0005$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u00111\u0011\f\u000b\u0005\u0007g\u0019i\u0007C\u0004\u0003~\u0012\u0003\ra!\u0001\u0015\t\rE41\u000f\t\u0007\u0003?\u0011Yf!\u0001\t\u0013\t-T)!AA\u0002\rM\u0012A\u0004$jq\u0016$G)\u001a7bs6{G-\u001a\t\u0004\u0003\u001b;6#B,\u0004|\u0005m\u0002\u0003CB0\u0007K\u001a\ta!\u0006\u0015\u0005\r]D\u0003BB\u000b\u0007\u0003CqA!@[\u0001\u0004\u0019\t\u0001\u0006\u0003\u0004r\r\u0015\u0005\"\u0003B67\u0006\u0005\t\u0019AB\u000b\u0003)\u0019\u0016N\\4mK6{G-\u001a\u0015\u0004\u0003\r-\u0005\u0003BBG\u0007#k!aa$\u000b\t\u0005\r\u0017\u0011B\u0005\u0005\u0007'\u001byIA\u0006J]R,'O\\1m\u0003BL\u0007f\u0001\u0001\u0004\fV!1\u0011TBR'\u001dI\u0017QDBN\u0007K\u0003bA!9\u0004\u001e\u000e\u0005\u0016\u0002BBP\u0005G\u0014a\u0002V5nKJ\u001c6\r[3ek2,'\u000f\u0005\u0003\u0002T\r\rFaBA,S\n\u0007\u0011\u0011\f\t\u0007\u0003/\u0011Im!)\u0011\r\t\u0005(q]BQ)\u0011\u0019Yk!,\u0011\u000b\u0005]\u0011n!)\t\u000f\tu7\u000e1\u0001\u0004(\u00061A/[7feN,\"aa-\u0011\u0011\tE5QWA#\u0007sKAaa.\u0003\"\n\u0019Q*\u00199\u0011\u000b\rm6a!)\u000f\u0007\u0005]\u0001!\u0001\u0006uS6,'o]0%KF$Ba!1\u0004HB!\u0011qDBb\u0013\u0011\u0019)-!\t\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005\u001fi\u0017\u0011!a\u0001\u0007g\u000bq\u0001^5nKJ\u001c\b%\u0001\u0005uS6,'oR3o+\t\u0019y\r\u0005\u0004\u0003\u0018\tu\u00111O\u0001\ni&lWM]$f]\u0002\nQc\u001d;beR$\u0016.\\3s\u0003R4\u0015\u000e_3e%\u0006$X\r\u0006\u0005\u0004B\u000e]7\u0011\\Bn\u0011\u001d\t\t%\u001da\u0001\u0003\u000bBq!!\u0014r\u0001\u0004\u0019\t\u000bC\u0004\u0004^F\u0004\ra!\u0001\u0002\u0011%tG/\u001a:wC2$\"b!1\u0004b\u000e\r8Q]Bt\u0011\u001d\t\tE\u001da\u0001\u0003\u000bBq!!\u0014s\u0001\u0004\u0019\t\u000bC\u0004\u0003~J\u0004\ra!\u0001\t\u000f\ru'\u000f1\u0001\u0004\u0002\u0005A2\u000f^1siRKW.\u001a:XSRDg)\u001b=fI\u0012+G.Y=\u0015\u0011\r\u00057Q^Bx\u0007cDq!!\u0011t\u0001\u0004\t)\u0005C\u0004\u0002NM\u0004\ra!)\t\u000f\rM8\u000f1\u0001\u0004\u0002\u0005)A-\u001a7bsRQ1\u0011YB|\u0007s\u001cYp!@\t\u000f\u0005\u0005C\u000f1\u0001\u0002F!9\u0011Q\n;A\u0002\r\u0005\u0006b\u0002B\u007fi\u0002\u00071\u0011\u0001\u0005\b\u0007g$\b\u0019AB\u0001\u0003I\u0019H/\u0019:u!\u0016\u0014\u0018n\u001c3jGRKW.\u001a:\u0015\u0011\r\u0005G1\u0001C\u0003\t\u000fAq!!\u0011v\u0001\u0004\t)\u0005C\u0004\u0002NU\u0004\ra!)\t\u000f\ruW\u000f1\u0001\u0004\u0002\u0005\u00012\u000f^1siNKgn\u001a7f)&lWM\u001d\u000b\t\u0007\u0003$i\u0001b\u0004\u0005\u0012!9\u0011\u0011\t<A\u0002\u0005\u0015\u0003bBA'm\u0002\u00071\u0011\u0015\u0005\b\u0007g4\b\u0019AB\u0001\u0003)\u0019H/\u0019:u)&lWM\u001d\u000b\u000b\u0007\u0003$9\u0002\"\u0007\u0005\u001c\u0011u\u0001bBA!o\u0002\u0007\u0011Q\t\u0005\b\u0003\u001b:\b\u0019ABQ\u0011\u001d\u0019\u0019p\u001ea\u0001\u0007\u0003Aq\u0001b\bx\u0001\u0004!\t#\u0001\u0003n_\u0012,\u0007cAB^_\u0005i\u0011n\u001d+j[\u0016\u0014\u0018i\u0019;jm\u0016$B!a\u001a\u0005(!9\u0011\u0011\t=A\u0002\u0005\u0015\u0013AB2b]\u000e,G\u000e\u0006\u0003\u0004B\u00125\u0002bBA!s\u0002\u0007\u0011QI\u0001\fG\u0006t7-\u001a7US6,'\u000f\u0006\u0003\u0004B\u0012M\u0002b\u0002C\u001bu\u0002\u00071\u0011X\u0001\u0006i&lWM]\u0001\nG\u0006t7-\u001a7BY2$\"a!1\u0002#%tG/\u001a:dKB$H+[7fe6\u001bx\r\u0006\u0004\u0005@\u0011-C1\f\t\u0007\t\u0003\"9e!)\u000e\u0005\u0011\r#\u0002\u0002C#\u0003\u0013\tA!\u001e;jY&!A\u0011\nC\"\u0005%y\u0005\u000f^5p]Z\u000bG\u000eC\u0004\u0005Nq\u0004\r\u0001b\u0014\u0002\u00071|w\r\u0005\u0003\u0005R\u0011]SB\u0001C*\u0015\u0011!)&!\u0005\u0002\u000bMdg\r\u000e6\n\t\u0011eC1\u000b\u0002\u0007\u0019><w-\u001a:\t\u000f\u0011uC\u00101\u0001\u0005`\u0005AA/[7fe6\u001bx\rE\u0002\u0004<\u0012B3![BF\u0001")
@InternalApi
public class TimerSchedulerImpl<T>
implements TimerSchedulerCrossDslSupport<T> {
    private final ActorContext<T> ctx;
    private Map<Object, Timer<T>> timers;
    private final Iterator<Object> timerGen;

    public static <T> Behavior<T> wrapWithTimers(Function1<TimerSchedulerCrossDslSupport<T>, Behavior<T>> function1, ActorContext<T> actorContext) {
        if (TimerSchedulerImpl$.MODULE$ == null) {
            throw null;
        }
        if (actorContext instanceof ActorContextImpl) {
            TimerSchedulerCrossDslSupport wrapWithTimers_timerScheduler = ((ActorContextImpl)actorContext).timer();
            return (Behavior)function1.apply(wrapWithTimers_timerScheduler);
        }
        throw new IllegalArgumentException(new StringBuilder(28).append("timers not supported with [").append(actorContext.getClass()).append("]").toString());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Behavior<T> withTimers(Function1<TimerSchedulerCrossDslSupport<T>, Behavior<T>> function1) {
        void withTimers_setup_factory;
        if (TimerSchedulerImpl$.MODULE$ == null) {
            throw null;
        }
        Function1 & Serializable & scala.Serializable intersect = arg_0 -> TimerSchedulerImpl$.$anonfun$withTimers$1(function1, arg_0);
        if (Behaviors$.MODULE$ == null) {
            throw null;
        }
        if (BehaviorImpl$DeferredBehavior$.MODULE$ == null) {
            throw null;
        }
        return new BehaviorImpl.DeferredBehavior<T>((Function1)withTimers_setup_factory){
            private final Function1 factory$1;

            public Behavior<T> apply(TypedActorContext<T> ctx) {
                return (Behavior)this.factory$1.apply(ctx.asScala());
            }

            public String toString() {
                return new StringBuilder(10).append("Deferred(").append(LineNumbers$.MODULE$.apply((Object)this.factory$1)).append(")").toString();
            }
            {
                this.factory$1 = factory$1;
            }
        };
    }

    @Override
    public final void startTimerWithFixedDelay(Object key, T msg, Duration delay) {
        TimerSchedulerCrossDslSupport.startTimerWithFixedDelay$(this, key, msg, delay);
    }

    @Override
    public final void startTimerWithFixedDelay(Object key, T msg, Duration initialDelay, Duration delay) {
        TimerSchedulerCrossDslSupport.startTimerWithFixedDelay$(this, key, msg, initialDelay, delay);
    }

    @Override
    public final void startTimerAtFixedRate(Object key, T msg, Duration interval) {
        TimerSchedulerCrossDslSupport.startTimerAtFixedRate$(this, key, msg, interval);
    }

    @Override
    public final void startTimerAtFixedRate(Object key, T msg, Duration initialDelay, Duration interval) {
        TimerSchedulerCrossDslSupport.startTimerAtFixedRate$(this, key, msg, initialDelay, interval);
    }

    @Override
    public final void startPeriodicTimer(Object key, T msg, Duration interval) {
        TimerSchedulerCrossDslSupport.startPeriodicTimer$(this, key, msg, interval);
    }

    @Override
    public final void startSingleTimer(Object key, T msg, Duration delay) {
        TimerSchedulerCrossDslSupport.startSingleTimer$(this, key, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, Duration delay) {
        TimerScheduler.startTimerWithFixedDelay$(this, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, Duration initialDelay, Duration delay) {
        TimerScheduler.startTimerWithFixedDelay$(this, msg, initialDelay, delay);
    }

    @Override
    public void startTimerAtFixedRate(T msg, Duration interval) {
        TimerScheduler.startTimerAtFixedRate$(this, msg, interval);
    }

    @Override
    public void startTimerAtFixedRate(T msg, Duration initialDelay, Duration interval) {
        TimerScheduler.startTimerAtFixedRate$(this, msg, initialDelay, interval);
    }

    @Override
    public void startSingleTimer(T msg, Duration delay) {
        TimerScheduler.startSingleTimer$(this, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, FiniteDuration delay) {
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.startTimerWithFixedDelay$(this, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, FiniteDuration initialDelay, FiniteDuration delay) {
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.startTimerWithFixedDelay$(this, msg, initialDelay, delay);
    }

    @Override
    public void startTimerAtFixedRate(T msg, FiniteDuration interval) {
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.startTimerAtFixedRate$(this, msg, interval);
    }

    @Override
    public void startTimerAtFixedRate(T msg, FiniteDuration initialDelay, FiniteDuration interval) {
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.startTimerAtFixedRate$(this, msg, initialDelay, interval);
    }

    @Override
    public void startSingleTimer(T msg, FiniteDuration delay) {
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.startSingleTimer$(this, msg, delay);
    }

    private Map<Object, Timer<T>> timers() {
        return this.timers;
    }

    private void timers_$eq(Map<Object, Timer<T>> x$1) {
        this.timers = x$1;
    }

    private Iterator<Object> timerGen() {
        return this.timerGen;
    }

    @Override
    public void startTimerAtFixedRate(Object key, T msg, FiniteDuration interval) {
        this.startTimer(key, msg, interval, new FixedRateMode(interval));
    }

    @Override
    public void startTimerAtFixedRate(Object key, T msg, FiniteDuration initialDelay, FiniteDuration interval) {
        this.startTimer(key, msg, interval, new FixedRateMode(initialDelay));
    }

    @Override
    public void startTimerWithFixedDelay(Object key, T msg, FiniteDuration delay) {
        this.startTimer(key, msg, delay, new FixedDelayMode(delay));
    }

    @Override
    public void startTimerWithFixedDelay(Object key, T msg, FiniteDuration initialDelay, FiniteDuration delay) {
        this.startTimer(key, msg, delay, new FixedDelayMode(initialDelay));
    }

    @Override
    public void startPeriodicTimer(Object key, T msg, FiniteDuration interval) {
        this.startTimer(key, msg, interval, new FixedRateMode(interval));
    }

    @Override
    public void startSingleTimer(Object key, T msg, FiniteDuration delay) {
        this.startTimer(key, msg, delay, TimerSchedulerImpl$SingleMode$.MODULE$);
    }

    private void startTimer(Object key, T msg, FiniteDuration delay, TimerMode mode) {
        Cancellable cancellable;
        Object timerMsg;
        Option option = this.timers().get(key);
        if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            this.cancelTimer(t);
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        int nextGen = BoxesRunTime.unboxToInt((Object)this.timerGen().next());
        Object object = timerMsg = msg instanceof NotInfluenceReceiveTimeout ? new NotInfluenceReceiveTimeout(this, key, nextGen){} : new TimerMsg(key, nextGen, this);
        if (TimerSchedulerImpl$SingleMode$.MODULE$.equals(mode)) {
            cancellable = this.ctx.system().scheduler().scheduleOnce(delay, () -> TimerSchedulerImpl.$anonfun$startTimer$1(this, (TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else if (mode instanceof FixedDelayMode) {
            FixedDelayMode fixedDelayMode = (FixedDelayMode)mode;
            cancellable = this.ctx.system().scheduler().scheduleWithFixedDelay(fixedDelayMode.initialDelay(), delay, () -> TimerSchedulerImpl.$anonfun$startTimer$2(this, (TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else if (mode instanceof FixedRateMode) {
            FixedRateMode fixedRateMode = (FixedRateMode)mode;
            cancellable = this.ctx.system().scheduler().scheduleAtFixedRate(fixedRateMode.initialDelay(), delay, () -> TimerSchedulerImpl.$anonfun$startTimer$3(this, (TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else {
            throw new MatchError((Object)mode);
        }
        Cancellable task = cancellable;
        Timer<T> nextTimer = new Timer<T>(key, msg, mode.repeat(), nextGen, task);
        this.timers_$eq(this.timers().updated(key, nextTimer));
    }

    @Override
    public boolean isTimerActive(Object key) {
        return this.timers().contains(key);
    }

    @Override
    public void cancel(Object key) {
        Option option = this.timers().get(key);
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            this.cancelTimer(t);
            return;
        }
        throw new MatchError((Object)option);
    }

    private void cancelTimer(Timer<T> timer) {
        timer.task().cancel();
        this.timers_$eq((Map)this.timers().$minus(timer.key()));
    }

    @Override
    public void cancelAll() {
        this.timers().valuesIterator().foreach((Function1 & Serializable & scala.Serializable)timer -> BoxesRunTime.boxToBoolean((boolean)TimerSchedulerImpl.$anonfun$cancelAll$1(timer)));
        this.timers_$eq(Predef$.MODULE$.Map().empty());
    }

    public T interceptTimerMsg(Logger log, TimerMsg timerMsg) {
        Option option = this.timers().get(timerMsg.key());
        if (None$.MODULE$.equals(option)) {
            log.debug("Received timer [{}] that has been removed, discarding", timerMsg.key());
            return (T)OptionVal$.MODULE$.none();
        }
        if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            if (timerMsg.owner() != this) {
                log.debug("Received timer [{}] from old restarted instance, discarding", timerMsg.key());
                return (T)OptionVal$.MODULE$.none();
            }
            if (timerMsg.generation() == t.generation()) {
                if (!t.repeat()) {
                    this.timers_$eq((Map)this.timers().$minus(t.key()));
                }
                return (T)OptionVal.Some$.MODULE$.apply(t.msg());
            }
            if (log.isDebugEnabled()) {
                package$LoggerOps$.MODULE$.debugN$extension0(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(log), "Received timer [{}] from old generation [{}], expected generation [{}], discarding", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timerMsg.key(), BoxesRunTime.boxToInteger((int)timerMsg.generation()), BoxesRunTime.boxToInteger((int)t.generation())}));
            }
            return (T)OptionVal$.MODULE$.none();
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$startTimer$1(TimerSchedulerImpl $this, TimerMsg timerMsg$1) {
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps($this.ctx.self().unsafeUpcast()), timerMsg$1);
    }

    public static final /* synthetic */ void $anonfun$startTimer$2(TimerSchedulerImpl $this, TimerMsg timerMsg$1) {
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps($this.ctx.self().unsafeUpcast()), timerMsg$1);
    }

    public static final /* synthetic */ void $anonfun$startTimer$3(TimerSchedulerImpl $this, TimerMsg timerMsg$1) {
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps($this.ctx.self().unsafeUpcast()), timerMsg$1);
    }

    public static final /* synthetic */ boolean $anonfun$cancelAll$1(Timer timer) {
        return timer.task().cancel();
    }

    public TimerSchedulerImpl(ActorContext<T> ctx) {
        this.ctx = ctx;
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.$init$(this);
        TimerScheduler.$init$(this);
        TimerSchedulerCrossDslSupport.$init$(this);
        this.timers = Predef$.MODULE$.Map().empty();
        this.timerGen = package$.MODULE$.Iterator().from(1);
    }

    private static class FixedDelayMode
    implements TimerMode,
    Product,
    scala.Serializable {
        private final FiniteDuration initialDelay;

        public FiniteDuration initialDelay() {
            return this.initialDelay;
        }

        @Override
        public boolean repeat() {
            return true;
        }

        public FixedDelayMode copy(FiniteDuration initialDelay) {
            return new FixedDelayMode(initialDelay);
        }

        public FiniteDuration copy$default$1() {
            return this.initialDelay();
        }

        public String productPrefix() {
            return "FixedDelayMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.initialDelay();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FixedDelayMode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FixedDelayMode)) break block3;
                    FixedDelayMode fixedDelayMode = (FixedDelayMode)x$1;
                    FiniteDuration finiteDuration = this.initialDelay();
                    FiniteDuration finiteDuration2 = fixedDelayMode.initialDelay();
                    if ((finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null) || !fixedDelayMode.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public FixedDelayMode(FiniteDuration initialDelay) {
            this.initialDelay = initialDelay;
            Product.$init$((Product)this);
        }
    }

    private static class FixedRateMode
    implements TimerMode,
    Product,
    scala.Serializable {
        private final FiniteDuration initialDelay;

        public FiniteDuration initialDelay() {
            return this.initialDelay;
        }

        @Override
        public boolean repeat() {
            return true;
        }

        public FixedRateMode copy(FiniteDuration initialDelay) {
            return new FixedRateMode(initialDelay);
        }

        public FiniteDuration copy$default$1() {
            return this.initialDelay();
        }

        public String productPrefix() {
            return "FixedRateMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.initialDelay();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FixedRateMode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FixedRateMode)) break block3;
                    FixedRateMode fixedRateMode = (FixedRateMode)x$1;
                    FiniteDuration finiteDuration = this.initialDelay();
                    FiniteDuration finiteDuration2 = fixedRateMode.initialDelay();
                    if ((finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null) || !fixedRateMode.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public FixedRateMode(FiniteDuration initialDelay) {
            this.initialDelay = initialDelay;
            Product.$init$((Product)this);
        }
    }

    public static final class Timer<T>
    implements Product,
    scala.Serializable {
        private final Object key;
        private final T msg;
        private final boolean repeat;
        private final int generation;
        private final Cancellable task;

        public Object key() {
            return this.key;
        }

        public T msg() {
            return this.msg;
        }

        public boolean repeat() {
            return this.repeat;
        }

        public int generation() {
            return this.generation;
        }

        public Cancellable task() {
            return this.task;
        }

        public <T> Timer<T> copy(Object key, T msg, boolean repeat, int generation, Cancellable task) {
            return new Timer<T>(key, msg, repeat, generation, task);
        }

        public <T> Object copy$default$1() {
            return this.key();
        }

        public <T> T copy$default$2() {
            return this.msg();
        }

        public <T> boolean copy$default$3() {
            return this.repeat();
        }

        public <T> int copy$default$4() {
            return this.generation();
        }

        public <T> Cancellable copy$default$5() {
            return this.task();
        }

        public String productPrefix() {
            return "Timer";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.msg();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this.repeat());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this.generation());
                }
                case 4: {
                    return this.task();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Timer;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.key())), (int)Statics.anyHash(this.msg())), (int)(this.repeat() ? 1231 : 1237)), (int)this.generation()), (int)Statics.anyHash((Object)this.task())), (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof Timer)) break block3;
                    Timer timer = (Timer)x$1;
                    if (!BoxesRunTime.equals((Object)this.key(), (Object)timer.key()) || !BoxesRunTime.equals(this.msg(), timer.msg()) || this.repeat() != timer.repeat() || this.generation() != timer.generation()) break block3;
                    Cancellable cancellable = this.task();
                    Cancellable cancellable2 = timer.task();
                    if (cancellable != null ? !cancellable.equals(cancellable2) : cancellable2 != null) break block3;
                }
                return true;
            }
            return false;
        }

        public Timer(Object key, T msg, boolean repeat, int generation, Cancellable task) {
            this.key = key;
            this.msg = msg;
            this.repeat = repeat;
            this.generation = generation;
            this.task = task;
            Product.$init$((Product)this);
        }
    }

    private static interface TimerMode {
        public boolean repeat();
    }

    public static class TimerMsg {
        private final Object key;
        private final int generation;
        private final Object owner;

        public Object key() {
            return this.key;
        }

        public int generation() {
            return this.generation;
        }

        public Object owner() {
            return this.owner;
        }

        public String toString() {
            return new StringBuilder(35).append("TimerMsg(key=").append(this.key()).append(", generation=").append(this.generation()).append(", owner=").append(this.owner()).append(")").toString();
        }

        public TimerMsg(Object key, int generation, Object owner) {
            this.key = key;
            this.generation = generation;
            this.owner = owner;
        }
    }
}

