/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.io.IOException;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.ForwardingHttpRequest;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.PathFilter;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.RequestURI;

@API(status=API.Status.INTERNAL)
final class FilteredHttpRequest
implements ForwardingHttpRequest {
    private final HttpRequest request;
    private final String query;
    private final String path;
    private final BodyFilter bodyFilter;
    private final HttpHeaders headers;

    FilteredHttpRequest(HttpRequest request, QueryFilter queryFilter, PathFilter pathFilter, HeaderFilter headerFilter, BodyFilter bodyFilter) {
        this.request = request;
        this.bodyFilter = bodyFilter;
        this.headers = headerFilter.filter(request.getHeaders());
        String query = request.getQuery();
        this.query = query.isEmpty() ? query : queryFilter.filter(query);
        this.path = pathFilter.filter(request.getPath());
    }

    public HttpRequest delegate() {
        return this.request;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String getRequestUri() {
        return RequestURI.reconstruct((HttpRequest)this);
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public HttpRequest withBody() throws IOException {
        return this.withRequest(this.request.withBody());
    }

    public HttpRequest withoutBody() {
        return this.withRequest(this.request.withoutBody());
    }

    private FilteredHttpRequest withRequest(HttpRequest request) {
        return new FilteredHttpRequest(request, this.query, this.path, this.bodyFilter, this.headers);
    }

    public byte[] getBody() throws IOException {
        return this.getBodyAsString().getBytes(this.getCharset());
    }

    public String getBodyAsString() throws IOException {
        return this.bodyFilter.filter(this.getContentType(), this.request.getBodyAsString());
    }

    @Generated
    private FilteredHttpRequest(HttpRequest request, String query, String path, BodyFilter bodyFilter, HttpHeaders headers) {
        this.request = request;
        this.query = query;
        this.path = path;
        this.bodyFilter = bodyFilter;
        this.headers = headers;
    }
}

