/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpLogWriter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.Sink;

@API(status=API.Status.EXPERIMENTAL)
public final class ExtendedLogFormatSink
implements Sink {
    private static final String DELIMITER = " ";
    private static final String HEADER_DELIMITER = ";";
    private static final String OMITTED_FIELD = "-";
    private static final String DEFAULT_VERSION = "1.0";
    private static final String DEFAULT_FIELDS = "date time c-ip s-dns cs-method cs-uri-stem cs-uri-query sc-status sc-bytes cs-bytes time-taken cs-protocol cs(User-Agent) cs(Cookie) cs(Referrer)";
    private static final Pattern CS_HEADER_REGEX = Pattern.compile("cs\\((.*?)\\)");
    private static final Pattern SC_HEADER_REGEX = Pattern.compile("sc\\((.*?)\\)");
    private final HttpLogWriter writer;
    private final ZoneId timeZone;
    private final List<String> supportedFields;
    private final List<String> fields;

    public ExtendedLogFormatSink(HttpLogWriter writer) {
        this(writer, ZoneId.of("UTC"), DEFAULT_VERSION, DEFAULT_FIELDS);
    }

    public ExtendedLogFormatSink(HttpLogWriter writer, String fields) {
        this(writer, ZoneId.of("UTC"), DEFAULT_VERSION, fields);
    }

    public ExtendedLogFormatSink(HttpLogWriter writer, ZoneId timeZone, String version, String fields) {
        this.writer = writer;
        this.timeZone = timeZone;
        this.supportedFields = this.getSupportedFields();
        this.fields = this.getFields(fields);
        this.logDirectives(version, this.fields);
    }

    public boolean isActive() {
        return this.writer.isActive();
    }

    public void write(Precorrelation precorrelation, HttpRequest request) {
    }

    public void write(Correlation correlation, HttpRequest request, HttpResponse response) throws IOException {
        ZonedDateTime startTime = correlation.getStart().atZone(this.timeZone);
        byte[] requestBody = request.getBody();
        byte[] responseBody = response.getBody();
        FieldParameter fieldParameter = new FieldParameter(startTime, correlation, request, response, requestBody, responseBody);
        HashMap<String, String> fieldValMap = new HashMap<String, String>();
        for (Field field : Field.values()) {
            fieldValMap.put(field.value, field.getExtraction().apply(fieldParameter));
        }
        ArrayList<String> outputFields = new ArrayList<String>(this.fields);
        String output = outputFields.stream().map(outputField -> this.getFieldOutput((String)outputField, (Map<String, String>)fieldValMap, request, response)).reduce((f1, f2) -> String.join((CharSequence)DELIMITER, f1, f2)).orElse("");
        this.writer.write(correlation, output);
    }

    private String getFieldOutput(String outputField, Map<String, String> fieldValMap, HttpRequest request, HttpResponse response) {
        if (this.supportedFields.contains(outputField)) {
            return fieldValMap.get(outputField);
        }
        Matcher csHeaderMatcher = CS_HEADER_REGEX.matcher(outputField);
        if (csHeaderMatcher.find()) {
            String headerKey = csHeaderMatcher.group(1);
            return this.getCsHeader(request, headerKey);
        }
        Matcher scHeaderMatcher = SC_HEADER_REGEX.matcher(outputField);
        if (scHeaderMatcher.find()) {
            String headerKey = scHeaderMatcher.group(1);
            return this.getScHeader(response, headerKey);
        }
        return OMITTED_FIELD;
    }

    private String getCsHeader(HttpRequest request, String key) {
        return this.buildHeaderString(request.getHeaders(), key);
    }

    private String getScHeader(HttpResponse response, String key) {
        return this.buildHeaderString(response.getHeaders(), key);
    }

    private String buildHeaderString(HttpHeaders httpHeaders, String key) {
        return Optional.of(httpHeaders).map(headers -> (List)httpHeaders.get((Object)key)).map(values -> values.stream().reduce((v1, v2) -> String.join((CharSequence)HEADER_DELIMITER, v1, v2)).map(valueStr -> "\"".concat((String)valueStr).concat("\"")).orElse(OMITTED_FIELD)).orElse(OMITTED_FIELD);
    }

    private List<String> getSupportedFields() {
        return Arrays.stream(Field.values()).map(field -> ((Field)field).value).collect(Collectors.toList());
    }

    private List<String> getFields(String fieldExpression) {
        List<String> fields = this.getFieldsFromExpression(fieldExpression);
        if (fields.isEmpty()) {
            return this.getFieldsFromExpression(DEFAULT_FIELDS);
        }
        return fields;
    }

    private List<String> getFieldsFromExpression(String fieldExpression) {
        List<String> fieldList = Arrays.asList(fieldExpression.split(DELIMITER));
        return fieldList.stream().filter(field -> !field.equals("")).collect(Collectors.toList());
    }

    private void logDirectives(String version, List<String> fields) {
        String date = DateTimeFormatter.ISO_LOCAL_DATE.format(Instant.now().atZone(this.timeZone));
        Logger log = LoggerFactory.getLogger(Logbook.class);
        log.trace("#Version: {}", (Object)version);
        log.trace("#Date: {}", (Object)date);
        log.trace("#Fields: {}", fields);
    }

    private static class FieldParameter {
        private final ZonedDateTime startTime;
        private final Correlation correlation;
        private final HttpRequest request;
        private final HttpResponse response;
        private final byte[] requestBody;
        private final byte[] responseBody;

        @Generated
        public ZonedDateTime getStartTime() {
            return this.startTime;
        }

        @Generated
        public Correlation getCorrelation() {
            return this.correlation;
        }

        @Generated
        public HttpRequest getRequest() {
            return this.request;
        }

        @Generated
        public HttpResponse getResponse() {
            return this.response;
        }

        @Generated
        public byte[] getRequestBody() {
            return this.requestBody;
        }

        @Generated
        public byte[] getResponseBody() {
            return this.responseBody;
        }

        @Generated
        public FieldParameter(ZonedDateTime startTime, Correlation correlation, HttpRequest request, HttpResponse response, byte[] requestBody, byte[] responseBody) {
            this.startTime = startTime;
            this.correlation = correlation;
            this.request = request;
            this.response = response;
            this.requestBody = requestBody;
            this.responseBody = responseBody;
        }
    }

    private static enum Field {
        DATE("date", fieldParameter -> DateTimeFormatter.ISO_LOCAL_DATE.format(fieldParameter.getStartTime())),
        TIME("time", fieldParameter -> DateTimeFormatter.ISO_LOCAL_TIME.format(fieldParameter.getStartTime())),
        TIME_TAKEN("time-taken", fieldParameter -> BigDecimal.valueOf(fieldParameter.getCorrelation().getDuration().toMillis()).divide(BigDecimal.valueOf(1000L), 3, RoundingMode.HALF_UP).toString()),
        CS_PROTOCOL("cs-protocol", fieldParameter -> fieldParameter.getRequest().getProtocolVersion()),
        SC_BYTES("sc-bytes", fieldParameter -> String.valueOf(fieldParameter.getResponseBody().length)),
        CS_BYTES("cs-bytes", fieldParameter -> String.valueOf(fieldParameter.getRequestBody().length)),
        CLIENT_IP("c-ip", fieldParameter -> fieldParameter.getRequest().getRemote()),
        SERVER_DNS("s-dns", fieldParameter -> fieldParameter.getRequest().getHost()),
        RESP_STATUS("sc-status", fieldParameter -> String.valueOf(fieldParameter.getResponse().getStatus())),
        RESP_COMMENT("sc-comment", fieldParameter -> fieldParameter.getResponse().getReasonPhrase()),
        REQ_METHOD("cs-method", fieldParameter -> fieldParameter.getRequest().getMethod()),
        REQ_URI("cs-uri", fieldParameter -> fieldParameter.getRequest().getRequestUri()),
        REQ_URI_STEM("cs-uri-stem", fieldParameter -> fieldParameter.getRequest().getPath()),
        REQ_URI_QUERY("cs-uri-query", fieldParameter -> {
            if (!"".equals(fieldParameter.getRequest().getQuery())) {
                return "?" + fieldParameter.getRequest().getQuery();
            }
            return ExtendedLogFormatSink.OMITTED_FIELD;
        });

        private final String value;
        private final Function<FieldParameter, String> extraction;

        private Field(String label, Function<FieldParameter, String> extract) {
            this.value = label;
            this.extraction = extract;
        }

        Function<FieldParameter, String> getExtraction() {
            return this.extraction;
        }
    }
}

