/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.unit;

import cn.sliew.milky.common.primitives.Strings;
import cn.sliew.milky.common.unit.MoneyUnit;
import cn.sliew.milky.common.unit.ValueParseException;
import java.math.BigDecimal;
import java.util.Locale;

public class MoneyValue
implements Comparable<MoneyValue> {
    public static final MoneyValue ZERO = new MoneyValue(BigDecimal.ZERO, MoneyUnit.HAO);
    private final BigDecimal value;
    private final MoneyUnit unit;

    public MoneyValue(BigDecimal hao) {
        this(hao, MoneyUnit.HAO);
    }

    public MoneyValue(BigDecimal value, MoneyUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public BigDecimal getHao() {
        return this.unit.toHao(this.value);
    }

    public BigDecimal getFen() {
        return this.unit.toFen(this.value);
    }

    public BigDecimal getJiao() {
        return this.unit.toJiao(this.value);
    }

    public BigDecimal getYuan() {
        return this.unit.toYuan(this.value);
    }

    public BigDecimal getFenFrac() {
        return this.getHao().divide(MoneyUnit.C1);
    }

    public BigDecimal getJiaoFrac() {
        return this.getHao().divide(MoneyUnit.C2);
    }

    public BigDecimal getYuanFrac() {
        return this.getHao().divide(MoneyUnit.C3);
    }

    public static MoneyValue parseMoneyValue(String value) throws ValueParseException {
        return MoneyValue.parseMoneyValue(value, null);
    }

    public static MoneyValue parseMoneyValue(String value, MoneyValue defaultValue) throws ValueParseException {
        if (value == null) {
            return defaultValue;
        }
        String lowerValue = value.toLowerCase(Locale.ROOT).trim();
        if (lowerValue.endsWith("\u6beb")) {
            return MoneyValue.parse(value, lowerValue, "\u6beb", MoneyUnit.HAO);
        }
        if (lowerValue.endsWith("\u5206")) {
            return MoneyValue.parse(value, lowerValue, "\u5206", MoneyUnit.FEN);
        }
        if (lowerValue.endsWith("\u89d2")) {
            return MoneyValue.parse(value, lowerValue, "\u89d2", MoneyUnit.JIAO);
        }
        if (lowerValue.endsWith("\u5143")) {
            return MoneyValue.parse(value, lowerValue, "\u5143", MoneyUnit.YUAN);
        }
        if (lowerValue.equals("0")) {
            return new MoneyValue(BigDecimal.ZERO, MoneyUnit.HAO);
        }
        throw new ValueParseException(String.format("failed to parse value [{}] as money: unit is missing or unrecognized", value));
    }

    private static MoneyValue parse(String initialInput, String normalized, String suffix, MoneyUnit unit) {
        String s = normalized.substring(0, normalized.length() - suffix.length()).trim();
        try {
            return new MoneyValue(BigDecimal.valueOf(Long.parseLong(s)), unit);
        }
        catch (NumberFormatException e) {
            throw new ValueParseException(String.format("failed to parse value [{}] as money", initialInput), e);
        }
    }

    @Override
    public int compareTo(MoneyValue other) {
        BigDecimal thisValue = this.value.multiply(this.unit.toHao(BigDecimal.ONE));
        BigDecimal otherValue = other.value.multiply(other.unit.toHao(BigDecimal.ONE));
        return thisValue.compareTo(otherValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((MoneyValue)o) == 0;
    }

    public int hashCode() {
        return this.value.multiply(this.unit.toHao(BigDecimal.ONE)).hashCode();
    }

    public String toString() {
        BigDecimal hao;
        BigDecimal value = hao = this.getHao();
        String suffix = MoneyUnit.HAO.getSuffix();
        if (value.compareTo(MoneyUnit.C3) >= 0) {
            value = this.getYuanFrac();
            suffix = MoneyUnit.YUAN.getSuffix();
        } else if (value.compareTo(MoneyUnit.C2) >= 0) {
            value = this.getJiaoFrac();
            suffix = MoneyUnit.JIAO.getSuffix();
        } else if (value.compareTo(MoneyUnit.C1) >= 0) {
            value = this.getFenFrac();
            suffix = MoneyUnit.FEN.getSuffix();
        }
        return Strings.format1Decimals(value.doubleValue(), suffix);
    }
}

