/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.impl;

import cn.sliew.carp.framework.common.util.UUIDUtil;
import cn.sliew.carp.framework.dag.repository.entity.DagConfig;
import cn.sliew.carp.framework.dag.repository.mapper.DagConfigMapper;
import cn.sliew.carp.framework.dag.service.DagConfigService;
import cn.sliew.carp.framework.dag.service.convert.DagConfigConvert;
import cn.sliew.carp.framework.dag.service.dto.DagConfigDTO;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DagConfigServiceImpl
extends ServiceImpl<DagConfigMapper, DagConfig>
implements DagConfigService {
    @Override
    public DagConfigDTO get(Long id) {
        DagConfig entity = (DagConfig)((Object)this.getOptById(id).orElseThrow(() -> new IllegalArgumentException("dag config not exists for id: " + id)));
        return DagConfigConvert.INSTANCE.toDto(entity);
    }

    @Override
    public Long add(DagConfigDTO configDTO) {
        DagConfig record = DagConfigConvert.INSTANCE.toDo(configDTO);
        record.setUuid(UUIDUtil.randomUUId());
        record.setVersion(0);
        this.save((Object)record);
        return record.getId();
    }

    @Override
    public boolean update(DagConfigDTO configDTO) {
        DagConfig record = DagConfigConvert.INSTANCE.toDo(configDTO);
        return this.updateById((Object)record);
    }

    @Override
    public void upsert(DagConfigDTO configDTO) {
        if (configDTO.getId() != null) {
            this.update(configDTO);
        } else {
            this.add(configDTO);
        }
    }

    @Override
    public boolean delete(Long id) {
        return this.removeById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="carpTransactionManager")
    public boolean deleteBatch(Collection<Long> ids) {
        return this.removeBatchByIds(ids);
    }

    @Override
    public Long clone(Long id) {
        DagConfigDTO configDTO = this.get(id);
        configDTO.setId(null);
        configDTO.setCreator(null);
        configDTO.setCreateTime(null);
        configDTO.setEditor(null);
        configDTO.setUpdateTime(null);
        configDTO.setName(configDTO.getName() + "_copy_" + UUIDUtil.randomUUId());
        configDTO.setUuid(UUIDUtil.randomUUId());
        return this.add(configDTO);
    }
}

