/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.impl;

import cn.sliew.carp.framework.dag.algorithm.DAG;
import cn.sliew.carp.framework.dag.service.DagConfigComplexService;
import cn.sliew.carp.framework.dag.service.DagConfigLinkService;
import cn.sliew.carp.framework.dag.service.DagConfigService;
import cn.sliew.carp.framework.dag.service.DagConfigStepService;
import cn.sliew.carp.framework.dag.service.dto.DagConfigComplexDTO;
import cn.sliew.carp.framework.dag.service.dto.DagConfigDTO;
import cn.sliew.carp.framework.dag.service.dto.DagConfigLinkDTO;
import cn.sliew.carp.framework.dag.service.dto.DagConfigStepDTO;
import cn.sliew.carp.framework.dag.service.param.DagConfigSimpleAddParam;
import cn.sliew.carp.framework.dag.service.param.DagConfigSimpleUpdateParam;
import cn.sliew.carp.framework.dag.x6.graph.DagGraphVO;
import cn.sliew.carp.framework.dag.x6.graph.EdgeCellVO;
import cn.sliew.carp.framework.dag.x6.graph.NodeCellVO;
import cn.sliew.milky.common.util.JacksonUtil;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DagConfigComplexServiceImpl
implements DagConfigComplexService {
    @Autowired
    private DagConfigService dagConfigService;
    @Autowired
    private DagConfigLinkService dagConfigLinkService;
    @Autowired
    private DagConfigStepService dagConfigStepService;

    @Override
    public DagConfigComplexDTO selectOne(Long dagId) {
        DagConfigComplexDTO dagConfigComplexDTO = new DagConfigComplexDTO();
        DagConfigDTO configDTO = this.dagConfigService.get(dagId);
        BeanUtils.copyProperties((Object)((Object)configDTO), (Object)((Object)dagConfigComplexDTO));
        dagConfigComplexDTO.setLinks(this.dagConfigLinkService.listLinks(dagId));
        dagConfigComplexDTO.setSteps(this.dagConfigStepService.listSteps(dagId));
        return dagConfigComplexDTO;
    }

    @Override
    public DagConfigDTO selectSimpleOne(Long dagId) {
        return this.dagConfigService.get(dagId);
    }

    @Override
    public Graph<DagConfigStepDTO> getDag(Long dagId) {
        DAG<DagConfigStepDTO> dag = this.getDagNew(dagId);
        MutableGraph graph = GraphBuilder.directed().build();
        dag.nodes().forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        dag.edges().forEach(edge -> graph.putEdge((Object)((DagConfigStepDTO)((Object)((Object)edge.getSource()))), (Object)((DagConfigStepDTO)((Object)((Object)edge.getTarget())))));
        return graph;
    }

    @Override
    public DAG<DagConfigStepDTO> getDagNew(Long dagId) {
        DagConfigComplexDTO dag = this.selectOne(dagId);
        DAG<DagConfigStepDTO> graph = new DAG<DagConfigStepDTO>();
        List<DagConfigStepDTO> steps = dag.getSteps();
        List<DagConfigLinkDTO> links = dag.getLinks();
        if (CollectionUtils.isEmpty(steps)) {
            return graph;
        }
        HashMap<String, DagConfigStepDTO> stepMap = new HashMap<String, DagConfigStepDTO>();
        for (DagConfigStepDTO step : steps) {
            graph.addNode(step);
            stepMap.put(step.getStepId(), step);
        }
        links.forEach(link -> graph.addEdge((DagConfigStepDTO)((Object)((Object)stepMap.get(link.getFromStepId()))), (DagConfigStepDTO)((Object)((Object)stepMap.get(link.getToStepId())))));
        return graph;
    }

    @Override
    public Long insert(DagConfigSimpleAddParam param) {
        DagConfigDTO configDTO = new DagConfigDTO();
        BeanUtils.copyProperties((Object)param, (Object)((Object)configDTO));
        return this.dagConfigService.add(configDTO);
    }

    @Override
    public boolean update(DagConfigSimpleUpdateParam param) {
        DagConfigDTO configDTO = new DagConfigDTO();
        BeanUtils.copyProperties((Object)param, (Object)((Object)configDTO));
        return this.dagConfigService.update(configDTO);
    }

    @Override
    public void replace(Long dagId, DagGraphVO graph) {
        this.saveSteps(dagId, graph.getNodes());
        this.saveLinks(dagId, graph.getEdges());
    }

    private void saveSteps(Long dagId, List<NodeCellVO> nodes) {
        List<String> stepIds = nodes.stream().map(NodeCellVO::getId).collect(Collectors.toList());
        this.dagConfigStepService.deleteSurplusSteps(dagId, stepIds);
        for (NodeCellVO node : nodes) {
            DagConfigStepDTO stepDTO = new DagConfigStepDTO();
            stepDTO.setDagId(dagId);
            stepDTO.setStepId(node.getId());
            if (node.getData() != null) {
                stepDTO.setStepName(node.getData().getLabel());
                stepDTO.setStepMeta(JacksonUtil.toJsonNode(node.getData().getMeta()));
                stepDTO.setStepAttrs(JacksonUtil.toJsonNode(node.getData().getAttrs()));
            }
            stepDTO.setPositionX(node.getPosition().getX());
            stepDTO.setPositionY(node.getPosition().getY());
            this.dagConfigStepService.upsert(stepDTO);
        }
    }

    private void saveLinks(Long jobId, List<EdgeCellVO> edges) {
        List<String> linkIds = edges.stream().map(EdgeCellVO::getId).collect(Collectors.toList());
        this.dagConfigLinkService.deleteSurplusLinks(jobId, linkIds);
        for (EdgeCellVO edge : edges) {
            DagConfigLinkDTO linkDTO = new DagConfigLinkDTO();
            linkDTO.setDagId(jobId);
            linkDTO.setLinkId(edge.getId());
            if (edge.getData() != null) {
                linkDTO.setLinkName(edge.getData().getLabel());
                linkDTO.setLinkMeta(JacksonUtil.toJsonNode(edge.getData().getMeta()));
                linkDTO.setLinkAttrs(JacksonUtil.toJsonNode(edge.getData().getAttrs()));
            }
            linkDTO.setFromStepId(edge.getSource().getCell());
            linkDTO.setToStepId(edge.getTarget().getCell());
            this.dagConfigLinkService.upsert(linkDTO);
        }
    }

    @Override
    public Long clone(Long dagId) {
        Long cloneDagId = this.dagConfigService.clone(dagId);
        this.dagConfigStepService.clone(dagId, cloneDagId);
        this.dagConfigLinkService.clone(dagId, cloneDagId);
        return cloneDagId;
    }

    @Override
    public boolean delete(Long dagId) {
        this.dagConfigStepService.deleteByDag(dagId);
        this.dagConfigLinkService.deleteByDag(dagId);
        return this.dagConfigService.delete(dagId);
    }

    @Override
    public boolean deleteBatch(List<Long> dagIds) {
        this.dagConfigStepService.deleteByDag(dagIds);
        this.dagConfigLinkService.deleteBatchByDag(dagIds);
        return this.dagConfigService.deleteBatch(dagIds);
    }
}

