/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.convert;

import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.carp.framework.dag.repository.entity.DagStep;
import cn.sliew.carp.framework.dag.service.dto.DagConfigStepDTO;
import cn.sliew.carp.framework.dag.service.dto.DagStepDTO;
import cn.sliew.milky.common.util.JacksonUtil;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface DagStepConvert
extends BaseConvert<DagStep, DagStepDTO> {
    public static final DagStepConvert INSTANCE = (DagStepConvert)Mappers.getMapper(DagStepConvert.class);

    default public DagStep toDo(DagStepDTO dto) {
        DagStep entity = new DagStep();
        BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        if (dto.getDagConfigStep() != null) {
            entity.setDagConfigStepId(dto.getDagConfigStep().getId());
        }
        if (dto.getInputs() != null) {
            entity.setInputs(dto.getInputs().toString());
        }
        if (dto.getOutputs() != null) {
            entity.setOutputs(dto.getOutputs().toString());
        }
        return entity;
    }

    default public DagStepDTO toDto(DagStep entity) {
        DagStepDTO dto = new DagStepDTO();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        DagConfigStepDTO dagConfigStep = new DagConfigStepDTO();
        dagConfigStep.setId(entity.getDagConfigStepId());
        dto.setDagConfigStep(dagConfigStep);
        if (StringUtils.hasText((String)entity.getInputs())) {
            dto.setInputs(JacksonUtil.toJsonNode((String)entity.getInputs()));
        }
        if (StringUtils.hasText((String)entity.getOutputs())) {
            dto.setOutputs(JacksonUtil.toJsonNode((String)entity.getOutputs()));
        }
        return dto;
    }
}

