/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.configuration.SpringDocSecurityOAuth2EndpointUtils;
import org.springdoc.core.configuration.oauth2.SpringDocOAuth2AuthorizationServerMetadata;
import org.springdoc.core.configuration.oauth2.SpringDocOAuth2Token;
import org.springdoc.core.configuration.oauth2.SpringDocOAuth2TokenIntrospection;
import org.springdoc.core.configuration.oauth2.SpringDocOidcClientRegistrationRequest;
import org.springdoc.core.configuration.oauth2.SpringDocOidcClientRegistrationResponse;
import org.springdoc.core.configuration.oauth2.SpringDocOidcProviderConfiguration;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcClientRegistrationEndpointFilter;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcProviderConfigurationEndpointFilter;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcUserInfoEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.NimbusJwkSetEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationServerMetadataEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2TokenEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2TokenIntrospectionEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2TokenRevocationEndpointFilter;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class SpringDocSecurityOAuth2Customizer
implements GlobalOpenApiCustomizer,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringDocSecurityOAuth2Customizer.class);
    private static final String OAUTH2_ENDPOINT_TAG = "authorization-server-endpoints";
    private ApplicationContext applicationContext;

    @Override
    public void customise(OpenAPI openAPI) {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.applicationContext.getBean("springSecurityFilterChain", FilterChainProxy.class);
        boolean openapi31 = SpecVersion.V31 == openAPI.getSpecVersion();
        for (SecurityFilterChain filterChain : filterChainProxy.getFilterChains()) {
            this.getNimbusJwkSetEndpoint(openAPI, filterChain, openapi31);
            this.getOAuth2AuthorizationServerMetadataEndpoint(openAPI, filterChain, openapi31);
            this.getOAuth2TokenEndpoint(openAPI, filterChain, openapi31);
            this.getOAuth2AuthorizationEndpoint(openAPI, filterChain, openapi31);
            this.getOAuth2TokenIntrospectionEndpointFilter(openAPI, filterChain, openapi31);
            this.getOAuth2TokenRevocationEndpointFilter(openAPI, filterChain, openapi31);
            this.getOidcProviderConfigurationEndpoint(openAPI, filterChain, openapi31);
            this.getOidcUserInfoEndpoint(openAPI, filterChain);
            this.getOidcClientRegistrationEndpoint(openAPI, filterChain, openapi31);
        }
    }

    private void getOAuth2TokenRevocationEndpointFilter(OpenAPI openAPI, SecurityFilterChain securityFilterChain, boolean openapi31) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OAuth2TokenRevocationEndpointFilter>>(OAuth2TokenRevocationEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            apiResponses.addApiResponse(String.valueOf(HttpStatus.OK.value()), new ApiResponse().description(HttpStatus.OK.getReasonPhrase()));
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI, openapi31);
            Operation operation = this.buildOperation(apiResponses);
            Schema schema = new ObjectSchema().addProperty("token", (Schema)new StringSchema()).addProperty("token_type_hint", (Schema)new StringSchema());
            String mediaType = "application/x-www-form-urlencoded";
            RequestBody requestBody = new RequestBody().content(new Content().addMediaType(mediaType, new MediaType().schema(schema)));
            operation.setRequestBody(requestBody);
            this.buildPath(oAuth2EndpointFilter, "tokenRevocationEndpointMatcher", openAPI, operation, HttpMethod.POST);
        }
    }

    private void getOAuth2TokenIntrospectionEndpointFilter(OpenAPI openAPI, SecurityFilterChain securityFilterChain, boolean openapi31) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OAuth2TokenIntrospectionEndpointFilter>>(OAuth2TokenIntrospectionEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            this.buildApiResponsesOnSuccess(apiResponses, AnnotationsUtils.resolveSchemaFromType(SpringDocOAuth2TokenIntrospection.class, (Components)openAPI.getComponents(), null, (boolean)openapi31));
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI, openapi31);
            Operation operation = this.buildOperation(apiResponses);
            Schema requestSchema = new ObjectSchema().addProperty("token", (Schema)new StringSchema()).addProperty("token_type_hint", (Schema)new StringSchema()).addProperty("additionalParameters", new ObjectSchema().additionalProperties((Object)new StringSchema()));
            String mediaType = "application/x-www-form-urlencoded";
            RequestBody requestBody = new RequestBody().content(new Content().addMediaType(mediaType, new MediaType().schema(requestSchema)));
            operation.setRequestBody(requestBody);
            this.buildPath(oAuth2EndpointFilter, "tokenIntrospectionEndpointMatcher", openAPI, operation, HttpMethod.POST);
        }
    }

    private void getOAuth2AuthorizationServerMetadataEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain, boolean openapi31) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OAuth2AuthorizationServerMetadataEndpointFilter>>(OAuth2AuthorizationServerMetadataEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            this.buildApiResponsesOnSuccess(apiResponses, AnnotationsUtils.resolveSchemaFromType(SpringDocOAuth2AuthorizationServerMetadata.class, (Components)openAPI.getComponents(), null, (boolean)openapi31));
            this.buildApiResponsesOnInternalServerError(apiResponses);
            Operation operation = this.buildOperation(apiResponses);
            this.buildPath(oAuth2EndpointFilter, "requestMatcher", openAPI, operation, HttpMethod.GET);
        }
    }

    private void getNimbusJwkSetEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain, boolean openapi31) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<NimbusJwkSetEndpointFilter>>(NimbusJwkSetEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            MapSchema schema = new MapSchema();
            schema.addProperty("keys", (Schema)new ArraySchema().items(new ObjectSchema().additionalProperties((Object)true)));
            ApiResponse response = new ApiResponse().description(HttpStatus.OK.getReasonPhrase()).content(new Content().addMediaType("application/json", new MediaType().schema((Schema)schema)));
            apiResponses.addApiResponse(String.valueOf(HttpStatus.OK.value()), response);
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI, openapi31);
            Operation operation = this.buildOperation(apiResponses);
            operation.responses(apiResponses);
            this.buildPath(oAuth2EndpointFilter, "requestMatcher", openAPI, operation, HttpMethod.GET);
        }
    }

    private void getOAuth2TokenEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain, boolean openapi31) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OAuth2TokenEndpointFilter>>(OAuth2TokenEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            this.buildApiResponsesOnSuccess(apiResponses, AnnotationsUtils.resolveSchemaFromType(SpringDocOAuth2Token.class, (Components)openAPI.getComponents(), null, (boolean)openapi31));
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI, openapi31);
            SpringDocSecurityOAuth2Customizer.buildOAuth2Error(openAPI, apiResponses, HttpStatus.UNAUTHORIZED, openapi31);
            Operation operation = this.buildOperation(apiResponses);
            Schema requestSchema = new ObjectSchema().addProperty("grant_type", (Schema)new StringSchema().addEnumItem(AuthorizationGrantType.AUTHORIZATION_CODE.getValue()).addEnumItem(AuthorizationGrantType.REFRESH_TOKEN.getValue()).addEnumItem(AuthorizationGrantType.CLIENT_CREDENTIALS.getValue())).addProperty("code", (Schema)new StringSchema()).addProperty("redirect_uri", (Schema)new StringSchema()).addProperty("refresh_token", (Schema)new StringSchema()).addProperty("scope", (Schema)new StringSchema()).addProperty("client_id", (Schema)new StringSchema()).addProperty("client_secret", (Schema)new StringSchema()).addProperty("client_assertion_type", (Schema)new StringSchema()).addProperty("client_assertion", (Schema)new StringSchema()).addProperty("additionalParameters", new ObjectSchema().additionalProperties((Object)new StringSchema()));
            String mediaType = "application/x-www-form-urlencoded";
            RequestBody requestBody = new RequestBody().content(new Content().addMediaType(mediaType, new MediaType().schema(requestSchema)));
            operation.setRequestBody(requestBody);
            operation.addParametersItem(new HeaderParameter().name("Authorization"));
            this.buildPath(oAuth2EndpointFilter, "tokenEndpointMatcher", openAPI, operation, HttpMethod.POST);
        }
    }

    private void getOAuth2AuthorizationEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain, boolean openapi31) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OAuth2AuthorizationEndpointFilter>>(OAuth2AuthorizationEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            ApiResponse response = new ApiResponse().description(HttpStatus.OK.getReasonPhrase()).content(new Content().addMediaType("text/html", new MediaType()));
            apiResponses.addApiResponse(String.valueOf(HttpStatus.OK.value()), response);
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI, openapi31);
            apiResponses.addApiResponse(String.valueOf(HttpStatus.MOVED_TEMPORARILY.value()), new ApiResponse().description(HttpStatus.MOVED_TEMPORARILY.getReasonPhrase()).addHeaderObject("Location", new Header().schema((Schema)new StringSchema())));
            Operation operation = this.buildOperation(apiResponses);
            Schema schema = new ObjectSchema().additionalProperties((Object)new StringSchema());
            operation.addParametersItem(new Parameter().name("parameters").in(ParameterIn.QUERY.toString()).schema(schema));
            this.buildPath(oAuth2EndpointFilter, "authorizationEndpointMatcher", openAPI, operation, HttpMethod.POST);
        }
    }

    private void getOidcProviderConfigurationEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain, boolean openapi31) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OidcProviderConfigurationEndpointFilter>>(OidcProviderConfigurationEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            this.buildApiResponsesOnSuccess(apiResponses, AnnotationsUtils.resolveSchemaFromType(SpringDocOidcProviderConfiguration.class, (Components)openAPI.getComponents(), null, (boolean)openapi31));
            this.buildApiResponsesOnInternalServerError(apiResponses);
            Operation operation = this.buildOperation(apiResponses);
            this.buildPath(oAuth2EndpointFilter, "requestMatcher", openAPI, operation, HttpMethod.GET);
        }
    }

    private void getOidcUserInfoEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OidcUserInfoEndpointFilter>>(OidcUserInfoEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            Schema schema = new ObjectSchema().additionalProperties((Object)new StringSchema());
            this.buildApiResponsesOnSuccess(apiResponses, schema);
            this.buildApiResponsesOnInternalServerError(apiResponses);
            Operation operation = this.buildOperation(apiResponses);
            this.buildPath(oAuth2EndpointFilter, "userInfoEndpointMatcher", openAPI, operation, HttpMethod.GET);
        }
    }

    private void getOidcClientRegistrationEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain, boolean openapi31) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OidcClientRegistrationEndpointFilter>>(OidcClientRegistrationEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            this.buildApiResponsesOnCreated(apiResponses, AnnotationsUtils.resolveSchemaFromType(SpringDocOidcClientRegistrationResponse.class, (Components)openAPI.getComponents(), null, (boolean)openapi31));
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI, openapi31);
            SpringDocSecurityOAuth2Customizer.buildOAuth2Error(openAPI, apiResponses, HttpStatus.UNAUTHORIZED, openapi31);
            SpringDocSecurityOAuth2Customizer.buildOAuth2Error(openAPI, apiResponses, HttpStatus.FORBIDDEN, openapi31);
            Operation operation = this.buildOperation(apiResponses);
            Schema schema = AnnotationsUtils.resolveSchemaFromType(SpringDocOidcClientRegistrationRequest.class, (Components)openAPI.getComponents(), null, (boolean)openapi31);
            String mediaType = "application/json";
            RequestBody requestBody = new RequestBody().content(new Content().addMediaType(mediaType, new MediaType().schema(schema)));
            operation.setRequestBody(requestBody);
            operation.addParametersItem(new HeaderParameter().name("Authorization"));
            this.buildPath(oAuth2EndpointFilter, "clientRegistrationEndpointMatcher", openAPI, operation, HttpMethod.POST);
        }
    }

    private Operation buildOperation(ApiResponses apiResponses) {
        Operation operation = new Operation();
        operation.addTagsItem(OAUTH2_ENDPOINT_TAG);
        operation.responses(apiResponses);
        return operation;
    }

    private ApiResponses buildApiResponsesOnSuccess(ApiResponses apiResponses, Schema schema) {
        ApiResponse response = new ApiResponse().description(HttpStatus.OK.getReasonPhrase()).content(new Content().addMediaType("application/json", new MediaType().schema(schema)));
        apiResponses.addApiResponse(String.valueOf(HttpStatus.OK.value()), response);
        return apiResponses;
    }

    private ApiResponses buildApiResponsesOnCreated(ApiResponses apiResponses, Schema schema) {
        ApiResponse response = new ApiResponse().description(HttpStatus.CREATED.getReasonPhrase()).content(new Content().addMediaType("application/json", new MediaType().schema(schema)));
        apiResponses.addApiResponse(String.valueOf(HttpStatus.CREATED.value()), response);
        return apiResponses;
    }

    private ApiResponses buildApiResponsesOnInternalServerError(ApiResponses apiResponses) {
        apiResponses.addApiResponse(String.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()), new ApiResponse().description(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()));
        return apiResponses;
    }

    private ApiResponses buildApiResponsesOnBadRequest(ApiResponses apiResponses, OpenAPI openAPI, boolean openapi31) {
        SpringDocSecurityOAuth2Customizer.buildOAuth2Error(openAPI, apiResponses, HttpStatus.BAD_REQUEST, openapi31);
        return apiResponses;
    }

    private static void buildOAuth2Error(OpenAPI openAPI, ApiResponses apiResponses, HttpStatus httpStatus, boolean openapi31) {
        Schema oAuth2ErrorSchema = AnnotationsUtils.resolveSchemaFromType(OAuth2Error.class, (Components)openAPI.getComponents(), null, (boolean)openapi31);
        apiResponses.addApiResponse(String.valueOf(httpStatus.value()), new ApiResponse().description(httpStatus.getReasonPhrase()).content(new Content().addMediaType("application/json", new MediaType().schema(oAuth2ErrorSchema))));
    }

    private void buildPath(Object oAuth2EndpointFilter, String authorizationEndpointMatcher, OpenAPI openAPI, Operation operation, HttpMethod requestMethod) {
        try {
            Field tokenEndpointMatcherField = FieldUtils.getDeclaredField(oAuth2EndpointFilter.getClass(), (String)authorizationEndpointMatcher, (boolean)true);
            RequestMatcher endpointMatcher = (RequestMatcher)tokenEndpointMatcherField.get(oAuth2EndpointFilter);
            String path = null;
            if (endpointMatcher instanceof AntPathRequestMatcher) {
                AntPathRequestMatcher antPathRequestMatcher = (AntPathRequestMatcher)endpointMatcher;
                path = antPathRequestMatcher.getPattern();
            } else if (endpointMatcher instanceof OrRequestMatcher) {
                OrRequestMatcher endpointMatchers = (OrRequestMatcher)endpointMatcher;
                Field requestMatchersField = FieldUtils.getDeclaredField(OrRequestMatcher.class, (String)"requestMatchers", (boolean)true);
                Iterable requestMatchers = (Iterable)requestMatchersField.get(endpointMatchers);
                for (RequestMatcher requestMatcher : requestMatchers) {
                    if (requestMatcher instanceof OrRequestMatcher) {
                        OrRequestMatcher orRequestMatcher = (OrRequestMatcher)requestMatcher;
                        requestMatchersField = FieldUtils.getDeclaredField(OrRequestMatcher.class, (String)"requestMatchers", (boolean)true);
                        requestMatchers = (Iterable)requestMatchersField.get(orRequestMatcher);
                        for (RequestMatcher matcher : requestMatchers) {
                            if (!(matcher instanceof AntPathRequestMatcher)) continue;
                            AntPathRequestMatcher antPathRequestMatcher = (AntPathRequestMatcher)matcher;
                            path = antPathRequestMatcher.getPattern();
                        }
                        continue;
                    }
                    if (!(requestMatcher instanceof AntPathRequestMatcher)) continue;
                    AntPathRequestMatcher antPathRequestMatcher = (AntPathRequestMatcher)requestMatcher;
                    path = antPathRequestMatcher.getPattern();
                }
            }
            PathItem pathItem = new PathItem();
            if (HttpMethod.POST.equals((Object)requestMethod)) {
                pathItem.post(operation);
            } else if (HttpMethod.GET.equals((Object)requestMethod)) {
                pathItem.get(operation);
            }
            openAPI.getPaths().addPathItem(path, pathItem);
        }
        catch (ClassCastException | IllegalAccessException ignored) {
            LOGGER.trace(ignored.getMessage());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

