/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.Version$;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefProvider;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$Settings$;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.actor.CoordinatedShutdown$ActorSystemTerminateReason$;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.ExtensionIdProvider;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.LocalActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.ReflectiveDynamicAccess;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.StopChild;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.dungeon.ChildrenContainer;
import org.apache.pekko.actor.dungeon.ChildrenContainer$EmptyChildrenContainer$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$TerminatedChildrenContainer$;
import org.apache.pekko.actor.setup.ActorSystemSetup;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.DefaultDispatcherPrerequisites;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.dispatch.Mailboxes;
import org.apache.pekko.dispatch.MonitorableThreadFactory;
import org.apache.pekko.dispatch.MonitorableThreadFactory$;
import org.apache.pekko.event.DeadLetterListener;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.LoggingFilter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.FutureConverters$FutureOps$;
import org.apache.pekko.util.ManifestInfo;
import org.apache.pekko.util.ManifestInfo$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011-b!B0a\u0001\tD\u0007\u0002C7\u0001\u0005\u000b\u0007I\u0011A8\t\u0011u\u0004!\u0011!Q\u0001\nAD\u0001B \u0001\u0003\u0002\u0003\u0006Ia \u0005\u000b\u0003'\u0001!\u0011!Q\u0001\n\u0005U\u0001BCA\u0013\u0001\t\u0005\t\u0015!\u0003\u0002(!Q\u00111\b\u0001\u0003\u0006\u0004%\t!!\u0010\t\u0015\u0005\u001d\u0003A!A!\u0002\u0013\ty\u0004\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003\u0017Bq!!\u0016\u0001\t\u0003\t9\u0006C\u0005\u0002h\u0001\u0011\r\u0011\"\u0001\u0002j!A\u0011\u0011\u000f\u0001!\u0002\u0013\tY\u0007C\u0005\u0002t\u0001\u0001\r\u0011\"\u0003\u0002v!I\u0011q\u0010\u0001A\u0002\u0013%\u0011\u0011\u0011\u0005\t\u0003\u001b\u0003\u0001\u0015)\u0003\u0002x!I\u0011q\u0013\u0001C\u0002\u0013%\u0011\u0011\u0014\u0005\t\u0003C\u0003\u0001\u0015!\u0003\u0002\u001c\"I\u00111\u0015\u0001C\u0002\u0013\u0015\u0011Q\u0015\u0005\t\u0003k\u0003\u0001\u0015!\u0004\u0002(\"9\u0011q\u0017\u0001\u0005\u0012\u0005e\u0006\"CAe\u0001\t\u0007IQAAf\u0011!\tI\u000e\u0001Q\u0001\u000e\u00055\u0007bBAn\u0001\u0011E\u0011Q\u001c\u0005\b\u0003?\u0004A\u0011AAM\u0011\u001d\t\t\u000f\u0001C\u0001\u0003GDq!!:\u0001\t#\t9\u000fC\u0004\u0002j\u0002!\t!a;\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9\u00111\u001f\u0001\u0005\u0002\u0005m\bbBA\u0000\u0001\u0011\u0005!\u0011\u0001\u0005\n\u0005\u000b\u0001!\u0019!C\u0001\u0005\u000fA\u0001B!\u0006\u0001A\u0003%!\u0011\u0002\u0005\n\u0005/\u0001!\u0019!C\u0001\u00053A\u0001B!\t\u0001A\u0003%!1\u0004\u0005\t\u0005G\u0001\u0001\u0015!\u0003\u0003&!I!1\u0006\u0001C\u0002\u0013\u0005!Q\u0006\u0005\t\u0005k\u0001\u0001\u0015!\u0003\u00030!I!q\u0007\u0001C\u0002\u0013\u0005!\u0011\b\u0005\t\u0005\u0003\u0002\u0001\u0015!\u0003\u0003<!I!1\t\u0001C\u0002\u0013\u0005!Q\t\u0005\t\u0005\u001b\u0002\u0001\u0015!\u0003\u0003H!9!q\n\u0001\u0005\u0002\tE\u0003\"\u0003B*\u0001\t\u0007I\u0011\u0001B+\u0011!\u0011i\u0006\u0001Q\u0001\n\t]\u0003\"\u0003B0\u0001\t\u0007I\u0011\u0001B1\u0011!\u0011I\u0007\u0001Q\u0001\n\t\r\u0004\"\u0003B6\u0001\t\u0007I\u0011\u0001B7\u0011!\u0011)\b\u0001Q\u0001\n\t=\u0004\u0002\u0003B<\u0001\u0001\u0006iA!\u001f\t\u000f\t\u001d\b\u0001\"\u0011\u0003j\"9!Q\u001e\u0001\u0005B\t=\bb\u0002B}\u0001\u0011\u0005!1 \u0005\b\u0007\u0007\u0001A\u0011AB\u0003\u0011\u001d\u0019i\u0001\u0001C\u0001\u0007\u000bAqaa\u0004\u0001\t\u0003\u0019\t\u0002C\u0004\u0004\u0010\u0001!\ta!\b\t\u000f\rU\u0002\u0001\"\u0011\u00048!91q\b\u0001\u0005\n\r\u0005\u0003\"CB%\u0001\u0001\u0007I\u0011BB&\u0011%\u0019\u0019\u0006\u0001a\u0001\n\u0013\u0019)\u0006\u0003\u0005\u0004Z\u0001\u0001\u000b\u0015BB'\u0011\u001d\u0019i\u0006\u0001C\u0001\u0003GD!ba\u0018\u0001\u0011\u000b\u0007I\u0011BB1\u0011\u001d\u0019\u0019\u0007\u0001C\u0001\u0007KBqaa\u001a\u0001\t\u0003\u0019I\u0007C\u0004\u0004h\u0001!\taa\u001f\t\u0013\r}\u0004\u00011A\u0005\n\r-\u0003\"CBA\u0001\u0001\u0007I\u0011BBB\u0011!\u00199\t\u0001Q!\n\r5\u0003bBBF\u0001\u0011\u00053Q\u0012\u0005\t\u0007\u001f\u0003A\u0011\t2\u0002d\"A1\u0011\u0013\u0001\u0005B\t\u001c\u0019\nC\u0005\u0004\u0016\u0002\u0001\r\u0011\"\u0001\u0004L!I1q\u0013\u0001A\u0002\u0013\u00051\u0011\u0014\u0005\t\u0007;\u0003\u0001\u0015)\u0003\u0004N!91\u0011\u0015\u0001\u0005\u0002\u0005\r\bbBBR\u0001\u0011E1Q\u0015\u0005\b\u0007O\u0003A\u0011CAr\u0011%\u0019I\u000b\u0001b\u0001\n\u0013\u0019Y\u000b\u0003\u0005\u0004B\u0002\u0001\u000b\u0011BBW\u0011\u001d\u0019\u0019\r\u0001C\u0005\u0007\u000bDqa!;\u0001\t\u000b\u0019Y\u000fC\u0004\u0004z\u0002!\taa?\t\u000f\u0011\u001d\u0001\u0001\"\u0001\u0005\n!9Aq\u0003\u0001\u0005\n\u0005\r\bb\u0002C\r\u0001\u0011\u0005C1\u0004\u0005\u0007\t;\u0001A\u0011I8\u0007\r\tu\u0004A\u0001B@\u0011)\u0011Ii\u0016B\u0001B\u0003%!1\u0012\u0005\u000b\u0005O;&\u0011!Q\u0001\f\u0005=\u0002bBA+/\u0012\u0005!\u0011\u0016\u0005\t\u0005g;\u0006\u0015!\u0004\u00036\"A!1X,!\u0002\u001b\u0011i\fC\u0004\u0003P^#)A!5\t\u000f\tuw\u000b\"\u0001\u0003`\ny\u0011i\u0019;peNK8\u000f^3n\u00136\u0004HN\u0003\u0002bE\u0006)\u0011m\u0019;pe*\u00111\rZ\u0001\u0006a\u0016\\7n\u001c\u0006\u0003K\u001a\fa!\u00199bG\",'\"A4\u0002\u0007=\u0014xm\u0005\u0002\u0001SB\u0011!n[\u0007\u0002A&\u0011A\u000e\u0019\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\u0005]\u0006lWm\u0001\u0001\u0016\u0003A\u0004\"!\u001d>\u000f\u0005ID\bCA:w\u001b\u0005!(BA;o\u0003\u0019a$o\\8u})\tq/A\u0003tG\u0006d\u0017-\u0003\u0002zm\u00061\u0001K]3eK\u001aL!a\u001f?\u0003\rM#(/\u001b8h\u0015\tIh/A\u0003oC6,\u0007%A\tbaBd\u0017nY1uS>t7i\u001c8gS\u001e\u0004B!!\u0001\u0002\u00105\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0003\u0013\tY!\u0001\u0005usB,7/\u00194f\u0015\t\ti!A\u0002d_6LA!!\u0005\u0002\u0004\t11i\u001c8gS\u001e\f1b\u00197bgNdu.\u00193feB!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011\u0001\u00027b]\u001eT!!a\b\u0002\t)\fg/Y\u0005\u0005\u0003G\tIBA\u0006DY\u0006\u001c8\u000fT8bI\u0016\u0014\u0018a\u00063fM\u0006,H\u000e^#yK\u000e,H/[8o\u0007>tG/\u001a=u!\u0019\tI#a\u000b\u000205\ta/C\u0002\u0002.Y\u0014aa\u00149uS>t\u0007\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005Ub/\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\u000f\u00024\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u000eOV\f'\u000fZ5b]B\u0013x\u000e]:\u0016\u0005\u0005}\u0002CBA\u0015\u0003W\t\t\u0005E\u0002k\u0003\u0007J1!!\u0012a\u0005\u0015\u0001&o\u001c9t\u000399W/\u0019:eS\u0006t\u0007K]8qg\u0002\nQa]3ukB\u0004B!!\u0014\u0002R5\u0011\u0011q\n\u0006\u0004\u0003\u0013\u0002\u0017\u0002BA*\u0003\u001f\u0012\u0001#Q2u_J\u001c\u0016p\u001d;f[N+G/\u001e9\u0002\rqJg.\u001b;?)9\tI&a\u0017\u0002^\u0005}\u0013\u0011MA2\u0003K\u0002\"A\u001b\u0001\t\u000b5L\u0001\u0019\u00019\t\u000byL\u0001\u0019A@\t\u000f\u0005M\u0011\u00021\u0001\u0002\u0016!9\u0011QE\u0005A\u0002\u0005\u001d\u0002bBA\u001e\u0013\u0001\u0007\u0011q\b\u0005\b\u0003\u0013J\u0001\u0019AA&\u0003\r)\u0018\u000eZ\u000b\u0003\u0003W\u0002B!!\u000b\u0002n%\u0019\u0011q\u000e<\u0003\t1{gnZ\u0001\u0005k&$\u0007%A\u000bm_\u001e$U-\u00193MKR$XM\u001d'jgR,g.\u001a:\u0016\u0005\u0005]\u0004CBA\u0015\u0003W\tI\bE\u0002k\u0003wJ1!! a\u0005!\t5\r^8s%\u00164\u0017!\u00077pO\u0012+\u0017\r\u001a'fiR,'\u000fT5ti\u0016tWM]0%KF$B!a!\u0002\nB!\u0011\u0011FAC\u0013\r\t9I\u001e\u0002\u0005+:LG\u000fC\u0005\u0002\f6\t\t\u00111\u0001\u0002x\u0005\u0019\u0001\u0010J\u0019\u0002-1|w\rR3bI2+G\u000f^3s\u0019&\u001cH/\u001a8fe\u0002B3ADAI!\u0011\tI#a%\n\u0007\u0005UeO\u0001\u0005w_2\fG/\u001b7f\u00039yF-\u001f8b[&\u001c\u0017iY2fgN,\"!a'\u0011\u0007)\fi*C\u0002\u0002 \u0002\u0014Q\u0002R=oC6L7-Q2dKN\u001c\u0018aD0es:\fW.[2BG\u000e,7o\u001d\u0011\u0002\u0011M,G\u000f^5oON,\"!a*\u0011\t\u0005%\u0016q\u0016\b\u0004U\u0006-\u0016bAAWA\u0006Y\u0011i\u0019;peNK8\u000f^3n\u0013\u0011\t\t,a-\u0003\u0011M+G\u000f^5oONT1!!,a\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%\u0001\rv]\u000e\fWo\u001a5u\u000bb\u001cW\r\u001d;j_:D\u0015M\u001c3mKJ,\"!a/\u0011\t\u0005u\u00161\u0019\b\u0005\u0003/\ty,\u0003\u0003\u0002B\u0006e\u0011A\u0002+ie\u0016\fG-\u0003\u0003\u0002F\u0006\u001d'\u0001G+oG\u0006,x\r\u001b;Fq\u000e,\u0007\u000f^5p]\"\u000bg\u000e\u001a7fe*!\u0011\u0011YA\r\u00035!\bN]3bI\u001a\u000b7\r^8ssV\u0011\u0011Q\u001a\t\u0005\u0003\u001f\f).\u0004\u0002\u0002R*\u0019\u00111\u001b2\u0002\u0011\u0011L7\u000f]1uG\"LA!a6\u0002R\nARj\u001c8ji>\u0014\u0018M\u00197f)\"\u0014X-\u00193GC\u000e$xN]=\u0002\u001dQD'/Z1e\r\u0006\u001cGo\u001c:zA\u0005\u00192M]3bi\u0016$\u0015P\\1nS\u000e\f5mY3tgR\u0011\u00111T\u0001\u000eIft\u0017-\\5d\u0003\u000e\u001cWm]:\u0002!1|wmQ8oM&<WO]1uS>tGCAAB\u0003)\u0019\u0018p\u001d;f[&k\u0007\u000f\\\u000b\u0003\u00033\nQb]=ti\u0016l\u0017i\u0019;pe>3GCBA=\u0003[\f\t\u0010C\u0004\u0002pj\u0001\r!!\u0011\u0002\u000bA\u0014x\u000e]:\t\u000b5T\u0002\u0019\u00019\u0002\u000f\u0005\u001cGo\u001c:PMR1\u0011\u0011PA|\u0003sDq!a<\u001c\u0001\u0004\t\t\u0005C\u0003n7\u0001\u0007\u0001\u000f\u0006\u0003\u0002z\u0005u\bbBAx9\u0001\u0007\u0011\u0011I\u0001\u0005gR|\u0007\u000f\u0006\u0003\u0002\u0004\n\r\u0001BB1\u001e\u0001\u0004\tI(A\u0006fm\u0016tGo\u0015;sK\u0006lWC\u0001B\u0005!\u0011\u0011YA!\u0005\u000e\u0005\t5!b\u0001B\bE\u0006)QM^3oi&!!1\u0003B\u0007\u0005-)e/\u001a8u'R\u0014X-Y7\u0002\u0019\u00154XM\u001c;TiJ,\u0017-\u001c\u0011\u0002\u00131|wMR5mi\u0016\u0014XC\u0001B\u000e!\u0011\u0011YA!\b\n\t\t}!Q\u0002\u0002\u000e\u0019><w-\u001b8h\r&dG/\u001a:\u0002\u00151|wMR5mi\u0016\u0014\b%A\u0007nCJ\\WM\u001d'pO\u001eLgn\u001a\t\u0005\u0005\u0017\u00119#\u0003\u0003\u0003*\t5!\u0001F'be.,'\u000fT8hO&tw-\u00113baR,'/A\u0002m_\u001e,\"Aa\f\u0011\t\t-!\u0011G\u0005\u0005\u0005g\u0011iA\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\ng\u000eDW\rZ;mKJ,\"Aa\u000f\u0011\u0007)\u0014i$C\u0002\u0003@\u0001\u0014\u0011bU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%\u0001\u0005qe>4\u0018\u000eZ3s+\t\u00119\u0005E\u0002k\u0005\u0013J1Aa\u0013a\u0005A\t5\r^8s%\u00164\u0007K]8wS\u0012,'/A\u0005qe>4\u0018\u000eZ3sA\u0005YA-Z1e\u0019\u0016$H/\u001a:t+\t\tI(A\u0005nC&d'm\u001c=fgV\u0011!q\u000b\t\u0005\u0003\u001f\u0014I&\u0003\u0003\u0003\\\u0005E'!C'bS2\u0014w\u000e_3t\u0003)i\u0017-\u001b7c_b,7\u000fI\u0001\fI&\u001c\b/\u0019;dQ\u0016\u00148/\u0006\u0002\u0003dA!\u0011q\u001aB3\u0013\u0011\u00119'!5\u0003\u0017\u0011K7\u000f]1uG\",'o]\u0001\rI&\u001c\b/\u0019;dQ\u0016\u00148\u000fI\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014XC\u0001B8!\u0011\t\tD!\u001d\n\t\tM\u00141\u0007\u0002\u0019\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u0014\u0018a\u00033jgB\fGo\u00195fe\u0002\nA\u0003^3s[&t\u0017\r^5p]\u000e\u000bG\u000e\u001c2bG.\u001c\b#\u0002B>/\n\u0005X\"\u0001\u0001\u0003)Q+'/\\5oCRLwN\\\"bY2\u0014\u0017mY6t+\u0011\u0011\tI!&\u0014\u0007]\u0013\u0019\t\u0005\u0003\u0002*\t\u0015\u0015b\u0001BDm\n1\u0011I\\=SK\u001a\f!#\u001e9TiJ,\u0017-\u001c+fe6Lg.\u0019;fIB1\u0011\u0011\u0007BG\u0005#KAAa$\u00024\t1a)\u001e;ve\u0016\u0004BAa%\u0003\u00162\u0001Aa\u0002BL/\n\u0007!\u0011\u0014\u0002\u0002)F!!1\u0014BQ!\u0011\tIC!(\n\u0007\t}eOA\u0004O_RD\u0017N\\4\u0011\t\u0005%\"1U\u0005\u0004\u0005K3(aA!os\u0006\u0011Qm\u0019\u000b\u0005\u0005W\u0013\t\f\u0006\u0003\u0003.\n=\u0006#\u0002B>/\nE\u0005b\u0002BT5\u0002\u000f\u0011q\u0006\u0005\b\u0005\u0013S\u0006\u0019\u0001BF\u0003\u0011!wN\\3\u0011\r\u0005E\"q\u0017BI\u0013\u0011\u0011I,a\r\u0003\u000fA\u0013x.\\5tK\u0006\u0019!/\u001a4\u0011\r\t}&1\u001aB[\u001b\t\u0011\tM\u0003\u0003\u0003D\n\u0015\u0017AB1u_6L7M\u0003\u0003\u00026\t\u001d'\u0002\u0002Be\u0003;\tA!\u001e;jY&!!Q\u001aBa\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0017aA1eIR!\u00111\u0011Bj\u0011\u001d\u0011).\u0018a\u0001\u0005/\f\u0011A\u001d\t\u0005\u0003/\u0011I.\u0003\u0003\u0003\\\u0006e!\u0001\u0003*v]:\f'\r\\3\u0002#Q,'/\\5oCRLwN\u001c$viV\u0014X-\u0006\u0002\u0003\fB\u0019!Na9\n\u0007\t\u0015\bM\u0001\u0006UKJl\u0017N\\1uK\u0012\fab\u001e5f]R+'/\\5oCR,G-\u0006\u0002\u0003lB1\u0011\u0011\u0007BG\u0005C\f\u0011cZ3u/\",g\u000eV3s[&t\u0017\r^3e+\t\u0011\t\u0010\u0005\u0004\u0003t\nU(\u0011]\u0007\u0003\u0005\u000bLAAa>\u0003F\ny1i\\7qY\u0016$\u0018n\u001c8Ti\u0006<W-\u0001\u0006m_>\\W\u000f\u001d*p_R,\"A!@\u0011\u0007)\u0014y0C\u0002\u0004\u0002\u0001\u0014\u0001#\u00138uKJt\u0017\r\\!di>\u0014(+\u001a4\u0002\u0011\u001d,\u0018M\u001d3jC:,\"aa\u0002\u0011\u0007)\u001cI!C\u0002\u0004\f\u0001\u0014Q\u0002T8dC2\f5\r^8s%\u00164\u0017AD:zgR,WnR;be\u0012L\u0017M\\\u0001\u0005I\u0011Lg\u000f\u0006\u0003\u0004\u0014\re\u0001c\u00016\u0004\u0016%\u00191q\u00031\u0003\u0013\u0005\u001bGo\u001c:QCRD\u0007BBB\u000em\u0001\u0007\u0001/A\u0005bGR|'OT1nKR!11CB\u0010\u0011\u001d\u0019\tc\u000ea\u0001\u0007G\tA\u0001]1uQB)1QEB\u0018a:!1qEB\u0016\u001d\r\u00198\u0011F\u0005\u0002o&\u00191Q\u0006<\u0002\u000fA\f7m[1hK&!1\u0011GB\u001a\u0005!IE/\u001a:bE2,'bAB\u0017m\u0006i1\r\\1tg&\u001c7+_:uK6,\"a!\u000f\u0011\u0007)\u001cY$C\u0002\u0004>\u0001\u00141\"Q2u_J\u001c\u0016p\u001d;f[\u0006Q\u0011\r\u001c7N_\u0012,H.Z:\u0016\u0005\r\r\u0003#BB\u0013\u0007\u000b\u0002\u0018\u0002BB$\u0007g\u0011A\u0001T5ti\u0006aq,\u001b8ji&\fG.\u001b>fIV\u00111Q\n\t\u0005\u0003S\u0019y%C\u0002\u0004RY\u0014qAQ8pY\u0016\fg.\u0001\t`S:LG/[1mSj,Gm\u0018\u0013fcR!\u00111QB,\u0011%\tYiOA\u0001\u0002\u0004\u0019i%A\u0007`S:LG/[1mSj,G\r\t\u0015\u0004y\u0005E\u0015!E1tg\u0016\u0014H/\u00138ji&\fG.\u001b>fI\u00061ql\u001d;beR,\"Aa\u001f\u0002\u000bM$\u0018M\u001d;\u0015\u0005\tm\u0014!\u0006:fO&\u001cH/\u001a:P]R+'/\\5oCRLwN\\\u000b\u0005\u0007W\u001aI\b\u0006\u0003\u0002\u0004\u000e5\u0004\u0002CB8\u0001\u0012\u0005\ra!\u001d\u0002\t\r|G-\u001a\t\u0007\u0003S\u0019\u0019ha\u001e\n\u0007\rUdO\u0001\u0005=Eft\u0017-\\3?!\u0011\u0011\u0019j!\u001f\u0005\u000f\t]\u0005I1\u0001\u0003\u001aR!\u00111QB?\u0011\u001d\u0019y'\u0011a\u0001\u0005/\f1\u0002^3s[&t\u0017\r^5oO\u0006yA/\u001a:nS:\fG/\u001b8h?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u000e\u0015\u0005\"CAF\u0007\u0006\u0005\t\u0019AB'\u00031!XM]7j]\u0006$\u0018N\\4!Q\r!\u0015\u0011S\u0001\ni\u0016\u0014X.\u001b8bi\u0016$\"Aa;\u0002\u001d\u0019Lg.\u00197UKJl\u0017N\\1uK\u0006i\u0011n\u001d+fe6Lg.\u0019;j]\u001e$\"a!\u0014\u0002\u0011\u0005\u0014wN\u001d;j]\u001e\fA\"\u00192peRLgnZ0%KF$B!a!\u0004\u001c\"I\u00111R%\u0002\u0002\u0003\u00071QJ\u0001\nC\n|'\u000f^5oO\u0002B3ASAI\u0003\u0015\t'm\u001c:u\u0003=\u0019'/Z1uKN\u001b\u0007.\u001a3vY\u0016\u0014HC\u0001B\u001e\u00035\u0019Ho\u001c9TG\",G-\u001e7fe\u0006QQ\r\u001f;f]NLwN\\:\u0016\u0005\r5\u0006\u0003\u0003Bz\u0007_\u001b\u0019La!\n\t\rE&Q\u0019\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0007BB[\u0007{\u0003RA[B\\\u0007wK1a!/a\u0005-)\u0005\u0010^3og&|g.\u00133\u0011\t\tM5Q\u0018\u0003\f\u0007\u007f{\u0015\u0011!A\u0001\u0006\u0003\u0011IJA\u0002`II\n1\"\u001a=uK:\u001c\u0018n\u001c8tA\u0005ia-\u001b8e\u000bb$XM\\:j_:,Baa2\u0004LR!1\u0011ZBk!\u0011\u0011\u0019ja3\u0005\u000f\t]\u0005K1\u0001\u0004NF!!1TBh!\rQ7\u0011[\u0005\u0004\u0007'\u0004'!C#yi\u0016t7/[8o\u0011\u001d\u00199\u000e\u0015a\u0001\u00073\f1!\u001a=u!\u0015Q7qWBeQ\r\u00016Q\u001c\t\u0005\u0007?\u001c)/\u0004\u0002\u0004b*\u001911\u001d<\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004h\u000e\u0005(a\u0002;bS2\u0014XmY\u0001\u0012e\u0016<\u0017n\u001d;fe\u0016CH/\u001a8tS>tW\u0003BBw\u0007c$Baa<\u0004tB!!1SBy\t\u001d\u00119*\u0015b\u0001\u0007\u001bDqaa6R\u0001\u0004\u0019)\u0010E\u0003k\u0007o\u001by\u000fK\u0002R\u0007;\f\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u0016\t\ruH\u0011\u0001\u000b\u0005\u0007\u007f$\u0019\u0001\u0005\u0003\u0003\u0014\u0012\u0005Aa\u0002BL%\n\u00071Q\u001a\u0005\b\u0007/\u0014\u0006\u0019\u0001C\u0003!\u0015Q7qWB\u0000\u00031A\u0017m]#yi\u0016t7/[8o)\u0011\u0019i\u0005b\u0003\t\u000f\r]7\u000b1\u0001\u0005\u000eA\"Aq\u0002C\n!\u0015Q7q\u0017C\t!\u0011\u0011\u0019\nb\u0005\u0005\u0019\u0011UA1BA\u0001\u0002\u0003\u0015\ta!4\u0003\u0007}#3'\u0001\bm_\u0006$W\t\u001f;f]NLwN\\:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001]\u0001\naJLg\u000e\u001e+sK\u0016D3\u0001\u0001C\u0011!\u0011!\u0019\u0003b\n\u000e\u0005\u0011\u0015\"bABrE&!A\u0011\u0006C\u0013\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
@InternalApi
public class ActorSystemImpl
extends ExtendedActorSystem {
    private ActorSystemImpl _start;
    private final String name;
    private final ClassLoader classLoader;
    private final Option<Props> guardianProps;
    private final long uid;
    private volatile Option<ActorRef> logDeadLetterListener;
    private final DynamicAccess _dynamicAccess;
    private final ActorSystem.Settings settings;
    private final MonitorableThreadFactory threadFactory;
    private final EventStream eventStream;
    private final LoggingFilter logFilter;
    public final MarkerLoggingAdapter org$apache$pekko$actor$ActorSystemImpl$$markerLogging;
    private final LoggingAdapter log;
    private final Scheduler scheduler;
    private final ActorRefProvider provider;
    private final Mailboxes mailboxes;
    private final Dispatchers dispatchers;
    private final ExecutionContextExecutor dispatcher;
    private final TerminationCallbacks<Terminated> terminationCallbacks;
    private volatile boolean _initialized;
    private volatile boolean terminating;
    private volatile boolean aborting;
    private final ConcurrentHashMap<ExtensionId<?>, Object> extensions;
    private volatile boolean bitmap$0;

    @Override
    public String name() {
        return this.name;
    }

    public Option<Props> guardianProps() {
        return this.guardianProps;
    }

    @Override
    public long uid() {
        return this.uid;
    }

    private Option<ActorRef> logDeadLetterListener() {
        return this.logDeadLetterListener;
    }

    private void logDeadLetterListener_$eq(Option<ActorRef> x$1) {
        this.logDeadLetterListener = x$1;
    }

    private DynamicAccess _dynamicAccess() {
        return this._dynamicAccess;
    }

    @Override
    public final ActorSystem.Settings settings() {
        return this.settings;
    }

    public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return new Thread.UncaughtExceptionHandler(this){
            private final /* synthetic */ ActorSystemImpl $outer;

            public void uncaughtException(Thread thread, Throwable cause) {
                if (!NonFatal$.MODULE$.unapply(cause).isEmpty() ? true : (cause instanceof InterruptedException ? true : (cause instanceof NotImplementedError ? true : cause instanceof ControlThrowable))) {
                    this.$outer.log().error(cause, "Uncaught error from thread [{}]", (Object)thread.getName());
                    return;
                }
                if (cause instanceof IncompatibleClassChangeError && cause.getMessage().startsWith("org.apache.pekko")) {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(578).append("Detected ").append(cause.getClass().getName()).append(" error, which MAY be caused by incompatible Pekko versions on the classpath.\n                  | Please note that a given Pekko version MUST be the same across all modules of Pekko that you are using,\n                  | e.g. if you use pekko-actor [").append(Version$.MODULE$.current()).append(" (resolved from current classpath)] all other core\n                  | Pekko modules MUST be of the same version. External projects like Connectors, Persistence plugins or Pekko\n                  | HTTP etc. have their own version numbers - please make sure you're using a compatible set of libraries.\n                 ").toString())).stripMargin().replaceAll("[\r\n]", ""));
                }
                if (this.$outer.settings().JvmExitOnFatalError()) {
                    try {
                        this.logFatalError("shutting down JVM since 'pekko.jvm-exit-on-fatal-error' is enabled for", cause, thread);
                    }
                    finally {
                        System.exit(-1);
                    }
                    return;
                }
                try {
                    this.logFatalError("shutting down", cause, thread);
                }
                finally {
                    this.$outer.terminate();
                }
            }

            private void logFatalError(String message, Throwable cause, Thread thread) {
                System.err.print("Uncaught error from thread [");
                System.err.print(thread.getName());
                System.err.print("]: ");
                System.err.print(cause.getMessage());
                System.err.print(", ");
                System.err.print(message);
                System.err.print(" ActorSystem[");
                System.err.print(this.$outer.name());
                System.err.println("]");
                System.err.flush();
                cause.printStackTrace(System.err);
                System.err.flush();
                this.$outer.org$apache$pekko$actor$ActorSystemImpl$$markerLogging.error(LogMarker$.MODULE$.Security(), cause, new StringBuilder(51).append("Uncaught error from thread [{}]: ").append(cause.getMessage()).append(", ").append(message).append(" ActorSystem[{}]").toString(), (Object)thread.getName(), (Object)this.$outer.name());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    @Override
    public final MonitorableThreadFactory threadFactory() {
        return this.threadFactory;
    }

    public DynamicAccess createDynamicAccess() {
        return new ReflectiveDynamicAccess(this.classLoader);
    }

    @Override
    public DynamicAccess dynamicAccess() {
        return this._dynamicAccess();
    }

    @Override
    public void logConfiguration() {
        this.log().info(this.settings().toString());
    }

    @Override
    public ActorSystemImpl systemImpl() {
        return this;
    }

    @Override
    public ActorRef systemActorOf(Props props, String name) {
        return this.systemGuardian().underlying().attachChild(props, name, true);
    }

    @Override
    public ActorRef actorOf(Props props, String name) {
        if (this.guardianProps().isEmpty()) {
            return this.guardian().underlying().attachChild(props, name, false);
        }
        throw new UnsupportedOperationException(new StringBuilder(90).append("cannot create top-level actor [").append(name).append("] from the outside on ActorSystem with custom user guardian").toString());
    }

    @Override
    public ActorRef actorOf(Props props) {
        if (this.guardianProps().isEmpty()) {
            return this.guardian().underlying().attachChild(props, false);
        }
        throw new UnsupportedOperationException("cannot create top-level actor from the outside on ActorSystem with custom user guardian");
    }

    @Override
    public void stop(ActorRef actor) {
        ActorPath path = actor.path();
        ActorPath guard = this.guardian().path();
        ActorPath sys = this.systemGuardian().path();
        ActorPath actorPath = path.parent();
        ActorPath actorPath2 = guard;
        if (!(actorPath2 != null ? !actorPath2.equals(actorPath) : actorPath != null)) {
            LocalActorRef qual$1 = this.guardian();
            StopChild x$1 = new StopChild(actor);
            ActorRef x$2 = qual$1.$bang$default$2(x$1);
            qual$1.$bang(x$1, x$2);
            return;
        }
        ActorPath actorPath3 = sys;
        if (!(actorPath3 != null ? !actorPath3.equals(actorPath) : actorPath != null)) {
            LocalActorRef qual$2 = this.systemGuardian();
            StopChild x$3 = new StopChild(actor);
            ActorRef x$4 = qual$2.$bang$default$2(x$3);
            qual$2.$bang(x$3, x$4);
            return;
        }
        ((InternalActorRef)actor).stop();
    }

    @Override
    public EventStream eventStream() {
        return this.eventStream;
    }

    @Override
    public LoggingFilter logFilter() {
        return this.logFilter;
    }

    @Override
    public LoggingAdapter log() {
        return this.log;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public ActorRefProvider provider() {
        return this.provider;
    }

    @Override
    public ActorRef deadLetters() {
        return this.provider().deadLetters();
    }

    @Override
    public Mailboxes mailboxes() {
        return this.mailboxes;
    }

    @Override
    public Dispatchers dispatchers() {
        return this.dispatchers;
    }

    @Override
    public ExecutionContextExecutor dispatcher() {
        return this.dispatcher;
    }

    @Override
    public Future<Terminated> whenTerminated() {
        return this.terminationCallbacks.terminationFuture();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletionStage<Terminated> getWhenTerminated() {
        void asJava$extension_$this;
        Future<Terminated> future = FutureConverters$.MODULE$.FutureOps(this.whenTerminated());
        if (FutureConverters$FutureOps$.MODULE$ == null) {
            throw null;
        }
        if (FutureConverters$.MODULE$ == null) {
            throw null;
        }
        return scala.compat.java8.FutureConverters$.MODULE$.toJava((Future)asJava$extension_$this);
    }

    @Override
    public InternalActorRef lookupRoot() {
        return this.provider().rootGuardian();
    }

    @Override
    public LocalActorRef guardian() {
        return this.provider().guardian();
    }

    @Override
    public LocalActorRef systemGuardian() {
        return this.provider().systemGuardian();
    }

    @Override
    public ActorPath $div(String actorName) {
        return this.guardian().path().$div(actorName);
    }

    @Override
    public ActorPath $div(Iterable<String> path) {
        return this.guardian().path().$div(path);
    }

    @Override
    public ActorSystem classicSystem() {
        return this;
    }

    private List<String> allModules() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pekko-actor", "pekko-actor-testkit-typed", "pekko-actor-typed", "pekko-cluster", "pekko-cluster-metrics", "pekko-cluster-sharding", "pekko-cluster-sharding-typed", "pekko-cluster-tools", "pekko-cluster-typed", "pekko-coordination", "pekko-discovery", "pekko-distributed-data", "pekko-testkit", "pekko-multi-node-testkit", "pekko-osgi", "pekko-persistence", "pekko-persistence-query", "pekko-persistence-shared", "pekko-persistence-testkit", "pekko-persistence-typed", "pekko-pki", "pekko-protobuf", "pekko-protobuf-v3", "pekko-remote", "pekko-serialization-jackson", "pekko-slf4j", "pekko-stream", "pekko-stream-testkit", "pekko-stream-typed", "pekko-stream-testkit"}));
    }

    private boolean _initialized() {
        return this._initialized;
    }

    private void _initialized_$eq(boolean x$1) {
        this._initialized = x$1;
    }

    public void assertInitialized() {
        if (!this._initialized()) {
            throw new IllegalStateException("The calling code expected that the ActorSystem was initialized but it wasn't yet. This is probably a bug in the ActorSystem initialization sequence often related to initialization of extensions. Please report at https://github.com/apache/pekko/issues.");
        }
    }

    private ActorSystemImpl _start$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this._start = this.liftedTree2$1();
                this.bitmap$0 = true;
            }
        }
        return this._start;
    }

    private ActorSystemImpl _start() {
        if (!this.bitmap$0) {
            return this._start$lzycompute();
        }
        return this._start;
    }

    public ActorSystemImpl start() {
        return this._start();
    }

    @Override
    public <T> void registerOnTermination(Function0<T> code) {
        this.registerOnTermination(new Runnable(null, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    @Override
    public void registerOnTermination(Runnable code) {
        this.terminationCallbacks.add(code);
    }

    private boolean terminating() {
        return this.terminating;
    }

    private void terminating_$eq(boolean x$1) {
        this.terminating = x$1;
    }

    @Override
    public Future<Terminated> terminate() {
        this.terminating_$eq(true);
        if (this.settings().CoordinatedShutdownRunByActorSystemTerminate() && !this.aborting()) {
            ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this)).run(CoordinatedShutdown$ActorSystemTerminateReason$.MODULE$);
        } else {
            this.finalTerminate();
        }
        return this.whenTerminated();
    }

    @Override
    public void finalTerminate() {
        this.terminating_$eq(true);
        if (!this.settings().LogDeadLettersDuringShutdown()) {
            this.logDeadLetterListener().foreach((Function1 & Serializable & scala.Serializable)actor -> {
                this.stop(actor);
                return BoxedUnit.UNIT;
            });
        }
        this.guardian().stop();
    }

    @Override
    public boolean isTerminating() {
        return this.terminating() || this.aborting() || ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this)).shutdownReason().isDefined();
    }

    public boolean aborting() {
        return this.aborting;
    }

    public void aborting_$eq(boolean x$1) {
        this.aborting = x$1;
    }

    public void abort() {
        this.aborting_$eq(true);
        this.terminate();
    }

    public Scheduler createScheduler() {
        return (Scheduler)this.dynamicAccess().createInstanceFor(this.settings().SchedulerClass(), (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)this.settings().config()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class), (Object)this.log()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ThreadFactory.class), (Object)this.threadFactory().withName(new StringBuilder(10).append(this.threadFactory().name()).append("-scheduler").toString())), (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(Scheduler.class)).get();
    }

    public void stopScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            ((Closeable)((Object)scheduler)).close();
            return;
        }
    }

    private ConcurrentHashMap<ExtensionId<?>, Object> extensions() {
        return this.extensions;
    }

    private <T extends Extension> T findExtension(ExtensionId<T> ext) {
        Object object;
        while ((object = this.extensions().get(ext)) instanceof CountDownLatch) {
            CountDownLatch countDownLatch = (CountDownLatch)object;
            package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                long awaitMillis = this.settings().CreationTimeout().duration().toMillis();
                if (!countDownLatch.await(awaitMillis, TimeUnit.MILLISECONDS)) {
                    ExtensionId extensionId = ext;
                    SerializationExtension$ serializationExtension$ = SerializationExtension$.MODULE$;
                    throw new IllegalStateException(new StringBuilder(43).append("Initialization of [").append(ext).append("] took more than [").append(awaitMillis).append(" ms]. ").append((Object)(!(extensionId != null ? !((Object)extensionId).equals(serializationExtension$) : serializationExtension$ != null) ? "A serializer must not access the SerializationExtension from its constructor. Use lazy init." : "Could be deadlock due to cyclic initialization of extensions.")).toString());
                }
            });
        }
        if (object instanceof Throwable) {
            throw (Throwable)object;
        }
        return (T)((Extension)object);
    }

    @Override
    public final <T extends Extension> T registerExtension(ExtensionId<T> ext) {
        T t;
        while ((t = this.findExtension(ext)) == null) {
            T t2;
            CountDownLatch inProcessOfRegistration = new CountDownLatch(1);
            if (this.extensions().putIfAbsent(ext, inProcessOfRegistration) != null) continue;
            try {
                try {
                    T t3 = ext.createExtension(this);
                    if (t3 == null) {
                        throw new IllegalStateException(new StringBuilder(53).append("Extension instance created as 'null' for extension [").append(ext).append("]").toString());
                    }
                    this.extensions().replace(ext, inProcessOfRegistration, t3);
                    t2 = t3;
                }
                catch (Throwable t4) {
                    this.extensions().replace(ext, inProcessOfRegistration, t4);
                    throw t4;
                }
            }
            finally {
                inProcessOfRegistration.countDown();
            }
            return t2;
        }
        return t;
    }

    @Override
    public <T extends Extension> T extension(ExtensionId<T> ext) {
        T t = this.findExtension(ext);
        if (t == null) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Trying to get non-registered extension [").append(ext).append("]").toString());
        }
        return t;
    }

    @Override
    public boolean hasExtension(ExtensionId<? extends Extension> ext) {
        return this.findExtension(ext) != null;
    }

    private void loadExtensions() {
        this.loadExtensions$1("pekko.library-extensions", true);
        this.loadExtensions$1("pekko.extensions", false);
    }

    public String toString() {
        return this.lookupRoot().path().root().address().toString();
    }

    @Override
    public String printTree() {
        return ActorSystemImpl.printNode$1(this.lookupRoot(), "");
    }

    private final /* synthetic */ ActorRefProvider liftedTree1$1() {
        try {
            Vector arguments = (Vector)scala.package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Object)this.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ActorSystem.Settings.class), (Object)this.settings()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(EventStream.class), (Object)this.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DynamicAccess.class), (Object)this.dynamicAccess())}));
            return (ActorRefProvider)this.dynamicAccess().createInstanceFor(this.settings().ProviderClass(), (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)arguments, ClassTag$.MODULE$.apply(ActorRefProvider.class)).get();
        }
        catch (Throwable throwable) {
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopScheduler());
                throw e;
            }
            throw throwable;
        }
    }

    private final /* synthetic */ ActorSystemImpl liftedTree2$1() {
        try {
            this.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopScheduler());
            this.provider().init(this);
            this._initialized_$eq(true);
            if (this.settings().LogDeadLetters() > 0) {
                this.logDeadLetterListener_$eq((Option<ActorRef>)new Some((Object)this.systemActorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(DeadLetterListener.class)), "deadLetterListener")));
            }
            this.eventStream().startUnsubscriber();
            ((ManifestInfo)ManifestInfo$.MODULE$.apply(this)).checkSameVersion("Apache Pekko", (scala.collection.immutable.Seq<String>)this.allModules(), true);
            if (!this.terminating()) {
                this.loadExtensions();
            }
            if (this.settings().LogConfigOnStart()) {
                this.logConfiguration();
            }
            return this;
        }
        catch (Throwable throwable) {
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e;
                block9: {
                    e = (Throwable)option.get();
                    try {
                        this.terminate();
                    }
                    catch (Throwable throwable2) {
                        if (!NonFatal$.MODULE$.unapply(throwable2).isEmpty()) {
                            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopScheduler());
                            break block9;
                        }
                        throw throwable2;
                    }
                }
                throw e;
            }
            throw throwable;
        }
    }

    private final void loadExtensions$1(String key, boolean throwOnLoadFail) {
        ((IterableLike)package$JavaConverters$.MODULE$.asScalaBufferConverter(this.settings().config().getStringList(key)).asScala()).foreach((Function1 & Serializable & scala.Serializable)fqcn -> {
            Object p;
            boolean bl = false;
            Success success = null;
            Try try_ = this.dynamicAccess().getObjectFor((String)fqcn, ClassTag$.MODULE$.AnyRef()).recoverWith((PartialFunction)new scala.Serializable(this, (String)fqcn){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ActorSystemImpl $outer;
                private final String fqcn$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    return (B1)this.$outer.dynamicAccess().createInstanceFor(this.fqcn$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.AnyRef()).recoverWith((PartialFunction)new scala.Serializable(null, x1){
                        public static final long serialVersionUID = 0L;
                        private final Throwable x1$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            return (B1)new Failure(this.x1$1);
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            return true;
                        }
                        {
                            this.x1$1 = x1$1;
                        }
                    });
                }

                public final boolean isDefinedAt(Throwable x1) {
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fqcn$1 = fqcn$1;
                }
            });
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Object p2 = success.value();
                if (p2 instanceof ExtensionIdProvider) {
                    ExtensionIdProvider extensionIdProvider = (ExtensionIdProvider)p2;
                    return this.registerExtension(extensionIdProvider.lookup());
                }
            }
            if (bl && (p = success.value()) instanceof ExtensionId) {
                ExtensionId extensionId = (ExtensionId)p;
                return this.registerExtension(extensionId);
            }
            if (bl) {
                if (!throwOnLoadFail) {
                    this.log().error("[{}] is not an 'ExtensionIdProvider' or 'ExtensionId', skipping...", fqcn);
                    return BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(51).append("[").append((String)fqcn).append("] is not an 'ExtensionIdProvider' or 'ExtensionId'").toString());
            }
            if (try_ instanceof Failure) {
                Throwable problem = ((Failure)try_).exception();
                if (!throwOnLoadFail) {
                    this.log().error(problem, "While trying to load extension [{}], skipping...", fqcn);
                    return BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(33).append("While trying to load extension [").append((String)fqcn).append("]").toString(), problem);
            }
            throw new MatchError((Object)try_);
        });
    }

    private static final String printNode$1(ActorRef node, String indent) {
        if (node instanceof ActorRefWithCell) {
            String string;
            String string2;
            Actor realActor;
            Cell cell = ((ActorRefWithCell)node).underlying();
            StringBuilder stringBuilder = new StringBuilder(3).append(indent.isEmpty() ? "-> " : new StringBuilder(4).append((String)new StringOps(Predef$.MODULE$.augmentString(indent)).dropRight(1)).append("\u230a-> ").toString()).append(node.path().name()).append(" ").append(Logging$.MODULE$.simpleName(node)).append(" ").append(cell instanceof ActorCell ? ((realActor = ((ActorCell)cell).actor()) != null ? realActor.getClass() : "null") : Logging$.MODULE$.simpleName(cell));
            if (cell instanceof ActorCell) {
                ActorCell actorCell = (ActorCell)cell;
                string2 = new StringBuilder(8).append(" status=").append(actorCell.mailbox().currentStatus()).toString();
            } else {
                string2 = "";
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string2).append(" ");
            ChildrenContainer childrenContainer = cell.childrenRefs();
            if (childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer) {
                ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer;
                Set<ActorRef> toDie = terminatingChildrenContainer.toDie();
                ChildrenContainer.SuspendReason reason = terminatingChildrenContainer.reason();
                string = new StringBuilder(13).append("Terminating(").append(reason).append(")").append(((TraversableOnce)toDie.toSeq().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).mkString(new StringBuilder(16).append("\n").append(indent).append("   |    toDie: ").toString(), new StringBuilder(16).append("\n").append(indent).append("   |           ").toString(), "")).toString();
            } else if (ChildrenContainer$TerminatedChildrenContainer$.MODULE$.equals(childrenContainer) ? true : ChildrenContainer$EmptyChildrenContainer$.MODULE$.equals(childrenContainer)) {
                string = childrenContainer.toString();
            } else if (childrenContainer instanceof ChildrenContainer.NormalChildrenContainer) {
                ChildrenContainer.NormalChildrenContainer normalChildrenContainer = (ChildrenContainer.NormalChildrenContainer)childrenContainer;
                string = new StringBuilder(9).append(Integer.toString(normalChildrenContainer.c().size())).append(" children").toString();
            } else {
                string = Logging$.MODULE$.simpleName(childrenContainer);
            }
            Seq children = (Seq)cell.childrenRefs().children().toSeq().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            return stringBuilder2.append((Object)string).append((Object)(cell.childrenRefs().children().isEmpty() ? "" : "\n")).append(((TraversableOnce)((Seq)((TraversableLike)children.dropRight(1)).map((Function1 & Serializable & scala.Serializable)x$8 -> ActorSystemImpl.printNode$1(x$8, new StringBuilder(4).append(indent).append("   |").toString()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(children.lastOption().map((Function1 & Serializable & scala.Serializable)x$9 -> ActorSystemImpl.printNode$1(x$9, new StringBuilder(4).append(indent).append("    ").toString()))), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString();
        }
        return new StringBuilder(1).append(indent).append(node.path().name()).append(" ").append(Logging$.MODULE$.simpleName(node)).toString();
    }

    public ActorSystemImpl(String name, Config applicationConfig, ClassLoader classLoader, Option<ExecutionContext> defaultExecutionContext, Option<Props> guardianProps, ActorSystemSetup setup) {
        this.name = name;
        this.classLoader = classLoader;
        this.guardianProps = guardianProps;
        this.uid = ThreadLocalRandom.current().nextLong();
        if (!name.matches("^[a-zA-Z0-9][a-zA-Z0-9-_]*$")) {
            throw new IllegalArgumentException(new StringBuilder(109).append("invalid ActorSystem name [").append(name).append("], must contain only word characters (i.e. [a-zA-Z0-9] plus non-leading '-' or '_')").toString());
        }
        this.logDeadLetterListener = None$.MODULE$;
        this._dynamicAccess = this.createDynamicAccess();
        Config config = ActorSystem$Settings$.MODULE$.amendSlf4jConfig(applicationConfig.withFallback((ConfigMergeable)ConfigFactory.defaultReference((ClassLoader)classLoader)), this._dynamicAccess());
        this.settings = new ActorSystem.Settings(classLoader, config, name, setup);
        this.threadFactory = new MonitorableThreadFactory(name, this.settings().Daemonicity(), (Option<ClassLoader>)Option$.MODULE$.apply((Object)classLoader), this.uncaughtExceptionHandler(), MonitorableThreadFactory$.MODULE$.apply$default$5());
        this.eventStream = new EventStream(this, this.settings().DebugEventStream());
        this.eventStream().startStdoutLogger(this.settings());
        Vector arguments = (Vector)scala.package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ActorSystem.Settings.class), (Object)this.settings()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(EventStream.class), (Object)this.eventStream())}));
        this.logFilter = (LoggingFilter)this.dynamicAccess().createInstanceFor(this.settings().LoggingFilter(), (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)arguments, ClassTag$.MODULE$.apply(LoggingFilter.class)).get();
        this.org$apache$pekko$actor$ActorSystemImpl$$markerLogging = new MarkerLoggingAdapter(this.eventStream(), new StringBuilder(2).append(this.getClass().getName()).append("(").append(name).append(")").toString(), this.getClass(), this.logFilter());
        this.log = this.org$apache$pekko$actor$ActorSystemImpl$$markerLogging;
        this.scheduler = this.createScheduler();
        this.provider = this.liftedTree1$1();
        this.mailboxes = new Mailboxes(this.settings(), this.eventStream(), this.dynamicAccess(), this.deadLetters());
        this.dispatchers = new Dispatchers(this.settings(), new DefaultDispatcherPrerequisites(this.threadFactory(), this.eventStream(), this.scheduler(), this.dynamicAccess(), this.settings(), this.mailboxes(), defaultExecutionContext), this.log());
        this.dispatcher = this.dispatchers().defaultGlobalDispatcher();
        this.terminationCallbacks = new TerminationCallbacks<Terminated>(this, this.provider().terminationFuture(), (ExecutionContext)this.dispatcher());
        this._initialized = false;
        this.terminating = false;
        this.aborting = false;
        this.extensions = new ConcurrentHashMap();
    }

    public final class TerminationCallbacks<T> {
        private final ExecutionContext ec;
        private final Promise<T> done;
        private final AtomicReference<Promise<T>> ref;

        public final void add(Runnable r) {
            Promise addRec$1_p = Promise$.MODULE$.apply();
            while (true) {
                Promise<T> promise;
                if ((promise = this.ref.get()) == null) {
                    throw new RejectedExecutionException("ActorSystem already terminated.");
                }
                if (!this.ref.compareAndSet(promise, addRec$1_p)) continue;
                promise.completeWith(addRec$1_p.future().andThen((PartialFunction)new scala.Serializable(null, r){
                    public static final long serialVersionUID = 0L;
                    private final Runnable r$1;

                    public final <A1 extends Try<T>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        this.r$1.run();
                        return (B1)BoxedUnit.UNIT;
                    }

                    public final boolean isDefinedAt(Try<T> x1) {
                        return true;
                    }
                    {
                        this.r$1 = r$1;
                    }
                }, this.ec));
                return;
            }
        }

        public Future<T> terminationFuture() {
            return this.done.future();
        }

        private final void addRec$1(Runnable r, Promise p) {
            while (true) {
                Promise<T> promise;
                if ((promise = this.ref.get()) == null) {
                    throw new RejectedExecutionException("ActorSystem already terminated.");
                }
                if (!this.ref.compareAndSet(promise, p)) continue;
                promise.completeWith(p.future().andThen((PartialFunction)new /* invalid duplicate definition of identical inner class */, this.ec));
                return;
            }
        }

        public TerminationCallbacks(ActorSystemImpl $outer, Future<T> upStreamTerminated, ExecutionContext ec) {
            this.ec = ec;
            this.done = Promise$.MODULE$.apply();
            this.ref = new AtomicReference<Promise<T>>(this.done);
            upStreamTerminated.onComplete((Function1 & Serializable & scala.Serializable)t -> ((Promise)$this.ref.getAndSet(null)).complete(t), ec);
        }
    }
}

