/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.spring.concurrent;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskDecorator;

public class MetricsTaskDecorator
implements TaskDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsTaskDecorator.class);
    private List<Tag> tags;
    private MeterRegistry meterRegistry;

    public MetricsTaskDecorator(List<Tag> tags, MeterRegistry meterRegistry) {
        this.tags = tags;
        this.meterRegistry = meterRegistry;
    }

    public Runnable decorate(Runnable runnable) {
        return new JobMetricsRunnable(runnable);
    }

    private class JobMetricsRunnable
    implements Runnable {
        private final Runnable task;

        private JobMetricsRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                StopWatch stopWatch = StopWatch.createStarted();
                this.task.run();
                stopWatch.stop();
                this.recordTaskCostTime(stopWatch.getTime(TimeUnit.MILLISECONDS));
            }
            catch (Throwable e) {
                log.error("failed to run! task: {}", (Object)this.task.toString(), (Object)e);
            }
        }

        private void recordTaskCostTime(long costInMills) {
            if (MetricsTaskDecorator.this.meterRegistry != null) {
                try {
                    Timer.builder((String)"job_thread_pool_tasks").tags(MetricsTaskDecorator.this.tags).publishPercentileHistogram(Boolean.valueOf(true)).register(MetricsTaskDecorator.this.meterRegistry).record(costInMills, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    log.warn("Fail to record thread pool task timer metrics", (Throwable)e);
                }
            }
        }

        public int hashCode() {
            return this.task.hashCode();
        }

        public boolean equals(Object obj) {
            return this.task.equals(obj);
        }

        public String toString() {
            return "[task-executor-wrapper] task: " + this.task.toString();
        }
    }
}

