/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.persistence;

import cn.sliew.carp.framework.common.model.PageParam;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.mybatis.entity.BaseAuditDO;
import cn.sliew.carp.module.persistence.AbstractPersistenceService;
import cn.sliew.carp.module.persistence.MybatisResourceVisitor;
import cn.sliew.carp.module.persistence.api.selectors.Selector;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Optional;

public class MybatisPersistenceService<R extends BaseAuditDO>
extends AbstractPersistenceService<Long, R> {
    private MybatisResourceVisitor<R> resourceVisitor;
    private BaseMapper<R> baseMapper;

    public MybatisPersistenceService(MybatisResourceVisitor<R> resourceVisitor, BaseMapper<R> baseMapper) {
        this.resourceVisitor = resourceVisitor;
        this.baseMapper = baseMapper;
    }

    @Override
    public Iterable<R> select(Selector selector) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)selector.accept(this.resourceVisitor);
        return this.baseMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public PageResult<R> page(PageParam param, Selector selector) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)selector.accept(this.resourceVisitor);
        Page page = (Page)this.baseMapper.selectPage((IPage)new Page(param.getCurrent().longValue(), param.getPageSize().longValue()), (Wrapper)queryWrapper);
        PageResult pageResult = new PageResult(Long.valueOf(page.getCurrent()), Long.valueOf(page.getSize()), Long.valueOf(page.getTotal()));
        pageResult.setRecords(page.getRecords());
        return pageResult;
    }

    @Override
    public Optional<R> get(Long id) {
        return Optional.ofNullable((BaseAuditDO)this.baseMapper.selectById((Serializable)id));
    }

    @Override
    protected void doAdd(R resource) {
        this.baseMapper.insertOrUpdate(resource);
    }

    @Override
    protected void doUpdate(Long id, R resource) {
        resource.setId(id);
        this.baseMapper.updateById(resource);
    }

    @Override
    protected void doDelete(Long id) {
        this.baseMapper.deleteById((Serializable)id);
    }
}

