/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.persistence;

import cn.sliew.carp.module.persistence.api.PersistenceListener;
import cn.sliew.carp.module.persistence.api.PersistenceService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractPersistenceService<ID, R>
implements PersistenceService<ID, R> {
    private final List<PersistenceListener<R>> listeners = Lists.newArrayList();

    @Override
    public void addListener(PersistenceListener<R> listener) {
        this.listeners.add((PersistenceListener)Preconditions.checkNotNull(listener, (Object)"listener is null"));
    }

    @Override
    public R add(R resource) {
        this.doAdd(resource);
        this.onAdded(resource);
        return resource;
    }

    @Override
    public R update(ID id, Function<R, R> updateFn) {
        Object before = this.getOrThrow(id);
        R after = updateFn.apply(before);
        this.doUpdate(id, after);
        this.onUpdated(before, after);
        return after;
    }

    @Override
    public Optional<R> delete(ID id) {
        Object deleted = this.getOrThrow(id);
        this.doDelete(id);
        this.onDeleted(deleted);
        return Optional.of(deleted);
    }

    private void onAdded(R created) {
        for (PersistenceListener<R> listener : this.listeners) {
            listener.afterAdded(created);
        }
    }

    private void onUpdated(R before, R after) {
        for (PersistenceListener<R> listener : this.listeners) {
            listener.afterUpdated(before, after);
        }
    }

    private void onDeleted(R resource) {
        for (PersistenceListener<R> listener : this.listeners) {
            listener.afterDeleted(resource);
        }
    }

    protected abstract void doAdd(R var1);

    protected abstract void doUpdate(ID var1, R var2);

    protected abstract void doDelete(ID var1);
}

