/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.stopwatch;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.stopwatch.Ticker;
import cn.sliew.milky.common.stopwatch.Tickers;
import java.time.Duration;

public final class Stopwatch {
    private final Ticker ticker;
    private boolean running;
    private long startTimeNS;
    private long elapsedNanos;

    Stopwatch() {
        this.ticker = Tickers.systemTicker();
    }

    Stopwatch(Ticker ticker) {
        this.ticker = Ensures.checkNotNull(ticker, () -> "ticker null");
    }

    public boolean isRunning() {
        return this.running;
    }

    public Stopwatch start() {
        Ensures.checkState(!this.running, () -> "This stopwatch is already running.");
        this.running = true;
        this.startTimeNS = this.ticker.read();
        return this;
    }

    public Stopwatch stop() {
        long tick = this.ticker.read();
        Ensures.checkState(this.running, () -> "This stopwatch is already stopped.");
        this.running = false;
        this.elapsedNanos += tick - this.startTimeNS;
        return this;
    }

    public Stopwatch reset() {
        this.elapsedNanos = 0L;
        this.running = false;
        return this;
    }

    private long elapsedNanos() {
        return this.running ? this.ticker.read() - this.startTimeNS + this.elapsedNanos : this.elapsedNanos;
    }

    public Duration elapsed() {
        return Duration.ofNanos(this.elapsedNanos());
    }
}

