/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.constant;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.constant.Attribute;
import cn.sliew.milky.common.constant.AttributeKey;
import cn.sliew.milky.common.constant.AttributeMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultAttributeMap
implements AttributeMap {
    private static final AtomicReferenceFieldUpdater<DefaultAttributeMap, DefaultAttribute[]> ATTRIBUTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttributeMap.class, DefaultAttribute[].class, "attributes");
    private static final DefaultAttribute[] EMPTY_ATTRIBUTES = new DefaultAttribute[0];
    private volatile DefaultAttribute[] attributes = EMPTY_ATTRIBUTES;

    private static int searchAttributeByKey(DefaultAttribute[] sortedAttributes, AttributeKey<?> key) {
        int low = 0;
        int high = sortedAttributes.length - 1;
        while (low <= high) {
            boolean searchRight;
            int mid = low + high >>> 1;
            DefaultAttribute midVal = sortedAttributes[mid];
            AttributeKey midValKey = midVal.key;
            if (midValKey == key) {
                return mid;
            }
            int midValKeyId = midValKey.id();
            int keyId = key.id();
            assert (midValKeyId != keyId);
            boolean bl = searchRight = midValKeyId < keyId;
            if (searchRight) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    private static void orderedCopyOnInsert(DefaultAttribute[] sortedSrc, int srcLength, DefaultAttribute[] copy, DefaultAttribute toInsert) {
        int i;
        int id = toInsert.key.id();
        for (i = srcLength - 1; i >= 0; --i) {
            DefaultAttribute attribute = sortedSrc[i];
            assert (attribute.key.id() != id);
            if (attribute.key.id() < id) break;
            copy[i + 1] = sortedSrc[i];
        }
        copy[i + 1] = toInsert;
        int toCopy = i + 1;
        if (toCopy > 0) {
            System.arraycopy(sortedSrc, 0, copy, 0, toCopy);
        }
    }

    @Override
    public <T> Collection<Attribute<T>> attrs() {
        return Arrays.asList(this.attributes);
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> key) {
        DefaultAttribute[] newAttributes;
        DefaultAttribute[] attributes;
        Ensures.checkNotNull(key);
        DefaultAttribute<T> newAttribute = null;
        do {
            int index;
            if ((index = DefaultAttributeMap.searchAttributeByKey(attributes = this.attributes, key)) >= 0) {
                DefaultAttribute attribute = attributes[index];
                assert (attribute.key() == key);
                if (!attribute.isRemoved()) {
                    return attribute;
                }
                if (newAttribute == null) {
                    newAttribute = new DefaultAttribute<T>(this, key);
                }
                int count = attributes.length;
                newAttributes = Arrays.copyOf(attributes, count);
                newAttributes[index] = newAttribute;
                continue;
            }
            if (newAttribute == null) {
                newAttribute = new DefaultAttribute<T>(this, key);
            }
            int count = attributes.length;
            newAttributes = new DefaultAttribute[count + 1];
            DefaultAttributeMap.orderedCopyOnInsert(attributes, count, newAttributes, newAttribute);
        } while (!ATTRIBUTES_UPDATER.compareAndSet(this, attributes, newAttributes));
        return newAttribute;
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> key) {
        Ensures.checkNotNull(key);
        return DefaultAttributeMap.searchAttributeByKey(this.attributes, key) >= 0;
    }

    private static final class DefaultAttribute<T>
    extends AtomicReference<T>
    implements Attribute<T> {
        private static final long serialVersionUID = -2661411462200283011L;
        private volatile DefaultAttributeMap attributeMap;
        private final AttributeKey<T> key;

        DefaultAttribute(DefaultAttributeMap attributeMap, AttributeKey<T> key) {
            this.attributeMap = attributeMap;
            this.key = key;
        }

        @Override
        public AttributeKey<T> key() {
            return this.key;
        }

        private boolean isRemoved() {
            return this.attributeMap == null;
        }

        @Override
        public T setIfAbsent(T value) {
            while (!this.compareAndSet(null, value)) {
                Object old = this.get();
                if (old == null) continue;
                return (T)old;
            }
            return null;
        }
    }
}

